/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Asset;
import org.drools.mvel.compiler.AssetCard;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.IndexedNumber;
import org.drools.mvel.compiler.OuterClass;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Target;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.mvel.integrationtests.facts.AFact;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.command.Setter;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class UpdateTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public UpdateTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testModifyBlock() throws Exception {
        this.doModifyTest("test_ModifyBlock.drl");
    }

    @Test
    public void testModifyBlockWithPolymorphism() throws Exception {
        this.doModifyTest("test_ModifyBlockWithPolymorphism.drl");
    }

    private void doModifyTest(String drlResource) throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlResource});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Person bob = new Person("Bob");
        bob.setStatus("hungry");
        Cheese c = new Cheese();
        ksession.insert((Object)bob);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        Assertions.assertThat((int)c.getPrice()).isEqualTo(10);
        Assertions.assertThat((String)bob.getStatus()).isEqualTo("fine");
    }

    @Test
    public void testModifyBlockWithFrom() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ModifyBlockWithFrom.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Person bob = new Person("Bob");
        Address addr = new Address("abc");
        bob.addAddress(addr);
        ksession.insert((Object)bob);
        ksession.insert((Object)addr);
        ksession.fireAllRules();
        Assertions.assertThat((String)addr.getZipCode()).isEqualTo("12345");
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo((Object)addr);
    }

    @Test
    public void testJavaModifyBlock() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JavaModifyBlock.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Person bob = new Person("Bob", 30);
        bob.setStatus("hungry");
        ksession.insert((Object)bob);
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new OuterClass.InnerClass(1));
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)bob.getStatus()).isEqualTo("full");
        Assertions.assertThat((int)bob.getAge()).isEqualTo(31);
        Assertions.assertThat((int)((OuterClass.InnerClass)list.get(1)).getIntAttr()).isEqualTo(2);
    }

    @Test
    public void testModifyJava() {
        this.testModifyWithDialect("java");
    }

    @Test
    public void testModifyMVEL() {
        this.testModifyWithDialect("mvel");
    }

    private void testModifyWithDialect(String dialect) {
        String str = "package org.drools.mvel.compiler\nimport java.util.List\nrule \"test\"\n    dialect \"" + dialect + "\"\nwhen\n    $l : List() from collect ( Person( alive == false ) );\nthen\n    for(Object p : $l ) {\n        Person p2 = (Person) p;\n        modify(p2) { setAlive(true) }\n    }\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testModifySimple() {
        String str = "package org.drools.mvel.compiler;\n\nrule \"test modify block\"\nwhen\n    $p: Person( name == \"hungry\" )\nthen\n    modify( $p ) { setName(\"fine\") }\nend\n\nrule \"Log\"\nwhen\n    $o: Object()\nthen\n    System.out.println( $o );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler;\n\nrule \"test modify block\"\nwhen\n    $p: Person( name == \"hungry\" )\nthen\n    modify( $p ) { setName(\"fine\") }\nend\n\nrule \"Log\"\nwhen\n    $o: Object()\nthen\n    System.out.println( $o );\nend"});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("hungry");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testModifyWithLockOnActive() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_ModifyWithLockOnActive.drl"});
        KieSession session = kbase.newKieSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Person bob = new Person("Bob", 15);
        Person mark = new Person("Mark", 16);
        Person michael = new Person("Michael", 14);
        session.insert((Object)bob);
        session.insert((Object)mark);
        session.insert((Object)michael);
        session.getAgenda().getAgendaGroup("feeding").setFocus();
        session.fireAllRules(5);
        Assertions.assertThat((int)((List)session.getGlobal("results")).size()).isEqualTo(2);
    }

    @Test
    public void testMissingClosingBraceOnModify() throws Exception {
        String str = "package org.drools.mvel.compiler.test;\nimport org.drools.compiler.*\nrule R1 when\n   $p : Person( )   $c : Cheese( )then\n   modify($p) { setCheese($c) ;\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.mvel.compiler.test;\nimport org.drools.compiler.*\nrule R1 when\n   $p : Person( )   $c : Cheese( )then\n   modify($p) { setCheese($c) ;\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testInvalidModify1() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.compiler \n";
        str = (String)str + "import " + Cheese.class.getName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 \n";
        str = (String)str + "    no-loop \n";
        str = (String)str + "when \n";
        str = (String)str + "    $i : Cheese() \n";
        str = (String)str + "then \n";
        str = (String)str + "    modify( $i ); ";
        str = (String)str + "    list.add( $i ); \n";
        str = (String)str + "end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testInvalidModify2() throws Exception {
        Object str = "";
        str = (String)str + "package org.drools.compiler \n";
        str = (String)str + "import " + Cheese.class.getName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule rule1 \n";
        str = (String)str + "    no-loop \n";
        str = (String)str + "when \n";
        str = (String)str + "    $i : Cheese() \n";
        str = (String)str + "then \n";
        str = (String)str + "    modify( $i ) { setType( \"stilton\" ); setType( \"stilton\" );}; ";
        str = (String)str + "    list.add( $i ); \n";
        str = (String)str + "end \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test
    public void testJoinNodeModifyObject() throws IOException, ClassNotFoundException {
        IndexedNumber n;
        int i;
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JoinNodeModifyObject.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList orderedFacts = new ArrayList();
        ArrayList errors = new ArrayList();
        ksession.setGlobal("orderedNumbers", orderedFacts);
        ksession.setGlobal("errors", errors);
        int MAX = 2;
        for (i = 1; i <= 2; ++i) {
            n = new IndexedNumber(i, 2 - i + 1);
            ksession.insert((Object)n);
        }
        ksession.fireAllRules();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Processing generated errors: " + ((Object)errors).toString(), new Object[0])).isTrue();
        for (i = 1; i <= 2; ++i) {
            n = (IndexedNumber)orderedFacts.get(i - 1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)n.getIndex()).as("Fact is out of order", new Object[0])).isEqualTo(i);
        }
    }

    @Test
    public void testModifyCommand() {
        String str = "rule \"sample rule\"\n   when\n   then\n       System.out.println(\"\\\"Hello world!\\\"\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rule \"sample rule\"\n   when\n   then\n       System.out.println(\"\\\"Hello world!\\\"\");\nend"});
        KieSession ksession = kbase.newKieSession();
        Person p1 = new Person("John", "nobody", 25);
        ksession.execute(CommandFactory.newInsert((Object)p1));
        FactHandle fh = ksession.getFactHandle((Object)p1);
        Person p = new Person("Frank", "nobody", 30);
        ArrayList<Setter> setterList = new ArrayList<Setter>();
        setterList.add(CommandFactory.newSetter((String)"age", (String)String.valueOf(p.getAge())));
        setterList.add(CommandFactory.newSetter((String)"name", (String)p.getName()));
        setterList.add(CommandFactory.newSetter((String)"likes", (String)p.getLikes()));
        ksession.execute(CommandFactory.newModify((FactHandle)fh, setterList));
    }

    @Test
    public void testNotIterativeModifyBug() {
        Object str = "";
        str = (String)str + "package org.simple \n";
        str = (String)str + "import " + AFact.class.getCanonicalName() + "\n";
        str = (String)str + "global java.util.List list \n";
        str = (String)str + "rule xxx \n";
        str = (String)str + "when \n";
        str = (String)str + "  $f1 : AFact() \n";
        str = (String)str + "    not AFact(this != $f1,  eval(field2 == $f1.getField2())) \n";
        str = (String)str + "    eval( !$f1.getField1().equals(\"1\") ) \n";
        str = (String)str + "then \n";
        str = (String)str + "  list.add($f1); \n";
        str = (String)str + "end  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        AFact a1 = new AFact("2", "2");
        AFact a2 = new AFact("1", "2");
        AFact a3 = new AFact("1", "2");
        FactHandle fa1 = ksession.insert((Object)a1);
        FactHandle fa2 = ksession.insert((Object)a2);
        FactHandle fa3 = ksession.insert((Object)a3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        a2.setField2("1");
        ksession.update(fa2, (Object)a2);
        a2.setField2("2");
        ksession.update(fa2, (Object)a2);
        ksession.update(fa3, (Object)a3);
        a3.setField2("1");
        ksession.update(fa3, (Object)a3);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession.dispose();
    }

    @Test
    public void testLLR() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_JoinNodeModifyTuple.drl"});
        KieSession ksession = kbase.newKieSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        Target tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(Float.valueOf(60.26544f));
        tgt.setLon(Float.valueOf(28.952137f));
        tgt.setCourse(Float.valueOf(145.0f));
        tgt.setSpeed(Float.valueOf(12.0f));
        tgt.setTime(Float.valueOf(1.8666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(Float.valueOf(60.236874f));
        tgt.setLon(Float.valueOf(28.992579f));
        tgt.setCourse(Float.valueOf(325.0f));
        tgt.setSpeed(Float.valueOf(8.0f));
        tgt.setTime(Float.valueOf(1.8666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(Float.valueOf(60.265343f));
        tgt.setLon(Float.valueOf(28.952267f));
        tgt.setCourse(Float.valueOf(145.0f));
        tgt.setSpeed(Float.valueOf(12.0f));
        tgt.setTime(Float.valueOf(1.9f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(Float.valueOf(60.236935f));
        tgt.setLon(Float.valueOf(28.992493f));
        tgt.setCourse(Float.valueOf(325.0f));
        tgt.setSpeed(Float.valueOf(8.0f));
        tgt.setTime(Float.valueOf(1.9f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(Float.valueOf(60.26525f));
        tgt.setLon(Float.valueOf(28.952396f));
        tgt.setCourse(Float.valueOf(145.0f));
        tgt.setSpeed(Float.valueOf(12.0f));
        tgt.setTime(Float.valueOf(1.9333333f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(Float.valueOf(60.236996f));
        tgt.setLon(Float.valueOf(28.992405f));
        tgt.setCourse(Float.valueOf(325.0f));
        tgt.setSpeed(Float.valueOf(8.0f));
        tgt.setTime(Float.valueOf(1.9333333f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(Float.valueOf(60.265163f));
        tgt.setLon(Float.valueOf(28.952526f));
        tgt.setCourse(Float.valueOf(145.0f));
        tgt.setSpeed(Float.valueOf(12.0f));
        tgt.setTime(Float.valueOf(1.9666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(Float.valueOf(60.237057f));
        tgt.setLon(Float.valueOf(28.99232f));
        tgt.setCourse(Float.valueOf(325.0f));
        tgt.setSpeed(Float.valueOf(8.0f));
        tgt.setTime(Float.valueOf(1.9666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
    }

    @Test
    public void noDormantCheckOnModifies() throws Exception {
        String str = "package org.drools.mvel.compiler;\n rule R1\n    salience 10\n    when\n        $c : Cheese( price == 10 ) \n        $p : Person( ) \n    then \n        modify($c) { setPrice( 5 ) }\n        modify($p) { setAge( 20 ) }\nend\nrule R2\n    when\n        $p : Person( )    then \n        // noop\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler;\n rule R1\n    salience 10\n    when\n        $c : Cheese( price == 10 ) \n        $p : Person( ) \n    then \n        modify($c) { setPrice( 5 ) }\n        modify($p) { setAge( 20 ) }\nend\nrule R2\n    when\n        $p : Person( )    then \n        // noop\nend\n"});
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.insert((Object)new Person("Bob", 19));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)ArgumentMatchers.any(MatchCancelledEvent.class));
    }

    @Test(timeout=10000L)
    public void testSwapChild() {
        String str = "package org.drools.mvel.compiler;\nimport " + Person.class.getCanonicalName() + "\nimport " + Asset.class.getCanonicalName() + "\nimport " + AssetCard.class.getCanonicalName() + "\n\nrule R1\n    no-loop\nwhen\n    $p : Person(name == \"Mario\") @watch(age)\n    $as : Asset()\n    $ac : AssetCard(parent == $as, groupCode != \"A\") \nthen\n    System.out.println(\"Rule \" + drools.getRule().getName() + \"; \" + $ac);\n    modify($p){setAge(10)}\nend\n\nrule R2\n    no-loop\nwhen\n    $p : Person(name == \"Mario\") @watch(age)\n    $as : Asset()\n    $ac : AssetCard(parent == $as, groupCode == \"A\") \nthen\n    System.out.println(\"Rule \" + drools.getRule().getName() + \"; \" + $ac);\n    modify($p){setAge(10)}\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Asset asset = new Asset();
        AssetCard assetCard = new AssetCard(1);
        assetCard.setParent(asset);
        assetCard.setGroupCode("A");
        asset.setAssetCard(assetCard);
        Person p = new Person("Mario", 20);
        ksession.insert((Object)asset);
        FactHandle assetCardFh = ksession.insert((Object)assetCard);
        ksession.insert((Object)p);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        AssetCard assetCard2 = new AssetCard(2);
        assetCard2.setParent(asset);
        assetCard2.setGroupCode("A");
        asset.setAssetCard(assetCard2);
        ksession.delete(assetCardFh);
        ksession.insert((Object)assetCard2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        ksession.dispose();
    }

    @Test
    public void testPeerUpdate() {
        String str = "import " + Firings.class.getCanonicalName() + "\n\nrule R1 when\n  Integer()\n  $f : Firings( list not contains \"R1\" )\nthen\n  $f.getList().add(\"R1\");\n  update($f);\nend\n\nrule R2 agenda-group \"x\" when\n  Integer()\n  Firings( $l : list )\n  String()\nthen\nend\n\nrule R3 agenda-group \"x\" when\n  Integer()\n  Firings( $l : list )\nthen\nend\n\nrule R4 when\n  Integer()\n  Firings( $l : list )\nthen\nend\n\nrule R5 when\n  Integer()\n  $f : Firings( list not contains \"R5\" )\nthen\n  $f.getList().add(\"R5\");\n  update($f);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)1);
        ksession.insert((Object)new Firings());
        ksession.getAgenda().getAgendaGroup("x").setFocus();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(5);
    }

    public static class Firings {
        private final List<String> list = new ArrayList<String>();

        public List<String> getList() {
            return this.list;
        }
    }
}

