/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CommandsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CommandsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionTimeCommands() {
        String drl = "package org.drools.compiler.integrationtests \nimport " + Cheese.class.getCanonicalName() + " \nrule StringRule \nwhen \n    $c : Cheese() \nthen \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-esp-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kSession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        try {
            KieCommands kieCommands = KieServices.get().getCommands();
            Assertions.assertThat((long)((Long)kSession.execute(kieCommands.newGetSessionTime()))).isEqualTo(0L);
            Assertions.assertThat((long)((Long)kSession.execute(kieCommands.newAdvanceSessionTime(2L, TimeUnit.SECONDS)))).isEqualTo(2000L);
            Assertions.assertThat((long)((Long)kSession.execute(kieCommands.newGetSessionTime()))).isEqualTo(2000L);
        }
        finally {
            kSession.dispose();
        }
    }
}

