/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class RuleChainingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleChainingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleChainingWithLogicalInserts() {
        String drl = "package com.sample\n \ndeclare Some\n    field : int\nend\n \nrule \"init\"\nsalience 9999\n    dialect \"mvel\"\n    when\n    then\n        Some s0 = new Some();\n        s0.field = 0;\n        insertLogical(s0);\n        Some s1 = new Some();\n        s1.field = 1;\n        insertLogical(s1);\nend\n\n\nrule \"r1\"\nsalience 100\nwhen\n    Some( field == 0 )\n    Some( $f : field == 1)\nthen\n    // noop\nend\n\n\nrule \"r2\"\nsalience 10\nwhen\n     $s : Some( $f : field == 0 )\nthen\n    // noop\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"subnetwork-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package com.sample\n \ndeclare Some\n    field : int\nend\n \nrule \"init\"\nsalience 9999\n    dialect \"mvel\"\n    when\n    then\n        Some s0 = new Some();\n        s0.field = 0;\n        insertLogical(s0);\n        Some s1 = new Some();\n        s1.field = 1;\n        insertLogical(s1);\nend\n\n\nrule \"r1\"\nsalience 100\nwhen\n    Some( field == 0 )\n    Some( $f : field == 1)\nthen\n    // noop\nend\n\n\nrule \"r2\"\nsalience 10\nwhen\n     $s : Some( $f : field == 0 )\nthen\n    // noop\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
            AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.addEventListener(wml);
            ksession.addEventListener(ael);
            int fired = ksession.fireAllRules();
            Assertions.assertThat((int)fired).isEqualTo(3);
            ArgumentCaptor actvs = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)actvs.capture());
            List values = actvs.getAllValues();
            Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(0)).getMatch().getRule().getName()).isEqualTo("init");
            Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(1)).getMatch().getRule().getName()).isEqualTo("r1");
            Assertions.assertThat((String)((AfterMatchFiredEvent)values.get(2)).getMatch().getRule().getName()).isEqualTo("r2");
            ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)ArgumentMatchers.any(MatchCancelledEvent.class));
            ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)ArgumentMatchers.any(ObjectInsertedEvent.class));
            ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.never())).objectDeleted((ObjectDeletedEvent)ArgumentMatchers.any(ObjectDeletedEvent.class));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testDoubleInsertLogical() {
        String drl = "package org.test;\n\ndeclare Fact\n    value : Integer\nend\n\ndeclare Logical\n    value : Integer\nend\n\nrule \"Init\"\n  when\n  then\n    insert(new Fact(1));\n    insert(new Fact(2));\nend\n\nrule \"Eliminate all\"\n  when\n    $fact : Fact($val : value)\n    not( Fact(value < $val) )\n    Logical(value == $val)\n  then\n    System.out.println(\"delete\" + $fact);\n    delete($fact);\nend\n\nrule \"Logical\"\n  when\n    Fact(value==1)\n  then\n    insertLogical(new Logical(1));\n    insertLogical(new Logical(2));\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"logical-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.test;\n\ndeclare Fact\n    value : Integer\nend\n\ndeclare Logical\n    value : Integer\nend\n\nrule \"Init\"\n  when\n  then\n    insert(new Fact(1));\n    insert(new Fact(2));\nend\n\nrule \"Eliminate all\"\n  when\n    $fact : Fact($val : value)\n    not( Fact(value < $val) )\n    Logical(value == $val)\n  then\n    System.out.println(\"delete\" + $fact);\n    delete($fact);\nend\n\nrule \"Logical\"\n  when\n    Fact(value==1)\n  then\n    insertLogical(new Logical(1));\n    insertLogical(new Logical(2));\nend"});
        KieSession ksession = kbase.newKieSession();
        ksession.fireAllRules();
        Assertions.assertThat((Collection)ksession.getObjects()).hasSize(1);
        Assertions.assertThat((String)ksession.getObjects().iterator().next().toString()).isEqualTo("Fact( value=2 )");
    }
}

