/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.core.base.MapGlobalResolver;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;

@RunWith(value=Parameterized.class)
public class GlobalTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public GlobalTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReturnValueAndGlobal() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\n\nglobal java.lang.String cheeseType;\nglobal java.util.List   matchingList;\nglobal java.util.List   nonMatchingList;\n\n\nrule \"Match type\"\n    when\n        $cheese : Cheese( type == (cheeseType) )\n    then\n        matchingList.add( $cheese );\nend\n\nrule \"Non matching type\"\n    when\n        $cheese : Cheese( type != (cheeseType) )\n    then\n        nonMatchingList.add( $cheese );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList matchlist = new ArrayList();
            ksession.setGlobal("matchingList", matchlist);
            ArrayList nonmatchlist = new ArrayList();
            ksession.setGlobal("nonMatchingList", nonmatchlist);
            ksession.setGlobal("cheeseType", (Object)"stilton");
            Cheese stilton1 = new Cheese("stilton", 5);
            Cheese stilton2 = new Cheese("stilton", 7);
            Cheese brie = new Cheese("brie", 4);
            ksession.insert((Object)stilton1);
            ksession.insert((Object)stilton2);
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assertions.assertThat((int)matchlist.size()).isEqualTo(2);
            Assertions.assertThat((int)nonmatchlist.size()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalAccess() {
        String drl = "import org.drools.core.base.MapGlobalResolver;\nglobal java.lang.String myGlobal;\nglobal String unused; \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.core.base.MapGlobalResolver;\nglobal java.lang.String myGlobal;\nglobal String unused; \n"});
        String sample = "default string";
        KieSession session1 = kbase.newKieSession();
        try {
            session1.setGlobal("myGlobal", (Object)"Testing 1");
            session1.insert((Object)"default string");
            session1.fireAllRules();
            Map.Entry[] entries1 = ((MapGlobalResolver)session1.getGlobals()).getGlobals();
            Assertions.assertThat((int)entries1.length).isEqualTo(1);
            Assertions.assertThat((String)"Testing 1").isEqualTo(entries1[0].getValue());
            Assertions.assertThat((int)session1.getGlobals().getGlobalKeys().size()).isEqualTo(1);
            Assertions.assertThat((boolean)session1.getGlobals().getGlobalKeys().contains("myGlobal")).isTrue();
        }
        finally {
            session1.dispose();
        }
        StatelessKieSession session2 = kbase.newStatelessKieSession();
        session2.setGlobal("myGlobal", (Object)"Testing 2");
        session2.execute((Object)"default string");
        Map.Entry[] entries2 = ((MapGlobalResolver)session2.getGlobals()).getGlobals();
        Assertions.assertThat((int)entries2.length).isEqualTo(1);
        Assertions.assertThat((String)"Testing 2").isEqualTo(entries2[0].getValue());
        Assertions.assertThat((int)session2.getGlobals().getGlobalKeys().size()).isEqualTo(1);
        Assertions.assertThat((boolean)session2.getGlobals().getGlobalKeys().contains("myGlobal")).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalNullGlobal() {
        String drl = "import " + Cheese.class.getCanonicalName() + "\nglobal Boolean b\nrule R when\n  eval(b)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"global-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("b", null);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }
}

