/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class RHSTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RHSTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testGenericsInRHS() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport java.util.Map;\nimport java.util.HashMap;\nrule \"Test Rule\"\n  when\n  then\n    Map<String,String> map = new HashMap<String,String>();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rhs-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nimport java.util.Map;\nimport java.util.HashMap;\nrule \"Test Rule\"\n  when\n  then\n    Map<String,String> map = new HashMap<String,String>();\nend"});
        KieSession ksession = kbase.newKieSession();
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementOperator() {
        String drl = "package org.drools.compiler.integrationtest.drl \nglobal java.util.List list \nrule rule1 \n    dialect \"java\" \nwhen \n    $I : Integer() \nthen \n    int i = $I.intValue(); \n    i += 5; \n    list.add( i ); \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rhs-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtest.drl \nglobal java.util.List list \nrule rule1 \n    dialect \"java\" \nwhen \n    $I : Integer() \nthen \n    int i = $I.intValue(); \n    i += 5; \n    list.add( i ); \nend \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)5);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)10);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKnowledgeHelperFixerInStrings() {
        String drl = "package org.drools.compiler.integrationtests.drl; \nglobal java.util.List list \nrule xxx \n  no-loop true when \n  $fact : String() \nthen \n  list.add(\"This is an update()\"); \n  list.add(\"This is an update($fact)\"); \n  update($fact); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"rhs-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.drl; \nglobal java.util.List list \nrule xxx \n  no-loop true when \n  $fact : String() \nthen \n  list.add(\"This is an update()\"); \n  list.add(\"This is an update($fact)\"); \n  update($fact); \nend  \n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"hello");
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
            Assertions.assertThat(list.get(0)).isEqualTo((Object)"This is an update()");
            Assertions.assertThat(list.get(1)).isEqualTo((Object)"This is an update($fact)");
        }
        finally {
            ksession.dispose();
        }
    }
}

