/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler;

import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.definitions.impl.KnowledgePackageImpl;
import org.drools.base.rule.TypeDeclaration;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.common.DefaultEventHandle;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.type.Annotation;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class TypeDeclarationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TypeDeclarationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testClassNameClashing() {
        Object str = "";
        str = (String)str + "package org.kie \ndeclare org.kie.Character \n    name : String \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testAnnotationReDefinition() {
        Object str1 = "";
        str1 = (String)str1 + "package org.kie \ndeclare org.kie.EventA \n    name : String \n    duration : Long \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.kie \ndeclare org.kie.EventA \n    @role (event) \n    @duration (duration) \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBuilderResults warnings = kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING});
        Assertions.assertThat((int)warnings.size()).isEqualTo(0);
        Assertions.assertThat((int)kbuilder.getKnowledgePackages().size()).isEqualTo(1);
        FactType factType = ((KnowledgePackageImpl)kbuilder.getKnowledgePackages().iterator().next()).getFactType("org.kie.EventA");
        Assertions.assertThat((Object)factType).isNotNull();
        FactField field = factType.getField("name");
        Assertions.assertThat((Object)field).isNotNull();
        field = factType.getField("duration");
        Assertions.assertThat((Object)field).isNotNull();
        TypeDeclaration typeDeclaration = ((KnowledgePackageImpl)kbuilder.getKnowledgePackages().iterator().next()).getTypeDeclaration("EventA");
        Assertions.assertThat((Comparable)typeDeclaration.getRole()).isEqualTo((Object)Role.Type.EVENT);
        Assertions.assertThat((String)typeDeclaration.getDurationAttribute()).isEqualTo("duration");
    }

    @Test
    public void testNoAnnotationUpdateIfError() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.EventA \n    name : String \n    duration : Long \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools.mvel.compiler \ndeclare org.drools.EventA \n    @role (event) \n    @duration (duration) \n    anotherField : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assertions.fail((String)"Errors Expected");
        }
        KnowledgeBuilderResults warnings = kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING});
        Assertions.assertThat((int)warnings.size()).isEqualTo(0);
        Assertions.assertThat((int)kbuilder.getKnowledgePackages().size()).isEqualTo(0);
    }

    @Test
    public void testDuplicatedTypeDeclarationWith2FieldsInSameResource() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        Resource drlResource = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader((String)str1));
        drlResource.setSourcePath("src/main/resources/rule1.drl");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{drlResource, drlResource});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testDuplicatedTypeDeclarationInDifferentResources() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \nend \n";
        Resource drlResource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader((String)str1));
        drlResource1.setSourcePath("src/main/resources/rule1.drl");
        Resource drlResource2 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader((String)str1));
        drlResource2.setSourcePath("src/main/resources/rule2.drl");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{drlResource1, drlResource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testClashingTypeDeclarationInDifferentResources() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assertions.fail((String)"An error should have been generated, redefinition of ClassA is not allowed");
        }
    }

    @Test
    public void testNotSoHarmlessTypeReDeclaration() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assertions.fail((String)"An error should have been generated, redefinition of ClassA is not allowed");
        }
    }

    @Test
    public void testTypeReDeclarationWithExtraField() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testTypeReDeclarationWithExtraField2() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    age : Integer \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools.mvel.compiler \ndeclare org.drools.ClassA \n    name : String \n    lastName : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testDuplicateDeclaration() {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler \ndeclare Bean \n    name : String \nend \ndeclare Bean \n    age : int \nend \n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Two definitions with the same name are not allowed, but it was not detected!", new Object[0])).isFalse();
    }

    @Test
    public void testTypeDeclarationMetadata() {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler.test; \nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.KlassAnnotation; \nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.FieldAnnotation; \nimport org.drools.mvel.compiler.Person\n\ndeclare Bean \n@role(event) \n@expires( 1s ) \n@KlassAnnotation( \"klass\" )    name : String\nend \ndeclare Person @role(event) end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        FactType bean = kBase.getFactType("org.drools.mvel.compiler.test", "Bean");
        FactType pers = kBase.getFactType("org.drools", "Person");
        Assertions.assertThat((String)bean.getName()).isEqualTo("org.drools.mvel.compiler.test.Bean");
        Assertions.assertThat((String)bean.getSimpleName()).isEqualTo("Bean");
        Assertions.assertThat((String)bean.getPackageName()).isEqualTo("org.drools.mvel.compiler.test");
        Assertions.assertThat((int)bean.getClassAnnotations().size()).isEqualTo(3);
        Annotation ann = (Annotation)bean.getClassAnnotations().get(0);
        if (!ann.getName().equals("org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation")) {
            ann = (Annotation)bean.getClassAnnotations().get(1);
        }
        if (!ann.getName().equals("org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation")) {
            ann = (Annotation)bean.getClassAnnotations().get(2);
        }
        Assertions.assertThat((String)ann.getName()).isEqualTo("org.drools.mvel.compiler.compiler.TypeDeclarationTest$KlassAnnotation");
        Assertions.assertThat((Object)ann.getPropertyValue("value")).isEqualTo((Object)"klass");
        Assertions.assertThat((Class)ann.getPropertyType("value")).isEqualTo(String.class);
        Assertions.assertThat((int)bean.getMetaData().size()).isEqualTo(2);
        Assertions.assertThat(bean.getMetaData().get("role")).isEqualTo((Object)"event");
        FactField field = bean.getField("name");
        Assertions.assertThat((Object)field).isNotNull();
    }

    @Test
    public void testTypeDeclarationWithInnerClasses() {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler;\n\nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.EventBar.*;\ndeclare Foo\n @role( event )\nend\nrule R when Foo() then end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession knowledgeSession = kBase.newKieSession();
        FactHandle handle = knowledgeSession.insert((Object)new EventBar.Foo());
        Assertions.assertThat((boolean)(handle instanceof DefaultEventHandle)).isTrue();
    }

    @Test
    public void testTypeDeclarationWithInnerClassesImport() {
        Object str = "";
        str = (String)str + "package org.drools.mvel.compiler;\n\nimport org.drools.mvel.compiler.compiler.TypeDeclarationTest.EventBar.Foo;\ndeclare Foo\n @role( event )\nend\nrule R when Foo() then end";
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession knowledgeSession = kBase.newKieSession();
        FactHandle handle = knowledgeSession.insert((Object)new EventBar.Foo());
        Assertions.assertThat((boolean)(handle instanceof DefaultEventHandle)).isTrue();
    }

    @Test
    public void testMultipleTypeReDeclaration() {
        Object str1 = "";
        str1 = (String)str1 + "package org.drools \ndeclare org.drools.ClassC \n    name : String \n    age : Integer \nend \n";
        Object str2 = "";
        str2 = (String)str2 + "package org.drools \ndeclare org.drools.ClassC \n    name : String \n    age : Integer \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str1).getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])((String)str2).getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testDeclareFieldArray() {
        String str1 = "package org.drools declare Test end declare Pet     owners : Owner[]     twoDimArray : Foo[][]     friends : Pet[]     ages : int[] end declare Owner      name : String end declare Foo end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModule();
        KnowledgeBuilderImpl kbuilder = (KnowledgeBuilderImpl)kieModule.getKnowledgeBuilderForKieBase("KieBaseModelName");
        for (KiePackage kp : kbuilder.getKnowledgePackages()) {
            if (!kp.getName().equals("org.drools")) continue;
            Collection types = kp.getFactTypes();
            for (FactType type : types) {
                if (!"org.drools.Pet".equals(type.getName())) continue;
                Assertions.assertThat((int)type.getFields().size()).isEqualTo(4);
                FactField owners = type.getField("owners");
                Assertions.assertThat((owners != null && owners.getType().getSimpleName().equals("Owner[]") && owners.getType().isArray() ? 1 : 0) != 0).isTrue();
                FactField twoDim = type.getField("twoDimArray");
                Assertions.assertThat((twoDim != null && twoDim.getType().getSimpleName().equals("Foo[][]") && twoDim.getType().isArray() ? 1 : 0) != 0).isTrue();
                FactField friends = type.getField("friends");
                Assertions.assertThat((friends != null && friends.getType().getSimpleName().equals("Pet[]") && friends.getType().isArray() ? 1 : 0) != 0).isTrue();
                FactField ages = type.getField("ages");
                Assertions.assertThat((ages != null && ages.getType().getSimpleName().equals("int[]") && ages.getType().isArray() ? 1 : 0) != 0).isTrue();
            }
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPreventReflectionAPIsOnJavaClasses() {
        String drl = "package org.test; declare org.drools.mvel.compiler.Person   @role(event) end \n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType type = kieBase.getFactType("org.drools.mvel.compiler", "Person");
    }

    @Test
    public void testCrossPackageDeclares() {
        String pkg1 = "package org.drools.mvel.compiler.test1; import org.drools.mvel.compiler.test2.GrandChild; import org.drools.mvel.compiler.test2.Child; import org.drools.mvel.compiler.test2.BarFuu; declare FuBaz foo : String end declare Parent    unknown : BarFuu end declare GreatChild extends GrandChild    father : Child end ";
        String pkg2 = "package org.drools.mvel.compiler.test2; import org.drools.mvel.compiler.test1.Parent; import org.drools.mvel.compiler.test1.FuBaz; declare BarFuu    baz : FuBaz end declare Child extends Parent end declare GrandChild extends Child    notknown : FuBaz end ";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.generateAndWritePomXML(ks.newReleaseId("test", "foo", "1.0"));
        KieModuleModel km = ks.newKieModuleModel();
        km.newKieBaseModel("rules").addPackage("org.drools.mvel.compiler.test2").addPackage("org.drools.mvel.compiler.test1");
        kfs.writeKModuleXML(km.toXML());
        KieResources kr = ks.getResources();
        Resource r1 = kr.newByteArrayResource(pkg1.getBytes()).setResourceType(ResourceType.DRL).setSourcePath("org/drools/compiler/test1/p1.drl");
        Resource r2 = kr.newByteArrayResource(pkg2.getBytes()).setResourceType(ResourceType.DRL).setSourcePath("org/drools/compiler/test2/p2.drl");
        kfs.write(r1);
        kfs.write(r2);
        KieBuilder builder = ks.newKieBuilder(kfs);
        builder.buildAll();
        Assertions.assertThat((List)builder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR})).isEqualTo(Collections.emptyList());
        KieContainer kc = ks.newKieContainer(builder.getKieModule().getReleaseId());
        FactType ft = kc.getKieBase("rules").getFactType("org.drools.mvel.compiler.test2", "Child");
        Assertions.assertThat((Object)ft).isNotNull();
        Assertions.assertThat((Class)ft.getFactClass()).isNotNull();
        Assertions.assertThat((String)ft.getFactClass().getSuperclass().getName()).isEqualTo("org.drools.mvel.compiler.test1.Parent");
    }

    @Test
    public void testUnknownField() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test; declare Pet end \n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Pet");
        Object instance = factType.newInstance();
        factType.get(instance, "unknownField");
        factType.set(instance, "unknownField", (Object)"myValue");
    }

    @Test
    public void testPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String\n    age : int\nend\nrule R when \n    $p : Person( \"Mark\", 37; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Person");
        Object instance = factType.newInstance();
        factType.set(instance, "name", (Object)"Mark");
        factType.set(instance, "age", (Object)37);
        ArrayList names = new ArrayList();
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("names", names);
        ksession.insert(instance);
        ksession.fireAllRules();
        Assertions.assertThat((int)names.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)names.get(0))).isEqualTo("Mark");
    }

    @Test
    public void testExplictPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(1)\n    age : int @Position(0)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isFalse();
        KieBase kieBase = KieServices.Factory.get().newKieContainer(kieBuilder.getKieModule().getReleaseId()).getKieBase();
        FactType factType = kieBase.getFactType("org.test", "Person");
        Object instance = factType.newInstance();
        factType.set(instance, "name", (Object)"Mark");
        factType.set(instance, "age", (Object)37);
        ArrayList names = new ArrayList();
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("names", names);
        ksession.insert(instance);
        ksession.fireAllRules();
        Assertions.assertThat((int)names.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)names.get(0))).isEqualTo("Mark");
    }

    @Test
    public void testTooManyPositionalArguments() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String\n    age : int\nend\nrule R when \n    $p : Person( \"Mark\", 37, 42; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    @Test
    public void testOutOfRangePositions() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(3)\n    age : int @Position(1)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    @Test
    public void testDuplicatedPositions() throws InstantiationException, IllegalAccessException {
        String drl = "package org.test;\nglobal java.util.List names;\ndeclare Person\n    name : String @Position(1)\n    age : int @Position(1)\nend\nrule R when \n    $p : Person( 37, \"Mark\"; )\nthen\n    names.add( $p.getName() );\nend\n";
        KieBuilder kieBuilder = this.build(drl);
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    private KieBuilder build(String drl) {
        return KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
    }

    @Test
    public void testMultipleAnnotationDeclarations() {
        Object str1 = "";
        str1 = (String)str1 + "package org.kie1 declare Foo \n   @role(event)     name : String     age : int end ";
        String str2 = "package org.kie3 declare org.kie1.Foo     @propertyReactive end ";
        String str3 = "package org.kie4; import org.kie1.Foo; rule Check when  $f : Foo( name == 'bar' ) then  modify( $f ) { setAge( 99 ); } end ";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1, str2, str3});
        FactType type = kieBase.getFactType("org.kie1", "Foo");
        Assertions.assertThat((int)type.getFields().size()).isEqualTo(2);
        Object foo = null;
        try {
            foo = type.newInstance();
            type.set(foo, "name", (Object)"bar");
            Assertions.assertThat((Object)type.get(foo, "name")).isEqualTo((Object)"bar");
        }
        catch (InstantiationException e) {
            Assertions.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)e.getMessage());
        }
        KieSession session = kieBase.newKieSession();
        FactHandle handle = session.insert(foo);
        int n = session.fireAllRules(5);
        Assertions.assertThat((boolean)(handle instanceof DefaultEventHandle)).isTrue();
        Assertions.assertThat((int)n).isEqualTo(1);
        Assertions.assertThat((Object)type.get(foo, "age")).isEqualTo((Object)99);
    }

    @Test
    public void testDeclareWithExtensionAndOverride() {
        String s1 = "package test; global java.util.List list; declare Sub extends Sup  fld : String end declare Sup  fld : Object end rule Init when then insert( new Sub( 'aa' ) ); end rule CheckSup when  $s : Sup( $f : fld == 'aa' ) then   list.add( \"Sup\" + $f );  end rule CheckSub when  $s : Sub( $f : fld == 'aa' ) then   list.add( \"Sub\" + $f );  end ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package test; global java.util.List list; declare Sub extends Sup  fld : String end declare Sup  fld : Object end rule Init when then insert( new Sub( 'aa' ) ); end rule CheckSup when  $s : Sup( $f : fld == 'aa' ) then   list.add( \"Sup\" + $f );  end rule CheckSub when  $s : Sub( $f : fld == 'aa' ) then   list.add( \"Sub\" + $f );  end "});
        KieSession ks = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("Supaa", "Subaa"))).isTrue();
        FactType sup = ks.getKieBase().getFactType("test", "Sup");
        FactType sub = ks.getKieBase().getFactType("test", "Sub");
        try {
            Method m1 = sup.getFactClass().getMethod("getFld", new Class[0]);
            Assertions.assertThat((Object)m1).isNotNull();
            Assertions.assertThat(m1.getReturnType()).isEqualTo(Object.class);
            Method m2 = sub.getFactClass().getMethod("getFld", new Class[0]);
            Assertions.assertThat((Object)m2).isNotNull();
            Assertions.assertThat(m2.getReturnType()).isEqualTo(String.class);
            Assertions.assertThat((int)sub.getFactClass().getFields().length).isEqualTo(0);
            Assertions.assertThat((int)sub.getFactClass().getDeclaredFields().length).isEqualTo(0);
            Assertions.assertThat((int)sup.getFactClass().getDeclaredFields().length).isEqualTo(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetter() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getSimpleName() + " @propertyReactive end rule Check when BeanishClass() @Watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetterAndCanonicalName() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getCanonicalName() + " @propertyReactive end rule Check when BeanishClass() @Watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testDeclarationOfClassWithNonStandardSetterAndFulllName() {
        String s1 = "package test; import " + BeanishClass.class.getCanonicalName() + "; declare " + BeanishClass.class.getName() + " @propertyReactive end rule Check when BeanishClass() @watch( foo ) then end ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{s1});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    public static class BeanishClass {
        private int foo;

        public int getFoo() {
            return this.foo;
        }

        public void setFoo(int x) {
            this.foo = x;
        }

        public void setFooAsString(String x) {
            this.foo = Integer.parseInt(x);
        }
    }

    public static interface Ext
    extends Base {
        @Override
        public String getFld();

        public void setFld(String var1);
    }

    public static interface Base {
        public Object getFld();

        public void setFld(Object var1);
    }

    public static class ClassC {
        private String name;
        private Integer age;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }
    }

    public static class EventBar {

        public static class Foo {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface FieldAnnotation {
        public String prop();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface KlassAnnotation {
        public String value();
    }
}

