/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.drl.parser.lang.Expander;
import org.drools.drl.parser.lang.dsl.DefaultExpanderResolver;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class DslTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DslTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMultiLineTemplates() throws Exception {
        InputStreamReader source = new InputStreamReader(this.getClass().getResourceAsStream("rule_with_expander_multiline.dslr"));
        InputStreamReader dsl = new InputStreamReader(this.getClass().getResourceAsStream("test_dsl_multiline.dsl"));
        Expander ex = new DefaultExpanderResolver((Reader)dsl).get("*", null);
        String r = ex.expand((Reader)source);
        Assertions.assertThat((String)r.trim()).isEqualTo("when Car(color==\"Red\") then doSomething();");
    }

    @Test
    public void testWithExpanderDSL() throws Exception {
        Resource resource1 = KieServices.Factory.get().getResources().newClassPathResource("test_expander.dsl", this.getClass());
        resource1.setSourcePath("src/main/resources/test_expander.dsl");
        Resource resource2 = KieServices.Factory.get().getResources().newClassPathResource("rule_with_expander_dsl.dslr", this.getClass());
        resource2.setSourcePath("src/main/resources/rule_with_expander_dsl.dslr");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{resource1, resource2});
        this.checkDSLExpanderTest(kieBuilder);
    }

    private void checkDSLExpanderTest(KieBuilder kieBuilder) throws IOException, ClassNotFoundException {
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        Collection pkgs = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder).getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(2);
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder);
        KieSession session = kbase.newKieSession();
        session.insert((Object)new Person("Bob", "http://foo.bar"));
        session.insert((Object)new Cheese("stilton", 42));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        Assertions.assertThat((int)messages.size()).isEqualTo(1);
    }

    @Test
    public void testWithExpanderMore() throws Exception {
        Resource resource1 = KieServices.Factory.get().getResources().newClassPathResource("test_expander.dsl", this.getClass());
        resource1.setSourcePath("src/main/resources/test_expander.dsl");
        Resource resource2 = KieServices.Factory.get().getResources().newClassPathResource("rule_with_expander_dsl_more.dslr", this.getClass());
        resource2.setSourcePath("src/main/resources/rule_with_expander_dsl_more.dslr");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{resource1, resource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        Collection pkgs = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder).getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(2);
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder);
        KieSession session = kbase.newKieSession();
        session.insert((Object)new Person("rage"));
        session.insert((Object)new Cheese("cheddar", 15));
        ArrayList messages = new ArrayList();
        session.setGlobal("messages", messages);
        session.fireAllRules();
        Assertions.assertThat((int)messages.size()).isEqualTo(0);
        session.insert((Object)new Person("fire"));
        session.fireAllRules();
        Assertions.assertThat((int)messages.size()).isEqualTo(0);
        session.insert((Object)new Cheese("brie", 15));
        session.fireAllRules();
        Assertions.assertThat((int)messages.size()).isEqualTo(1);
    }

    @Test
    @Ignore(value="antlr cannot parse correctly if the file ends with a comment without a further line break")
    public void testEmptyDSL() throws Exception {
        String DSL = "# This is an empty dsl file.";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_expander.dsl", this.getClass()), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader("# This is an empty dsl file.")), ResourceType.DSLR);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        String err = kbuilder.getErrors().toString();
        Assertions.assertThat((String)err).isEqualTo("");
        Assertions.assertThat((int)kbuilder.getErrors().size()).isEqualTo(0);
        Collection pkgs = kbuilder.getKnowledgePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(0);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession session = kbase.newKieSession();
        pkgs = SerializationHelper.serializeObject(pkgs);
        Assertions.assertThat((Collection)pkgs).isNull();
    }

    @Test
    public void testDSLWithIndividualConstraintMappings() throws Exception {
        Resource resource1 = KieServices.Factory.get().getResources().newClassPathResource("test_dslWithIndividualConstraints.dsl", this.getClass());
        resource1.setSourcePath("src/main/resources/test_dslWithIndividualConstraints.dsl");
        Resource resource2 = KieServices.Factory.get().getResources().newClassPathResource("test_dslWithIndividualConstraints.dslr", this.getClass());
        resource2.setSourcePath("src/main/resources/test_dslWithIndividualConstraints.dslr");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{resource1, resource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        Collection pkgs = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder).getKiePackages();
        Assertions.assertThat((int)pkgs.size()).isEqualTo(1);
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder);
        KieSession session = kbase.newKieSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Cheese cheese = new Cheese("stilton", 42);
        session.insert((Object)cheese);
        session.fireAllRules();
        Assertions.assertThat((int)results.size()).isEqualTo(1);
        Assertions.assertThat(results.get(0)).isEqualTo((Object)cheese);
    }

    @Test
    public void testDSLWithSpaceBetweenParenthesis() {
        String dsl = "[when]There is a Person=Person( )\n[when]-named {name}=name == \"{name}\"\n[when]-aged less than {age}=age < {age}\n[then]Log {message}=list.add({message});";
        String drl = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list\nrule R1\nwhen\nThere is a Person\n-named Mario\n-aged less than 40\nthen\nLog \"OK\"\nend\n";
        Assertions.assertThat((boolean)this.doTest(dsl, drl).contains("OK")).isTrue();
    }

    @Test
    public void testDSLWithVariableBinding() {
        String dsl = "[when]There is a Person=$p : Person()\n[when]-named {name}=name == \"{name}\"\n[when]-aged less than {age}=age < {age}\n[then]Log person name=list.add($p.getName());";
        String drl = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list\nrule R1\nwhen\nThere is a Person\n-named Mario\n-aged less than 40\nthen\nLog person name\nend\n";
        Assertions.assertThat((boolean)this.doTest(dsl, drl).contains("Mario")).isTrue();
    }

    @Test
    public void testDSLWithApostrophe() {
        String dsl = "[when]Person's name is {name}=$p : Person(name == \"{name}\")\n[then]Log person name=list.add($p.getName());";
        String drl = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list\nrule R1\nwhen\nPerson's name is Mario\nthen\nLog person name\nend\n";
        Assertions.assertThat((boolean)this.doTest(dsl, drl).contains("Mario")).isTrue();
    }

    @Test
    public void testDSLWithCommentedBlock() {
        String dsl = "[when]There is a Person=Person()\n[when]-named {name}=name == \"{name}\"\n[when]-aged less than {age}=age < {age}\n[then]Log {message}=list.add({message});";
        String drl = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list\nrule R1\nwhen\n/*There is a Cheese\n-of type Gorgonzola*/\nThere is a Person\n-named Mario\n-aged less than 40\nthen\nLog \"OK\"\nend\n";
        Assertions.assertThat((boolean)this.doTest(dsl, drl).contains("OK")).isTrue();
    }

    @Test
    public void testDSLWithSingleDotRegex() {
        String dsl = "[then]Log {message:.}=list.add(\"{message}\");";
        String drl = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list\nrule R1\nwhen\nthen\nLog X\nend\n";
        Assertions.assertThat((boolean)this.doTest(dsl, drl).contains("X")).isTrue();
    }

    private List doTest(String dsl, String drl) {
        Resource resource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(dsl));
        resource1.setSourcePath("src/main/resources/test_dsl.dsl");
        Resource resource2 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        resource2.setSourcePath("src/main/resources/test_dslr.dslr");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{resource1, resource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
        KieBase kbase = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("Mario", 38));
        ksession.fireAllRules();
        ksession.dispose();
        return list;
    }

    @Test
    public void testGreedyDsl() {
        String dsl = "[when]There is a number with value of {value}=i:Integer(intValue() == {value})\n[when]There is a number with=i:Integer()\n";
        String dslr = "package org.test \nrule 'sample rule' \nwhen \n  There is a number with value of 10\nthen \nend \n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.dslr", dslr).write("src/main/resources/r1.dsl", dsl);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        List messages = kieBuilder.getResults().getMessages();
        Assertions.assertThat((int)messages.size()).isEqualTo(0);
    }

    @Test
    public void testDSLWithSingleDot() {
        String dsl = "[when][]if there is a simple event\n{evtName}={evtName}: SimpleEvent()\n[when][]and a simple event 2\n{evtName2} with the same {attribute} as {evtName}={evtName2} : SimpleEvent2({attribute}=={evtName}.{attribute})\n[then][]ok=System.out.println(\"that works\");\n\n";
        String drl = "declare SimpleEvent\n  code: String\nend\n\ndeclare SimpleEvent2\n  code: String\nend\nrule \"RG_CORR_RECOK_OK\"\nwhen\nif there is a simple event $evt\nand a simple event 2 $evt2 with the same code as $evt\nthen\nok\nend\n";
        Resource resource1 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(dsl));
        resource1.setSourcePath("src/main/resources/test_dsl.dsl");
        Resource resource2 = KieServices.Factory.get().getResources().newReaderResource((Reader)new StringReader(drl));
        resource2.setSourcePath("src/main/resources/test_dslr.dslr");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromResources((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (Resource[])new Resource[]{resource1, resource2});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }
}

