/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;

@RunWith(value=Parameterized.class)
public class KmoduleXmlTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KmoduleXmlTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void kbaseEmptyName() throws Exception {
        List<Message> errors = this.buildKmoduleWithEmptyValue("name", Element.KBASE);
        Assertions.assertThat(errors).isNotEmpty();
        Assertions.assertThat((String)errors.get(0).getText()).contains(new CharSequence[]{"kbase name is empty in kmodule.xml"});
    }

    @Test
    public void kbaseEmptyIncludes() throws Exception {
        List<Message> errors = this.buildKmoduleWithEmptyValue("includes", Element.KBASE);
        ((ListAssert)Assertions.assertThat(errors).as("Empty includes is fine. It's ignored", new Object[0])).isEmpty();
    }

    @Test
    public void kbaseEmptyPackages() throws Exception {
        List<Message> errors = this.buildKmoduleWithEmptyValue("packages", Element.KBASE);
        ((ListAssert)Assertions.assertThat(errors).as("Empty packages is fine. It means the default package", new Object[0])).isEmpty();
    }

    @Test
    public void ksessionEmptyName() throws Exception {
        List<Message> errors = this.buildKmoduleWithEmptyValue("name", Element.KSESSION);
        Assertions.assertThat(errors).isNotEmpty();
        Assertions.assertThat((String)errors.get(0).getText()).contains(new CharSequence[]{"ksession name is empty in kmodule.xml"});
    }

    private List<Message> buildKmoduleWithEmptyValue(String emptyAttribute, Element element) throws Exception {
        String drl = "package org.example\nrule R1 when\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/org/example/r1.drl", drl);
        kfs.write("src/main/resources/META-INF/kmodule.xml", this.getKmoduleString(emptyAttribute, element));
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        return kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
    }

    private String getKmoduleString(String emptyAttribute, Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        if (element == Element.KBASE) {
            sb.append("<kbase " + emptyAttribute + "=\"\" default=\"true\">\n");
            sb.append("  <ksession name=\"myKsession\" default=\"true\"/>\n");
        } else if (element == Element.KSESSION) {
            sb.append("<kbase name=\"myKbase\" default=\"true\">\n");
            sb.append("  <ksession " + emptyAttribute + "=\"\" default=\"true\"/>\n");
        } else {
            throw new IllegalArgumentException("Unsupported element : " + element);
        }
        sb.append("</kbase>\n");
        sb.append("</kmodule>\n");
        return sb.toString();
    }

    static enum Element {
        KBASE,
        KSESSION;

    }
}

