/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class MTEntryPointsTest {
    private KieSession kieSession;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MTEntryPointsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    @Before
    public void initSession() {
        String str = "package org.jboss.brms\n\nimport org.drools.mvel.integrationtests.MTEntryPointsTest.MessageEvent\n\ndeclare MessageEvent\n    @role( event )\nend\n\nrule \"sum of last event from first entry point\"\n    when\n\t    accumulate (\n\t        MessageEvent ($value : value) over window:length(1) from entry-point \"FirstStream\",\n\t        $sum : sum($value)\n\t    )\n    then\nend\n\nrule \"sum of last event from both entry points\"\n    when\n        accumulate (\n            MessageEvent ($value1 : value) over window:length(1) from entry-point \"FirstStream\",\n            $thirdSum1 : sum($value1)\n        )\n        accumulate (\n            MessageEvent ($value2 : value) over window:length(1) from entry-point \"SecondStream\",\n            $thirdSum2 : sum($value2)\n        )\n    then\nend\n\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        KieModuleModel kmoduleModel = ks.newKieModuleModel();
        kmoduleModel.newKieBaseModel("defaultKieBase").addPackage("*").setEventProcessingMode(EventProcessingOption.STREAM).newKieSessionModel("defaultKieSession").setDefault(true).setClockType(ClockTypeOption.PSEUDO);
        kfs.writeKModuleXML(kmoduleModel.toXML());
        KieBuilder builder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)false);
        Assertions.assertThat((int)builder.getResults().getMessages().size()).isEqualTo(0);
        ks.getRepository().addKieModule(builder.getKieModule());
        this.kieSession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @After
    public void cleanup() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOneEntryPoint() throws Exception {
        EntryPoint firstThreadEntryPoint = this.kieSession.getEntryPoint("FirstStream");
        int numInsertersInEachEntryPoint = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                Future<?> future = executorService.submit(new TestInserter(this.kieSession, firstThreadEntryPoint));
                futures.add(future);
            }
            for (Future future : futures) {
                future.get(30L, TimeUnit.SECONDS);
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoEntryPoints() throws Exception {
        EntryPoint firstThreadEntryPoint = this.kieSession.getEntryPoint("FirstStream");
        EntryPoint secondThreadEntryPoint = this.kieSession.getEntryPoint("SecondStream");
        int numInsertersInEachEntryPoint = 10;
        int numThreadPoolCapacity = 20;
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                Future<?> future = executorService.submit(new TestInserter(this.kieSession, firstThreadEntryPoint));
                futures.add(future);
                Future<?> futureForSecondThread = executorService.submit(new TestInserter(this.kieSession, secondThreadEntryPoint));
                futures.add(futureForSecondThread);
            }
            for (Future future : futures) {
                future.get(30L, TimeUnit.SECONDS);
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static class MessageEvent {
        private int value;

        public MessageEvent(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class TestInserter
    implements Runnable {
        private final EntryPoint entryPoint;
        private final KieSession kieSession;

        public TestInserter(KieSession kieSession, EntryPoint entryPoint) {
            this.kieSession = kieSession;
            this.entryPoint = entryPoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                EntryPoint entryPoint = this.entryPoint;
                synchronized (entryPoint) {
                    this.entryPoint.insert((Object)new MessageEvent(i));
                }
                this.advanceTime(100L);
            }
        }

        private void advanceTime(long millis) {
            SessionPseudoClock pseudoClock = (SessionPseudoClock)this.kieSession.getSessionClock();
            pseudoClock.advanceTime(millis, TimeUnit.MILLISECONDS);
        }
    }
}

