/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.common.DroolsObjectInputStream;
import org.drools.base.common.DroolsObjectOutputStream;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SerializedPackageMergeTest {
    private static final DateFormat DF = new SimpleDateFormat("dd-MMM-yyyy", Locale.UK);
    private static final String[] DRLs = new String[]{"drl/HelloWorld.drl", "test_Serialization1.drl"};

    @Test
    public void testRuleExecutionWithoutSerialization() {
        try {
            this.testRuleExecution(this.getSession(false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Should not have raised any exception. Message: " + e.getMessage()));
        }
    }

    @Test
    public void testRuleExecutionWithSerialization() throws Exception {
        try {
            this.testRuleExecution(this.getSession(true));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Should not have raised any exception. Message: " + e.getMessage()));
        }
    }

    private void testRuleExecution(StatelessKieSession session) throws Exception {
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)this.getObject());
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    private Message getObject() throws ParseException {
        Message message = new Message();
        message.setMessage("hola");
        message.setNumber(50);
        message.getList().add("hello");
        message.setBirthday(DF.parse("10-Jul-1976"));
        return message;
    }

    private StatelessKieSession getSession(boolean serialize) throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (String drl : DRLs) {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream(drl)), ResourceType.DRL);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder.hasErrors()).as(kbuilder.getErrors().toString(), new Object[0])).isFalse();
            ArrayList<KiePackage> kpkgs = kbuilder.getKnowledgePackages();
            ArrayList<KiePackage> newCollection = null;
            if (serialize) {
                newCollection = new ArrayList<KiePackage>();
                for (KiePackage kpkg : kpkgs) {
                    kpkg = SerializationHelper.serializeObject(kpkg);
                    newCollection.add(kpkg);
                }
            } else {
                newCollection = kpkgs;
            }
            kbase.addPackages(newCollection);
        }
        return kbase.newStatelessKieSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildAndSerializePackagesWithSamePackageName() throws IOException, ClassNotFoundException {
        String str1 = "package com.sample\nimport org.drools.mvel.compiler.Person\nglobal java.util.List list\nrule R1 when\n  $p : Person( name == \"John\" )\nthen\n  list.add($p);end\n";
        String str2 = "package com.sample\nimport org.drools.mvel.compiler.Person\nglobal java.util.List list\nrule R2 when\n  $p : Person( name == \"Paul\" )\nthen\n  list.add($p);end\n";
        KnowledgeBuilder builder1 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder1.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        Collection knowledgePackages1 = builder1.getKnowledgePackages();
        KnowledgeBuilder builder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder2.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        Collection knowledgePackages2 = builder2.getKnowledgePackages();
        InternalKnowledgeBase knowledgeBase1 = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase1.addPackages(knowledgePackages1);
        knowledgeBase1.addPackages(knowledgePackages2);
        Collection knowledgePackagesCombined = knowledgeBase1.getKiePackages();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(knowledgePackagesCombined);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Collection deserializedPackages = (Collection)in.readObject();
        InternalKnowledgeBase knowledgeBase2 = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase2.addPackages(deserializedPackages);
        KieSession ksession = knowledgeBase2.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Person("John"));
            ksession.insert((Object)new Person("Paul"));
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }
}

