/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieSessionTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.time.SessionPseudoClock;

@RunWith(value=Parameterized.class)
public class CepQueryTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private KieSession ksession;
    private SessionPseudoClock clock;
    private EntryPoint firstEntryPoint;
    private EntryPoint secondEntryPoint;

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseStreamConfigurations((boolean)true);
    }

    public CepQueryTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Before
    public void prepare() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + TestEvent.class.getCanonicalName() + ";\ndeclare TestEvent\n    @role( event )\nend\nquery EventsAfterZeroToNineSeconds\n    $event : TestEvent() from entry-point FirstStream\n    $result : TestEvent( this after [0s, 9s] $event) from entry-point SecondStream\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"cep-query-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        this.ksession = kbase.newKieSession(KieSessionTestConfiguration.STATEFUL_PSEUDO.getKieSessionConfiguration(), null);
        this.clock = (SessionPseudoClock)this.ksession.getSessionClock();
        this.firstEntryPoint = this.ksession.getEntryPoint("FirstStream");
        this.secondEntryPoint = this.ksession.getEntryPoint("SecondStream");
    }

    @After
    public void cleanup() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    private void eventsInitialization() {
        this.secondEntryPoint.insert((Object)new TestEvent("minusOne"));
        this.clock.advanceTime(5L, TimeUnit.SECONDS);
        this.firstEntryPoint.insert((Object)new TestEvent("zero"));
        this.secondEntryPoint.insert((Object)new TestEvent("one"));
    }

    @Test
    public void testQueryWithAfter() {
        this.eventsInitialization();
        QueryResults results = this.ksession.getQueryResults("EventsAfterZeroToNineSeconds", new Object[0]);
        ((AbstractIntegerAssert)Assertions.assertThat((int)results.size()).as("Unexpected query result length", new Object[0])).isEqualTo(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((TestEvent)((QueryResultsRow)results.iterator().next()).get("$result")).getName()).as("Unexpected query result content", new Object[0])).isEqualTo("one");
    }

    public static class TestEvent {
        private final String name;

        public TestEvent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "TestEvent[" + this.name + "]";
        }
    }
}

