/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.rule.accessor.Evaluator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.drl.parser.impl.Operator;
import org.drools.mvel.evaluators.BaseEvaluator;
import org.drools.mvel.evaluators.VariableRestriction;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class CustomOperatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CustomOperatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testCustomOperatorUsingCollections() {
        String constraints = "    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\n";
        this.customOperatorUsingCollections(constraints);
    }

    @Test
    public void testCustomOperatorUsingCollectionsInverted() {
        String constraints = "    $bob : Person(name == \"Bob\")\n    $alice : Person(name == \"Alice\", $bob.addresses supersetOf this.addresses)\n";
        this.customOperatorUsingCollections(constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customOperatorUsingCollections(String constraints) {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n" + constraints + "then\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOperatorOnKieModule() {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    public static class SupersetOfEvaluatorDefinition
    implements EvaluatorDefinition {
        public static final Operator SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)false);
        public static final Operator NOT_SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)true);
        private static final String[] SUPPORTED_IDS = new String[]{SUPERSET_OF.getOperatorString()};
        private Evaluator[] evaluator;

        public String[] getEvaluatorIds() {
            return SUPPORTED_IDS;
        }

        public boolean isNegatable() {
            return true;
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
            return new SupersetOfEvaluator(type, isNegated);
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
            return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
        }

        public boolean supportsType(ValueType vt) {
            return true;
        }

        public EvaluatorDefinition.Target getTarget() {
            return EvaluatorDefinition.Target.FACT;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.evaluator = (Evaluator[])in.readObject();
        }
    }

    public static class SupersetOfEvaluator
    extends BaseEvaluator {
        public SupersetOfEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? SupersetOfEvaluatorDefinition.NOT_SUPERSET_OF : SupersetOfEvaluatorDefinition.SUPERSET_OF);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor extractor, FactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(valueResolver, (Object)factHandle);
            return this.evaluateAll((Collection)value.getValue(), (Collection)objectValue);
        }

        public boolean evaluate(ValueResolver valueResolver, ReadAccessor ira, FactHandle left, ReadAccessor ira1, FactHandle right) {
            return this.evaluateAll((Collection)left.getObject(), (Collection)right.getObject());
        }

        public boolean evaluateCachedLeft(ValueResolver valueResolver, VariableRestriction.VariableContextEntry context, FactHandle right) {
            Object valRight = context.extractor.getValue(valueResolver, right.getObject());
            return this.evaluateAll((Collection)((VariableRestriction.ObjectVariableContextEntry)context).left, (Collection)valRight);
        }

        public boolean evaluateCachedRight(ValueResolver reteEvaluator, VariableRestriction.VariableContextEntry context, FactHandle left) {
            Object varLeft = context.declaration.getExtractor().getValue(reteEvaluator, (Object)left);
            return this.evaluateAll((Collection)varLeft, (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateAll(Collection leftCollection, Collection rightCollection) {
            return rightCollection.containsAll(leftCollection);
        }
    }
}

