/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.Result;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MultiSheetsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MultiSheetsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testNoSheet() {
        this.check(null, "Mario can drink");
    }

    @Test
    public void testSheet1() {
        this.check("Sheet1", "Mario can drink");
    }

    @Test
    public void testSheet2() {
        this.check("Sheet2", "Mario can drive");
    }

    @Test
    public void testSheet12() {
        this.check("Sheet1,Sheet2", "Mario can drink", "Mario can drive");
    }

    private void check(String sheets, String ... results) {
        KieServices ks = KieServices.get();
        KieResources kr = ks.getResources();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls", kr.newFileSystemResource("src/test/resources/data/CanDrinkAndDrive.drl.xls")).write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls.properties", (String)(sheets != null ? "sheets=" + sheets : ""));
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("dtblaleKB").addPackage("org.drools.simple.candrink").newKieSessionModel("dtable");
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kb = this.buildDTable(ks, kfs);
        KieContainer kc = ks.newKieContainer(kb.getKieModule().getReleaseId());
        KieSession sessionDtable = kc.newKieSession("dtable");
        Result result = new Result();
        sessionDtable.insert((Object)result);
        sessionDtable.insert((Object)new Person("Mario", 45));
        sessionDtable.fireAllRules();
        for (String r : results) {
            Assertions.assertThat((boolean)result.toString().contains(r)).isTrue();
        }
    }

    private KieBuilder buildDTable(KieServices ks, KieFileSystem kfs) {
        if (this.kieBaseTestConfiguration.getExecutableModelProjectClass().isPresent()) {
            return ks.newKieBuilder(kfs).buildAll((Class)this.kieBaseTestConfiguration.getExecutableModelProjectClass().get());
        }
        return ks.newKieBuilder(kfs).buildAll(DrlProject.class);
    }
}

