/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class QueryConcurrencyTest {
    private static int LOOP = 500;
    private static int THREADS = 32;
    private static int REQUESTS = 32;
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public QueryConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testConstraintConcurrency() {
        String drl = "package com.example.reproducer\nimport " + Bus.class.getCanonicalName() + ";\nimport static " + QueryConcurrencyTest.class.getCanonicalName() + ".TOSTRING;\ndialect \"mvel\"\nquery checkLength(String $s, int $l)\n    $s := String( length == $l )\nend\nrule \"rule_mt_1a\"\n    when\n        $bus : Bus( $check: \"GAMMA RAY\",\n                    $title: \"POWER PLANT\")\n        checkLength(TOSTRING($bus.karaoke.dvd[$title].artist), 9;)\n    then\nend";
        final ArrayList exceptions = new ArrayList();
        System.setProperty("drools.mvel.thread.safety", "synced_till_eval");
        try {
            KieBase kieBase = null;
            if (this.kieBaseTestConfiguration.isExecutableModel()) {
                kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            }
            for (int i = 0; i < LOOP; ++i) {
                if (!this.kieBaseTestConfiguration.isExecutableModel()) {
                    kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                }
                ExecutorService executor = Executors.newFixedThreadPool(THREADS);
                final CountDownLatch latch = new CountDownLatch(THREADS);
                for (int j = 0; j < REQUESTS; ++j) {
                    final KieBase finalKieBase = kieBase;
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            KieSession kSession = finalKieBase.newKieSession();
                            Bus bus1 = new Bus("red", 30);
                            bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "GAMMA RAY"));
                            bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
                            kSession.insert((Object)bus1);
                            kSession.insert((Object)"GAMMA RAY");
                            try {
                                latch.countDown();
                                latch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            try {
                                kSession.fireAllRules();
                            }
                            catch (Exception e) {
                                exceptions.add(e);
                            }
                            finally {
                                kSession.dispose();
                            }
                        }
                    });
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(1000000L, TimeUnit.SECONDS);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!exceptions.isEmpty()) {
                ((Exception)exceptions.get(0)).printStackTrace();
            }
            Assertions.assertThat((int)exceptions.size()).isEqualTo(0);
        }
        finally {
            System.clearProperty("drools.mvel.thread.safety");
        }
    }

    public static String TOSTRING(String s) {
        return s == null ? "null" : s;
    }

    public static String TOSTRING(Object o) {
        return o == null ? "null" : o.toString();
    }

    public static class Bus {
        private String name;
        private int capacity;
        private BigDecimal weight;
        private Karaoke karaoke = new Karaoke();

        public Bus(String name, int capacity) {
            this.name = name;
            this.capacity = capacity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getPerson() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }

        public Karaoke getKaraoke() {
            return this.karaoke;
        }
    }

    public static class Album {
        private String title;
        private String artist;

        public Album(String title, String artist) {
            this.title = title;
            this.artist = artist;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getArtist() {
            return this.artist;
        }

        public void setArtist(String artist) {
            this.artist = artist;
        }
    }

    public static class Karaoke {
        private Map<String, Album> dvd = new HashMap<String, Album>();

        public Map<String, Album> getDvd() {
            return this.dvd;
        }

        public void fix() {
            this.dvd = Collections.unmodifiableMap(this.dvd);
        }
    }
}

