/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.concurrency.Album;
import org.drools.compiler.integrationtests.concurrency.Bus;
import org.drools.mvel.expr.MvelEvaluator;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public abstract class BaseConcurrencyTest {
    protected static int LOOP = 500;
    protected static int THREADS = 32;
    protected static int REQUESTS = 32;
    protected final KieBaseTestConfiguration kieBaseTestConfiguration;

    public BaseConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testConcurrency() {
        String drl = this.getDrl();
        ArrayList exceptions = new ArrayList();
        MvelEvaluator.setEvaluatorType((MvelEvaluator.EvaluatorType)MvelEvaluator.EvaluatorType.SYNCHRONIZED_TILL_EVALUATED);
        try {
            KieBase kieBase = null;
            if (this.kieBaseTestConfiguration.isExecutableModel()) {
                kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            }
            for (int i = 0; i < LOOP; ++i) {
                if (!this.kieBaseTestConfiguration.isExecutableModel()) {
                    kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
                }
                this.preprocess(kieBase);
                ExecutorService executor = Executors.newFixedThreadPool(THREADS);
                CountDownLatch latch = new CountDownLatch(THREADS);
                for (int j = 0; j < REQUESTS; ++j) {
                    KieBase finalKieBase = kieBase;
                    executor.execute(() -> {
                        KieSession kSession = finalKieBase.newKieSession();
                        this.setGlobal(kSession);
                        this.insertFacts(kSession);
                        try {
                            latch.countDown();
                            latch.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            kSession.fireAllRules();
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                        finally {
                            kSession.dispose();
                        }
                    });
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(300L, TimeUnit.SECONDS);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!exceptions.isEmpty()) {
                ((Exception)exceptions.get(0)).printStackTrace();
            }
            Assertions.assertThat((int)exceptions.size()).isEqualTo(0);
        }
        finally {
            MvelEvaluator.resetEvaluatorType();
        }
    }

    protected void preprocess(KieBase kieBase) {
    }

    protected void setGlobal(KieSession kSession) {
    }

    protected abstract String getDrl();

    protected void insertFacts(KieSession kSession) {
        Bus bus1 = new Bus("red", 30);
        bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "GAMMA RAY"));
        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession.insert((Object)bus1);
    }
}

