/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.concurrency;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.integrationtests.concurrency.Album;
import org.drools.compiler.integrationtests.concurrency.BaseConcurrencyTest;
import org.drools.compiler.integrationtests.concurrency.Bus;
import org.drools.compiler.integrationtests.concurrency.StaticUtils;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.test.testcategory.TurtleTestCategory;

@RunWith(value=Parameterized.class)
@Category(value={TurtleTestCategory.class})
public class ConsequenceWithAndOrConcurrencyTest
extends BaseConcurrencyTest {
    public ConsequenceWithAndOrConcurrencyTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        super(kieBaseTestConfiguration);
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Override
    protected String getDrl() {
        return "package com.example.reproducer\nimport " + Bus.class.getCanonicalName() + ";\nimport static " + StaticUtils.class.getCanonicalName() + ".TOSTRING;\ndialect \"mvel\"\nglobal java.util.List result;\nrule \"rule_mt_1a\"\n    when\n        $bus : Bus( $title: \"POWER PLANT\" )\n    then\n        result.add(TOSTRING($bus.karaoke.dvd[$title].artist) == \"BBB\" || TOSTRING($bus.karaoke.dvd[$title].artist) >= \"01\" && TOSTRING($bus.karaoke.dvd[$title].artist) <= \"39\");\nend";
    }

    @Override
    protected void setGlobal(KieSession kSession) {
        ArrayList result = new ArrayList();
        kSession.setGlobal("result", result);
    }

    @Override
    protected void preprocess(KieBase kieBase) {
        KieSession kSession1 = kieBase.newKieSession();
        ArrayList result = new ArrayList();
        kSession1.setGlobal("result", result);
        Bus bus1 = new Bus("red", 30);
        bus1.getKaraoke().getDvd().put("POWER PLANT", new Album("POWER PLANT", "BBB"));
        bus1.getKaraoke().getDvd().put("Somewhere Out In Space", new Album("Somewhere Out In Space", "GAMMA RAY"));
        kSession1.insert((Object)bus1);
        kSession1.fireAllRules();
        kSession1.dispose();
    }
}

