/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.phases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.io.ClassPathResource;
import org.drools.model.codegen.execmodel.PackageSources;
import org.drools.model.codegen.tool.ExplicitCanonicalModelCompiler;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class ExplicitCanonicalModelCompilerTest {
    @Test
    public void testCompile() throws DroolsParserException, IOException {
        ClassPathResource resource = new ClassPathResource("org/drools/compiler/integrationtests/phases/ExplicitCompilerTest.drl");
        KnowledgeBuilderConfigurationImpl configuration = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration().as(KnowledgeBuilderConfigurationImpl.KEY);
        BuildResultCollectorImpl results = new BuildResultCollectorImpl();
        DrlResourceHandler handler = new DrlResourceHandler(configuration);
        PackageDescr packageDescr = handler.process((Resource)resource);
        handler.getResults().forEach(arg_0 -> ((BuildResultCollectorImpl)results).addBuilderResult(arg_0));
        CompositePackageDescr compositePackageDescr = new CompositePackageDescr((Resource)resource, packageDescr);
        List<CompositePackageDescr> compositePackageDescrs = List.of(compositePackageDescr);
        ExplicitCanonicalModelCompiler compiler = ExplicitCanonicalModelCompiler.of(compositePackageDescrs, (KnowledgeBuilderConfigurationImpl)configuration, PackageSources::dumpSources);
        compiler.process();
        ArrayList generatedSources = new ArrayList();
        for (PackageSources src : compiler.getPackageSources()) {
            src.collectGeneratedFiles(generatedSources);
        }
        Assertions.assertThat((int)generatedSources.size()).isEqualTo(4);
    }
}

