/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.builder;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.base.accumulators.AverageAccumulateFunction;
import org.drools.core.base.accumulators.MaxAccumulateFunction;
import org.drools.mvel.evaluators.AfterEvaluatorDefinition;
import org.drools.mvel.evaluators.BeforeEvaluatorDefinition;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.conf.Option;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.api.runtime.rule.EvaluatorDefinition;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.kie.internal.builder.conf.DumpDirOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.ProcessStringEscapesOption;

public class KnowledgeBuilderConfigurationTest {
    private KnowledgeBuilderConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
    }

    @Test
    public void testDefaultDialectConfiguration() {
        this.config.setOption((Option)DefaultDialectOption.get((String)"mvel"));
        Assertions.assertThat((Object)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.KEY))).isEqualTo((Object)DefaultDialectOption.get((String)"mvel"));
        Assertions.assertThat((String)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.KEY)).dialectName()).isEqualTo("mvel");
        Assertions.assertThat((String)this.config.getProperty("drools.dialect.default")).isEqualTo("mvel");
        this.config.setProperty("drools.dialect.default", "java");
        Assertions.assertThat((Object)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.KEY))).isEqualTo((Object)DefaultDialectOption.get((String)"java"));
        Assertions.assertThat((String)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.KEY)).toString()).isEqualTo("DefaultDialectOption( name=java )");
        Assertions.assertThat((String)((DefaultDialectOption)this.config.getOption(DefaultDialectOption.KEY)).dialectName()).isEqualTo("java");
        Assertions.assertThat((String)this.config.getProperty("drools.dialect.default")).isEqualTo("java");
    }

    @Test
    public void testLanguageLevelConfiguration() {
        this.config.setOption((Option)LanguageLevelOption.DRL5);
        Assertions.assertThat((Comparable)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.KEY))).isEqualTo((Object)LanguageLevelOption.DRL5);
        Assertions.assertThat((Comparable)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.KEY))).isEqualTo((Object)LanguageLevelOption.DRL5);
        Assertions.assertThat((String)this.config.getProperty("drools.lang.level")).isEqualTo("DRL5");
        this.config.setProperty("drools.lang.level", "DRL6");
        Assertions.assertThat((Comparable)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.KEY))).isEqualTo((Object)LanguageLevelOption.DRL6);
        Assertions.assertThat((String)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.KEY)).toString()).isEqualTo("DRL6");
        Assertions.assertThat((Comparable)((LanguageLevelOption)this.config.getOption(LanguageLevelOption.KEY))).isEqualTo((Object)LanguageLevelOption.DRL6);
        Assertions.assertThat((String)this.config.getProperty("drools.lang.level")).isEqualTo("DRL6");
    }

    @Test
    public void testAccumulateFunctionConfiguration() {
        HashSet<String> keySet = new HashSet<String>();
        AverageAccumulateFunction function = new AverageAccumulateFunction();
        AccumulateFunctionOption option = AccumulateFunctionOption.get((String)"avg", (AccumulateFunction)function);
        this.config.setOption((Option)option);
        Assertions.assertThat((Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "avg"))).isEqualTo((Object)option);
        Assertions.assertThat((String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "avg")).getName()).isEqualTo("avg");
        Assertions.assertThat((Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "avg")).getFunction()).isEqualTo((Object)function);
        Assertions.assertThat((String)this.config.getProperty("drools.accumulate.function.avg")).isEqualTo(AverageAccumulateFunction.class.getName());
        keySet.add("avg");
        Assertions.assertThat((boolean)this.config.getOptionSubKeys(AccumulateFunctionOption.KEY).contains("avg")).isTrue();
        this.config.setProperty("drools.accumulate.function.maximum", MaxAccumulateFunction.class.getName());
        MaxAccumulateFunction max = new MaxAccumulateFunction();
        Assertions.assertThat((Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "maximum"))).isEqualTo((Object)AccumulateFunctionOption.get((String)"maximum", (AccumulateFunction)max));
        Assertions.assertThat((String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "maximum")).getName()).isEqualTo("maximum");
        Assertions.assertThat((String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "maximum")).getFunction().getClass().getName()).isEqualTo(max.getClass().getName());
        Assertions.assertThat((String)this.config.getProperty("drools.accumulate.function.maximum")).isEqualTo(MaxAccumulateFunction.class.getName());
        keySet.add("avg");
        this.config.setProperty("drools.accumulate.function.inner", InnerAccumulateFunction.class.getName());
        InnerAccumulateFunction inner = new InnerAccumulateFunction();
        Assertions.assertThat((Object)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "inner"))).isEqualTo((Object)AccumulateFunctionOption.get((String)"inner", (AccumulateFunction)inner));
        Assertions.assertThat((String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "inner")).getName()).isEqualTo("inner");
        Assertions.assertThat((String)((AccumulateFunctionOption)this.config.getOption(AccumulateFunctionOption.KEY, "inner")).getFunction().getClass().getName()).isEqualTo(inner.getClass().getName());
        Assertions.assertThat((String)this.config.getProperty("drools.accumulate.function.inner")).isEqualTo(InnerAccumulateFunction.class.getName());
        keySet.add("avg");
        Assertions.assertThat((boolean)this.config.getOptionSubKeys(AccumulateFunctionOption.KEY).containsAll(keySet)).isTrue();
    }

    @Test
    public void testDumpDirectoryConfiguration() {
        File dumpDir = new File("target");
        this.config.setOption((Option)DumpDirOption.get((File)dumpDir));
        Assertions.assertThat((Object)((DumpDirOption)this.config.getOption(DumpDirOption.KEY))).isEqualTo((Object)DumpDirOption.get((File)dumpDir));
        Assertions.assertThat((File)((DumpDirOption)this.config.getOption(DumpDirOption.KEY)).getDirectory()).isEqualTo((Object)dumpDir);
        Assertions.assertThat((String)this.config.getProperty("drools.dump.dir")).isEqualTo(dumpDir.toString());
        dumpDir = new File(System.getProperty("java.io.tmpdir"));
        this.config.setProperty("drools.dump.dir", System.getProperty("java.io.tmpdir"));
        Assertions.assertThat((Object)((DumpDirOption)this.config.getOption(DumpDirOption.KEY))).isEqualTo((Object)DumpDirOption.get((File)dumpDir));
        Assertions.assertThat((File)((DumpDirOption)this.config.getOption(DumpDirOption.KEY)).getDirectory()).isEqualTo((Object)dumpDir);
        Assertions.assertThat((String)this.config.getProperty("drools.dump.dir")).isEqualTo(dumpDir.toString());
    }

    @Test
    public void testEvaluatorConfiguration() {
        AfterEvaluatorDefinition afterDef = new AfterEvaluatorDefinition();
        Assertions.assertThat((Object)afterDef).isNotNull();
        EvaluatorOption option = EvaluatorOption.get((String)"after", (EvaluatorDefinition)afterDef);
        this.config.setOption((Option)option);
        Assertions.assertThat((Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "after"))).isEqualTo((Object)option);
        Assertions.assertThat((String)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "after")).getName()).isEqualTo("after");
        Assertions.assertThat((Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "after")).getEvaluatorDefinition()).isEqualTo((Object)afterDef);
        Assertions.assertThat((String)this.config.getProperty("drools.evaluator.after")).isEqualTo(AfterEvaluatorDefinition.class.getName());
        this.config.setProperty("drools.evaluator.before", BeforeEvaluatorDefinition.class.getName());
        BeforeEvaluatorDefinition beforeDef = new BeforeEvaluatorDefinition();
        Assertions.assertThat((Object)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "before"))).isEqualTo((Object)EvaluatorOption.get((String)"before", (EvaluatorDefinition)beforeDef));
        Assertions.assertThat((String)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "before")).getName()).isEqualTo("before");
        Assertions.assertThat((String)((EvaluatorOption)this.config.getOption(EvaluatorOption.KEY, "before")).getEvaluatorDefinition().getClass().getName()).isEqualTo(beforeDef.getClass().getName());
        Assertions.assertThat((String)this.config.getProperty("drools.evaluator.before")).isEqualTo(beforeDef.getClass().getName());
    }

    @Test
    public void testProcessStringEscapesConfiguration() {
        this.config.setOption((Option)ProcessStringEscapesOption.YES);
        Assertions.assertThat((Comparable)((ProcessStringEscapesOption)this.config.getOption(ProcessStringEscapesOption.KEY))).isEqualTo((Object)ProcessStringEscapesOption.YES);
        Assertions.assertThat((String)this.config.getProperty("drools.parser.processStringEscapes")).isEqualTo("true");
        this.config.setProperty("drools.parser.processStringEscapes", "false");
        Assertions.assertThat((Comparable)((ProcessStringEscapesOption)this.config.getOption(ProcessStringEscapesOption.KEY))).isEqualTo((Object)ProcessStringEscapesOption.NO);
        Assertions.assertThat((String)this.config.getProperty("drools.parser.processStringEscapes")).isEqualTo("false");
    }

    @Test
    public void testDefaultPackageNameConfiguration() {
        this.config.setOption((Option)DefaultPackageNameOption.get((String)"org.drools.mvel.compiler.test"));
        Assertions.assertThat((Object)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.KEY))).isEqualTo((Object)DefaultPackageNameOption.get((String)"org.drools.mvel.compiler.test"));
        Assertions.assertThat((String)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.KEY)).getPackageName()).isEqualTo("org.drools.mvel.compiler.test");
        Assertions.assertThat((String)this.config.getProperty("drools.defaultPackageName")).isEqualTo("org.drools.mvel.compiler.test");
        this.config.setProperty("drools.defaultPackageName", "org.drools");
        Assertions.assertThat((Object)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.KEY))).isEqualTo((Object)DefaultPackageNameOption.get((String)"org.drools"));
        Assertions.assertThat((String)((DefaultPackageNameOption)this.config.getOption(DefaultPackageNameOption.KEY)).getPackageName()).isEqualTo("org.drools");
        Assertions.assertThat((String)this.config.getProperty("drools.defaultPackageName")).isEqualTo("org.drools");
    }

    public static class InnerAccumulateFunction
    implements AccumulateFunction {
        public void accumulate(Serializable context, Object value) {
        }

        public Serializable createContext() {
            return null;
        }

        public Object getResult(Serializable context) throws Exception {
            return null;
        }

        public void init(Serializable context) throws Exception {
        }

        public void reverse(Serializable context, Object value) throws Exception {
        }

        public boolean supportsReverse() {
            return false;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public Class<?> getResultType() {
            return Object.class;
        }
    }
}

