/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.kie.builder.impl;

import java.io.InputStream;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieBuilderSetImpl;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.io.ResourceFactory;

@RunWith(value=Parameterized.class)
public class KieBuilderSetImplTest
extends CommonTestMethodBase {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KieBuilderSetImplTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testBuild() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/rule%201.drl", this.ruleContent());
        KieBuilderSetImpl kieBuilderSet = new KieBuilderSetImpl(this.kieBuilder(ks, kfs));
        kieBuilderSet.setFiles(new String[]{"src/main/resources/rule%201.drl"});
        IncrementalResults build = kieBuilderSet.build();
        Assertions.assertThat((int)build.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)build.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    @Ignore(value="RHPAM-1184, RHDM-601")
    public void testBuildPercentageAndWhiteSpaceInName() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/my rule 100% okay.rdrl", ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("my rule 100% okay.rdrl")));
        KieBuilderSetImpl kieBuilderSet = new KieBuilderSetImpl(this.kieBuilder(ks, kfs));
        kieBuilderSet.setFiles(new String[]{"src/main/resources/my rule 100% okay.rdrl"});
        IncrementalResults build = kieBuilderSet.build();
        Assertions.assertThat((int)build.getAddedMessages().size()).isEqualTo(0);
        Assertions.assertThat((int)build.getRemovedMessages().size()).isEqualTo(0);
    }

    @Test
    public void testDummyResourceWithAnEncodedFileName() {
        KieBuilderSetImpl.DummyResource dummyResource = new KieBuilderSetImpl.DummyResource("Dummy%20Resource");
        KieBuilderSetImpl.DummyResource testResource = new KieBuilderSetImpl.DummyResource("Dummy Resource");
        Assertions.assertThat((Object)dummyResource).isEqualTo((Object)testResource);
    }

    @Test
    public void testDummyResourceWithWrongEncodedFileName() {
        KieBuilderSetImpl.DummyResource dummyResource = new KieBuilderSetImpl.DummyResource("Dummy 100%");
        Assertions.assertThat((String)"Dummy 100%").isEqualTo(dummyResource.getSourcePath());
    }

    private KieBuilderImpl kieBuilder(KieServices ks, KieFileSystem kfs) {
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromKieFileSystem((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieFileSystem)kfs, (boolean)true);
        return (KieBuilderImpl)kieBuilder;
    }

    private String ruleContent() {
        return "package org.kie.test\nimport java.util.concurrent.atomic.AtomicInteger\nglobal java.util.List list\nrule 'rule 1'\nwhen\n $i: AtomicInteger(intValue > 0)\nthen\n list.add( $i );\nend\n\n";
    }
}

