/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.oopath;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalFactHandle;
import org.drools.mvel.compiler.oopath.model.Child;
import org.drools.mvel.compiler.oopath.model.Man;
import org.drools.mvel.compiler.oopath.model.Toy;
import org.drools.mvel.compiler.oopath.model.Woman;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class OOPathBenchmarkTest {
    private static final String RELATIONAL_DRL = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n    $man : Man()\n    $wife : Woman( husband == $man.name )\n    $child : Child( mother == $wife.name, age > 10 )\n    $toy : Toy( owner == $child.name )\nthen\n    list.add( $toy.getName() );\nend\n";
    private static final String FROM_DRL = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n    $man: Man( $wife: wife )\n    $child: Child( age > 10 ) from $wife.children\n    $toy: Toy() from $child.toys\nthen\n    list.add( $toy.getName() );\nend\n";
    private static final String OOPATH_DRL = "import org.drools.mvel.compiler.oopath.model.*;\nglobal java.util.List list\n\nrule R when\n  Man( $toy: /wife/children[age > 10]/toys )\nthen\n  list.add( $toy.getName() );\nend\n";

    public static void main(String[] args) {
        int n = 100000;
        System.out.println("Relational version");
        OOPathBenchmarkTest.runTest(new RelationalTest(), n);
        System.out.println("-------------------------------------");
        System.out.println("From version");
        OOPathBenchmarkTest.runTest(new FromTest(), n);
        System.out.println("-------------------------------------");
        System.out.println("OOPath version");
        OOPathBenchmarkTest.runTest(new OOPathTest(), n);
    }

    private static void runTest(Test test, int n) {
        KieBase kbase = OOPathBenchmarkTest.getKieBase(test.getDrl());
        for (int i = 0; i < 3; ++i) {
            test.runTest(kbase, n);
            System.gc();
        }
        BenchmarkResult batch = new BenchmarkResult("Batch");
        BenchmarkResult incremental = new BenchmarkResult("Incremental");
        for (int i = 0; i < 10; ++i) {
            long[] result = test.runTest(kbase, n);
            batch.accumulate(result[0]);
            incremental.accumulate(result[1]);
            System.gc();
        }
        System.out.println(batch);
        System.out.println(incremental);
    }

    public static long[] testRelational(KieBase kbase, int n) {
        long[] result = new long[2];
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        List<Man> model = OOPathBenchmarkTest.generateModel(n);
        List<Child> toBeModified = OOPathBenchmarkTest.getChildToBeModified(model);
        long start = System.nanoTime();
        List<InternalFactHandle> fhs = OOPathBenchmarkTest.insertFullModel(ksession, model);
        ksession.fireAllRules();
        result[0] = System.nanoTime() - start;
        list.clear();
        start = System.nanoTime();
        for (Child child : toBeModified) {
            child.setAge(11);
        }
        for (InternalFactHandle fh : fhs) {
            ksession.update((FactHandle)fh, fh.getObject());
        }
        ksession.fireAllRules();
        result[1] = System.nanoTime() - start;
        Assertions.assertThat((int)n).isEqualTo(list.size());
        ksession.dispose();
        return result;
    }

    public static long[] testFrom(KieBase kbase, int n) {
        long[] result = new long[2];
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        List<Man> model = OOPathBenchmarkTest.generateModel(n);
        List<Child> toBeModified = OOPathBenchmarkTest.getChildToBeModified(model);
        long start = System.nanoTime();
        List<InternalFactHandle> fhs = OOPathBenchmarkTest.insertModel(ksession, model);
        ksession.fireAllRules();
        result[0] = System.nanoTime() - start;
        list.clear();
        start = System.nanoTime();
        for (Child child : toBeModified) {
            child.setAge(11);
        }
        for (InternalFactHandle fh : fhs) {
            ksession.update((FactHandle)fh, fh.getObject());
        }
        ksession.fireAllRules();
        result[1] = System.nanoTime() - start;
        Assertions.assertThat((int)(n * 3)).isEqualTo(list.size());
        ksession.dispose();
        return result;
    }

    public static long[] testOOPath(KieBase kbase, int n) {
        long[] result = new long[2];
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        List<Man> model = OOPathBenchmarkTest.generateModel(n);
        List<Child> toBeModified = OOPathBenchmarkTest.getChildToBeModified(model);
        long start = System.nanoTime();
        OOPathBenchmarkTest.insertModel(ksession, model);
        ksession.fireAllRules();
        result[0] = System.nanoTime() - start;
        list.clear();
        start = System.nanoTime();
        for (Child child : toBeModified) {
            child.setAge(11);
        }
        ksession.fireAllRules();
        result[1] = System.nanoTime() - start;
        Assertions.assertThat((int)n).isEqualTo(list.size());
        ksession.dispose();
        return result;
    }

    private static KieBase getKieBase(String drl) {
        return new KieHelper().addContent(drl, ResourceType.DRL).build(new KieBaseOption[0]);
    }

    private static List<Man> generateModel(int nr) {
        ArrayList<Man> model = new ArrayList<Man>();
        for (int i = 0; i < nr; ++i) {
            Man man = new Man("m" + i, 40);
            model.add(man);
            Woman woman = new Woman("w" + i, 35);
            man.setWife(woman);
            woman.setHusband(man.getName());
            Child childA = new Child("cA" + i, 12);
            woman.addChild(childA);
            childA.setMother(woman.getName());
            Child childB = new Child("cB" + i, 10);
            woman.addChild(childB);
            childB.setMother(woman.getName());
            Toy toyA = new Toy("tA" + i);
            toyA.setOwner(childA.getName());
            childA.addToy(toyA);
            Toy toyB = new Toy("tB" + i);
            toyB.setOwner(childA.getName());
            childA.addToy(toyB);
            Toy toyC = new Toy("tC" + i);
            toyC.setOwner(childB.getName());
            childB.addToy(toyC);
        }
        return model;
    }

    private static List<Child> getChildToBeModified(List<Man> model) {
        ArrayList<Child> toBeModified = new ArrayList<Child>();
        for (Man man : model) {
            for (Child child : man.getWife().getChildren()) {
                if (child.getAge() != 10) continue;
                toBeModified.add(child);
            }
        }
        return toBeModified;
    }

    private static List<InternalFactHandle> insertModel(KieSession ksession, List<Man> model) {
        ArrayList<InternalFactHandle> fhs = new ArrayList<InternalFactHandle>();
        for (Man man : model) {
            fhs.add((InternalFactHandle)ksession.insert((Object)man));
        }
        return fhs;
    }

    private static List<InternalFactHandle> insertFullModel(KieSession ksession, List<Man> model) {
        ArrayList<InternalFactHandle> toBeModified = new ArrayList<InternalFactHandle>();
        for (Man man : model) {
            ksession.insert((Object)man);
            ksession.insert((Object)man.getWife());
            for (Child child : man.getWife().getChildren()) {
                InternalFactHandle fh = (InternalFactHandle)ksession.insert((Object)child);
                if (child.getAge() == 10) {
                    toBeModified.add(fh);
                }
                for (Toy toy : child.getToys()) {
                    ksession.insert((Object)toy);
                }
            }
        }
        return toBeModified;
    }

    private static class RelationalTest
    implements Test {
        private RelationalTest() {
        }

        @Override
        public long[] runTest(KieBase kbase, int n) {
            return OOPathBenchmarkTest.testRelational(kbase, n);
        }

        @Override
        public String getDrl() {
            return OOPathBenchmarkTest.RELATIONAL_DRL;
        }
    }

    static interface Test {
        public long[] runTest(KieBase var1, int var2);

        public String getDrl();
    }

    private static class FromTest
    implements Test {
        private FromTest() {
        }

        @Override
        public long[] runTest(KieBase kbase, int n) {
            return OOPathBenchmarkTest.testFrom(kbase, n);
        }

        @Override
        public String getDrl() {
            return OOPathBenchmarkTest.FROM_DRL;
        }
    }

    private static class OOPathTest
    implements Test {
        private OOPathTest() {
        }

        @Override
        public long[] runTest(KieBase kbase, int n) {
            return OOPathBenchmarkTest.testOOPath(kbase, n);
        }

        @Override
        public String getDrl() {
            return OOPathBenchmarkTest.OOPATH_DRL;
        }
    }

    public static class BenchmarkResult {
        private final String name;
        private long min = Long.MAX_VALUE;
        private long max = 0L;
        private long sum = 0L;
        private int counter = 0;

        public BenchmarkResult(String name) {
            this.name = name;
        }

        public void accumulate(long result) {
            if (result < this.min) {
                this.min = result;
            }
            if (result > this.max) {
                this.max = result;
            }
            this.sum += result;
            ++this.counter;
        }

        private long getAverage() {
            return (this.sum - this.min - this.max) / (long)(this.counter - 2);
        }

        public String toString() {
            return this.name + " results: min = " + this.min + "; max = " + this.max + "; avg = " + this.getAverage();
        }
    }
}

