/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class DroolsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final int NUM_FACTS = 20;
    private static int counter;

    public DroolsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test1() throws Exception {
        Object str = "package org.drools.mvel.integrationtests;\n";
        str = (String)str + "import " + DroolsTest.class.getName() + ";\n";
        str = (String)str + "import " + DroolsTest.class.getName() + ".Foo;\n";
        str = (String)str + "import " + DroolsTest.class.getName() + ".Bar;\n";
        str = (String)str + "rule test\n";
        str = (String)str + "when\n";
        str = (String)str + "      Foo($p : id, id < " + Integer.toString(20) + ")\n";
        str = (String)str + "      Bar(id == $p)\n";
        str = (String)str + "then\n";
        str = (String)str + "   DroolsTest.incCounter();\n";
        str = (String)str + "end\n";
        counter = 0;
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession wm = kbase.newKieSession();
        for (int i = 0; i < 20; ++i) {
            wm.insert((Object)new Foo(i));
            wm.insert((Object)new Bar(i));
        }
        wm.fireAllRules();
        System.out.println(counter + ":" + (counter == 20 ? "passed" : "failed"));
    }

    public static void incCounter() {
        ++counter;
    }

    public static class Foo
    implements Serializable {
        private final int id;

        public Foo(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class Bar
    implements Serializable {
        private final int id;

        public Bar(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

