/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

public class KieSessionIterationTest {
    private KieBase kieBase;

    @Before
    public void setup() {
        this.kieBase = new KieHelper().build(new KieBaseOption[0]);
        this.kieBase.newKieSession();
        this.kieBase.newKieSession();
        this.kieBase.newKieSession();
    }

    @After
    public void cleanup() {
        if (this.kieBase != null) {
            ArrayList kieSessions = new ArrayList();
            kieSessions.addAll(this.kieBase.getKieSessions());
            for (KieSession kieSession : kieSessions) {
                kieSession.dispose();
            }
        }
    }

    @Test
    public void testDisposingSeveralKieSessions() throws Exception {
        for (KieSession kieSession : this.kieBase.getKieSessions()) {
            kieSession.dispose();
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.kieBase.getKieSessions().isEmpty()).as("All KieSessions of the KieBase should have been disposed.", new Object[0])).isTrue();
    }
}

