/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteDumper;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class NodePositionInPathTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NodePositionInPathTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void test() {
        String drl = "rule R1 when\n    Integer()\n    exists( Integer() and Integer() )\n    String()\nthen\nend\nrule R2 when\n    Integer()\n    exists( Integer() and String() )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ReteDumper.dumpRete((InternalRuleBase)((InternalRuleBase)kbase));
        Rete rete = ((InternalRuleBase)kbase).getRete();
        LeftInputAdapterNode liaNode = null;
        for (ObjectTypeNode otn : rete.getObjectTypeNodes()) {
            Class otnType = ((ClassObjectType)otn.getObjectType()).getClassType();
            if (Integer.class != otnType) continue;
            liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        }
        Assertions.assertThat((int)liaNode.getPathIndex()).isEqualTo(0);
        LeftTupleSink[] liaSinks = liaNode.getSinkPropagator().getSinks();
        BetaNode join1 = (BetaNode)liaSinks[0];
        Assertions.assertThat((int)join1.getPathIndex()).isEqualTo(1);
        ExistsNode ex1 = (ExistsNode)liaSinks[1];
        Assertions.assertThat((int)ex1.getPathIndex()).isEqualTo(1);
        BetaNode join2 = (BetaNode)ex1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)join2.getPathIndex()).isEqualTo(2);
        RuleTerminalNode rtn1 = (RuleTerminalNode)join2.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)rtn1.getPathIndex()).isEqualTo(3);
        ExistsNode ex2 = (ExistsNode)liaSinks[2];
        Assertions.assertThat((int)ex2.getPathIndex()).isEqualTo(1);
        RuleTerminalNode rtn2 = (RuleTerminalNode)ex2.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)rtn2.getPathIndex()).isEqualTo(2);
        BetaNode join3 = (BetaNode)join1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)join3.getPathIndex()).isEqualTo(2);
        RightInputAdapterNode ria1 = (RightInputAdapterNode)join3.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)ria1.getPathIndex()).isEqualTo(3);
        BetaNode join4 = (BetaNode)join1.getSinkPropagator().getSinks()[1];
        Assertions.assertThat((int)join4.getPathIndex()).isEqualTo(2);
        RightInputAdapterNode ria2 = (RightInputAdapterNode)join4.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((int)ria2.getPathIndex()).isEqualTo(3);
        LeftTupleNode[] rtn1PathNodes = rtn1.getPathNodes();
        Assertions.assertThat((int)rtn1PathNodes.length).isEqualTo(4);
        this.checkNodePosition(rtn1PathNodes, (LeftTupleNode)liaNode);
        this.checkNodePosition(rtn1PathNodes, (LeftTupleNode)ex1);
        this.checkNodePosition(rtn1PathNodes, (LeftTupleNode)join2);
        this.checkNodePosition(rtn1PathNodes, (LeftTupleNode)rtn1);
        LeftTupleNode[] rtn2PathNodes = rtn2.getPathNodes();
        Assertions.assertThat((int)rtn2PathNodes.length).isEqualTo(3);
        this.checkNodePosition(rtn2PathNodes, (LeftTupleNode)liaNode);
        this.checkNodePosition(rtn2PathNodes, (LeftTupleNode)ex2);
        this.checkNodePosition(rtn2PathNodes, (LeftTupleNode)rtn2);
        LeftTupleNode[] ria1PathNodes = ria1.getPathNodes();
        Assertions.assertThat((int)ria1PathNodes.length).isEqualTo(4);
        this.checkNodePosition(ria1PathNodes, (LeftTupleNode)liaNode);
        this.checkNodePosition(ria1PathNodes, (LeftTupleNode)join1);
        this.checkNodePosition(ria1PathNodes, (LeftTupleNode)join3);
        this.checkNodePosition(ria1PathNodes, (LeftTupleNode)ria1);
        LeftTupleNode[] ria2PathNodes = ria2.getPathNodes();
        Assertions.assertThat((int)ria2PathNodes.length).isEqualTo(4);
        this.checkNodePosition(ria2PathNodes, (LeftTupleNode)liaNode);
        this.checkNodePosition(ria2PathNodes, (LeftTupleNode)join1);
        this.checkNodePosition(ria2PathNodes, (LeftTupleNode)join4);
        this.checkNodePosition(ria2PathNodes, (LeftTupleNode)ria2);
    }

    private void checkNodePosition(LeftTupleNode[] pathNodes, LeftTupleNode node) {
        Assertions.assertThat((Object)pathNodes[node.getPathIndex()]).isEqualTo((Object)node);
    }
}

