/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;

@RunWith(value=Parameterized.class)
public class PackageInMultipleResourcesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PackageInMultipleResourcesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testSamePackageRulesInDRLAndRF() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rf_test_rules.drl", "rf_test_rueflow.rf"});
        KiePackage kiePackage = kbase.getKiePackage("com.example.rules");
        List ruleNames = kiePackage.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
        Assertions.assertThat((int)ruleNames.size()).isEqualTo(3);
        Assertions.assertThat(ruleNames).contains((Object[])new String[]{"RuleFlow-Split-example-xxx-DROOLS_DEFAULT", "Left Rule", "Right Rule"});
    }

    @Test
    public void testDifferentPackagesRulesInDRLAndRF() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"rf_test_rules_different_pkg.drl", "rf_test_rueflow.rf"});
        KiePackage kiePackage = kbase.getKiePackage("com.example.rules");
        List ruleNames = kiePackage.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
        Assertions.assertThat((int)ruleNames.size()).isEqualTo(1);
        Assertions.assertThat(ruleNames).contains((Object[])new String[]{"RuleFlow-Split-example-xxx-DROOLS_DEFAULT"});
        KiePackage kiePackageDiffPkg = kbase.getKiePackage("com.example.rules.different.pkg");
        List ruleNamesDiffPkg = kiePackageDiffPkg.getRules().stream().map(rule -> rule.getName()).collect(Collectors.toList());
        Assertions.assertThat((int)ruleNamesDiffPkg.size()).isEqualTo(2);
        Assertions.assertThat(ruleNamesDiffPkg).contains((Object[])new String[]{"Left Rule", "Right Rule"});
    }
}

