/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.State;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class PropertyReactivityTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PropertyReactivityTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test(timeout=10000L)
    public void testComposedConstraint() {
        String str = "package org.drools.test;\n\nimport " + Klass2.class.getCanonicalName() + ";\n\nrule R when \n $k2 : Klass2(b == 0 || c == 0)\nthen modify($k2) { setD(1) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Klass2 k2 = new Klass2(0, 0, 0, 0);
        ksession.insert((Object)k2);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        Assertions.assertThat((int)k2.getD()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testScrambleProperties() {
        String str = "package org.drools.test\n global java.util.List list\n declare Parent\n @propertyReactive\n a : int\n k : int\n z : int\n end\n\n declare Child extends Parent\n @propertyReactive\n p : int\n end\n\n\n rule Init\n when\n then\n insert( new Child( 1, 3, 5, 7 ) );\n end\n\n rule Mod\n when\n $p : Parent()\n then\n modify( $p ) { setZ( 99 ); }\n end\n\n rule React2\n when\n Child( p == 7 )\n then\n list.add( \"React2\" );\n end\n\n rule React\n when\n Child( z == 99 )\n then\n list.add( \"React\" );\n end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.test\n global java.util.List list\n declare Parent\n @propertyReactive\n a : int\n k : int\n z : int\n end\n\n declare Child extends Parent\n @propertyReactive\n p : int\n end\n\n\n rule Init\n when\n then\n insert( new Child( 1, 3, 5, 7 ) );\n end\n\n rule Mod\n when\n $p : Parent()\n then\n modify( $p ) { setZ( 99 ); }\n end\n\n rule React2\n when\n Child( p == 7 )\n then\n list.add( \"React2\" );\n end\n\n rule React\n when\n Child( z == 99 )\n then\n list.add( \"React\" );\n end"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("React")).isTrue();
        Assertions.assertThat((boolean)list.contains("React2")).isTrue();
    }

    @Test(timeout=10000L)
    public void testScrambleWithInterfaces() {
        String str = "package org.drools.test;\n\nimport " + Intf1.class.getCanonicalName() + ";\nimport " + Intf2.class.getCanonicalName() + ";\nimport " + Klass.class.getCanonicalName() + ";\nimport " + Klass2.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass( 1, 2, 3, 4, 5, 6 ) );\n  insert( new Klass2( 2, 3, 4, 5 ) );\nend\n\nrule \"On1\"\nwhen\n  $x : Intf1( )\nthen\n  System.out.println( \"Modify by interface \" );\n  modify ( $x ) { setD( 200 ) }\nend\nrule \"On2\"\nwhen\n  $x : Klass2( )\nthen\n  System.out.println( \"Modify by class \" );\n  modify ( $x ) { setD( 200 ) }\nend\n\nrule \"Log1\"\nwhen\n  Klass( d == 200, $id : id ) \nthen\n  System.out.println( \"Log1 - As K1 \" + $id );\n  list.add( $id + \"@K1\" );\nend\n\nrule \"Log2\"\nwhen\n  Klass2( d == 200, $id : id ) \nthen\n  System.out.println( \"Log2 - As K2 \" + $id );\n  list.add( $id + \"@K2\" );\nend\n\nrule \"Log3\"\nwhen\n  Intf1( d == 200, $id : id ) \nthen\n  System.out.println( \"Log3 - As I1 \" + $id );\n  list.add( $id + \"@I1\" );\nend\n\nrule \"Log4\"\nwhen\n  Intf2( d == 200, $id : id ) \nthen\n  System.out.println( \"Log4 - As K2 \" + $id );\n  list.add( $id + \"@I2\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        System.out.println(list);
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("k1@K1", "k1@I1", "k1@I2"))).isTrue();
        Assertions.assertThat((boolean)list.containsAll(Arrays.asList("k2@K2", "k2@I2"))).isTrue();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
    }

    @Test(timeout=10000L)
    public void testScrambleWithInterfacesAndObject() {
        String str = "package org.drools.test;\n\nimport " + Intf2.class.getCanonicalName() + ";\nimport " + Klass2.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass2( 2, 3, 4, 5 ) );\nend\nrule \"Mod\"\nwhen\n  $x : Intf2( )\nthen\n  modify ( $x ) { setD( 200 ) }\nend\n\nrule \"Log\"\nwhen\n  Klass2( d == 200, $id : id ) \nthen\n  list.add( \"Klass2\" );\nend\n\nrule \"LogObject\" salience -1\nwhen\n  $o : Object( ) \nthen\n  list.add( $o.getClass().getSimpleName() );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("Klass2");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("Klass2");
    }

    @Test(timeout=10000L)
    public void testRepeatedPatternWithPR() {
        String str1 = "package org.test;\nglobal java.util.List list; \ndeclare SampleBean \n@propertyReactive \nx : java.math.BigDecimal \ny : java.math.BigDecimal \nid : Long @key\nend \n rule \"calculate y\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n y =5B;\n }\n list.add( $bean.y ); \n end\n\n rule \"calculate x\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n x =10B;\n }\n list.add( $bean.x ); \n end\n rule Init \n when\n then\n insert( new SampleBean( 1L ) ); \n end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.test;\nglobal java.util.List list; \ndeclare SampleBean \n@propertyReactive \nx : java.math.BigDecimal \ny : java.math.BigDecimal \nid : Long @key\nend \n rule \"calculate y\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n y =5B;\n }\n list.add( $bean.y ); \n end\n\n rule \"calculate x\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n x =10B;\n }\n list.add( $bean.x ); \n end\n rule Init \n when\n then\n insert( new SampleBean( 1L ) ); \n end"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains(new BigDecimal(10))).isTrue();
        Assertions.assertThat((boolean)list.contains(new BigDecimal(5))).isTrue();
    }

    @Test(timeout=10000L)
    public void testPRWithCollections() {
        String str1 = "package org.test;\nimport java.util.*\n\nglobal List list;\ndeclare java.util.ArrayList end \ndeclare MyList extends java.util.ArrayList \nend\n\ndeclare Bean\n@propertyReactive\n id : int\n num : int\n values : MyList \n checks : Map \n str : String\nend\n\n\nrule Init\nwhen\nthen\n insert( new Bean( 42, 0, new MyList(), new HashMap(), \"\" ) );\nend\n\nrule M1\nwhen\n $b : Bean( id == 42 )\nthen\n System.out.println( 1 ); \n list.add( 1 ); \n modify ( $b ) { setNum( 1 ); }\nend\n\nrule M2\nwhen\n $b : Bean( num == 1 )\nthen\n System.out.println( 2 ); \n list.add( 2 ); \n modify ( $b ) { getValues().add( \"foo\" ); }\nend\n\nrule M3\nwhen\n $b : Bean( values contains \"foo\" )\nthen\n System.out.println( 3 ); \n list.add( 3 ); \n modify ( $b ) { setStr( \"x\" ); }\nend\n \n rule M4\nwhen\n $b : Bean( str == \"x\" )\nthen\n System.out.println( 4 ); \n list.add( 4 ); \n modify ( $b ) { getChecks().put( \"x\", 13 ); }\nend\n\nrule M5\nwhen\n $b : Bean( checks[ \"x\" ] > 10 )\nthen\n System.out.println( 5 ); \n list.add( 5 ); \n modify ( $b ) { getChecks().clear(); }\nend\n\nrule Log\nsalience 1\nwhen\n $b : Bean() @watch( values, checks ) \nthen\n System.out.println( \"Log >> \" + $b );\n list.add( 0 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.test;\nimport java.util.*\n\nglobal List list;\ndeclare java.util.ArrayList end \ndeclare MyList extends java.util.ArrayList \nend\n\ndeclare Bean\n@propertyReactive\n id : int\n num : int\n values : MyList \n checks : Map \n str : String\nend\n\n\nrule Init\nwhen\nthen\n insert( new Bean( 42, 0, new MyList(), new HashMap(), \"\" ) );\nend\n\nrule M1\nwhen\n $b : Bean( id == 42 )\nthen\n System.out.println( 1 ); \n list.add( 1 ); \n modify ( $b ) { setNum( 1 ); }\nend\n\nrule M2\nwhen\n $b : Bean( num == 1 )\nthen\n System.out.println( 2 ); \n list.add( 2 ); \n modify ( $b ) { getValues().add( \"foo\" ); }\nend\n\nrule M3\nwhen\n $b : Bean( values contains \"foo\" )\nthen\n System.out.println( 3 ); \n list.add( 3 ); \n modify ( $b ) { setStr( \"x\" ); }\nend\n \n rule M4\nwhen\n $b : Bean( str == \"x\" )\nthen\n System.out.println( 4 ); \n list.add( 4 ); \n modify ( $b ) { getChecks().put( \"x\", 13 ); }\nend\n\nrule M5\nwhen\n $b : Bean( checks[ \"x\" ] > 10 )\nthen\n System.out.println( 5 ); \n list.add( 5 ); \n modify ( $b ) { getChecks().clear(); }\nend\n\nrule Log\nsalience 1\nwhen\n $b : Bean() @watch( values, checks ) \nthen\n System.out.println( \"Log >> \" + $b );\n list.add( 0 );\nend"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(0, 1, 2, 0, 3, 4, 0, 5, 0));
    }

    @Test(timeout=10000L)
    public void testPRWithPositionalUnification() {
        String str1 = "package org.test;\nglobal java.util.List list; \ndeclare Man \n@propertyReactive \n name : String \nend \ndeclare Animal \n@propertyReactive \n id : int \n owner : String \n age : int \nend \nrule Init \nwhen \nthen \n insert( new Man( \"alan\" ) ); \n insert( new Animal( 1, \"bob\", 7 ) ); \nend \nrule \"Mod Man\" \nwhen \n $m :Man() \nthen \n modify ( $m ) { setName( \"bob\" ); } \nend \nrule \"Mod Per\" \nwhen \n $m :Animal() \nthen \n modify ( $m ) {  setId( 1 ); \n  } \nend \nrule Join_1\nwhen\n Man( $name ; ) \n Animal( $name == owner ) \nthen\n list.add( 1 ); \nend\nrule Join_3\nwhen\n Man( $name ; ) \n Animal( $id, $name; ) \n Integer( this == $id ) \nthen\n list.add( 2 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.test;\nglobal java.util.List list; \ndeclare Man \n@propertyReactive \n name : String \nend \ndeclare Animal \n@propertyReactive \n id : int \n owner : String \n age : int \nend \nrule Init \nwhen \nthen \n insert( new Man( \"alan\" ) ); \n insert( new Animal( 1, \"bob\", 7 ) ); \nend \nrule \"Mod Man\" \nwhen \n $m :Man() \nthen \n modify ( $m ) { setName( \"bob\" ); } \nend \nrule \"Mod Per\" \nwhen \n $m :Animal() \nthen \n modify ( $m ) {  setId( 1 ); \n  } \nend \nrule Join_1\nwhen\n Man( $name ; ) \n Animal( $name == owner ) \nthen\n list.add( 1 ); \nend\nrule Join_3\nwhen\n Man( $name ; ) \n Animal( $id, $name; ) \n Integer( this == $id ) \nthen\n list.add( 2 ); \nend\n"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Assertions.assertThat((boolean)list.contains(1)).isTrue();
        Assertions.assertThat((boolean)list.contains(2)).isTrue();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testPRConstraintOnAttributesWithoutSetter() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass3( fullName == 'Walter White' )\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list).isEqualTo(List.of("XXX -> Walter"));
    }

    @Test(timeout=10000L)
    public void testPRConstraintOnAttributesWithoutSetterUsingWatches() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass3( fullName == 'Walter White' ) @watch( name, lastName)\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list).isEqualTo(Arrays.asList("XXX -> Walter", "Find Heisenberg"));
    }

    @Test(timeout=10000L)
    public void testPRConstraintOnAttributesWithoutSetterUsingModifies() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass4( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass4( fullName == 'Walter White' )\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass4( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list).isEqualTo(Arrays.asList("XXX -> Walter", "Find Heisenberg"));
    }

    @Test(timeout=10000L)
    public void testPRBindingOnAttributesWithoutSetter() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass3( $fullName: fullName )\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list).isEqualTo(List.of("XXX White"));
    }

    @Test(timeout=10000L)
    public void testPRBindingOnAttributesWithoutSetterUsingWatches() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass3( $fullName: fullName ) @watch( name, lastName)\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list).isEqualTo(Arrays.asList("XXX White", "Walter White"));
    }

    @Test(timeout=10000L)
    public void testPRBindingOnAttributesWithoutSetterUsingModifies() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass4( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( $fullName: fullName )\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass4( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list).isEqualTo(Arrays.asList("XXX White", "Walter White"));
    }

    @Test(timeout=10000L)
    public void testPRBindingOnNonexistingAttributes() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( $name: nonexistingName )\nthen\n  list.add( $fullName );\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{str});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test(timeout=10000L)
    public void testPRBindingOnNonexistingWatchedAttribute() {
        String str = "package org.drools.test;\n\nimport org.drools.mvel.integrationtests.PropertyReactivityTest.Klass4;\n\nglobal java.util.List list;\n\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( ) @watch( nmae )\nthen\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.test;\n\nimport org.drools.mvel.integrationtests.PropertyReactivityTest.Klass4;\n\nglobal java.util.List list;\n\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( ) @watch( nmae )\nthen\nend\n"});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as("Should have an error", new Object[0])).isFalse();
    }

    @Test(timeout=10000L)
    public void testModifyAfterInsertWithPropertyReactive() {
        String rule1 = "\npackage com.sample;\nimport " + MyClass.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule r0\nthen insert( new MyClass() );\nend\nrule r1 salience 1\nwhen   MyClass(value == null)\nthen   list.add( 1 );\nend\n\nrule r2 salience 2\nwhen   m : MyClass(value == null)\nthen   modify(m) { setData(\"test\") }\n  list.add( 2 );\nend\n\nrule r3 salience 3\nwhen   MyClass(value == null)\nthen   list.add( 3 );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(4);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)3);
        Assertions.assertThat(list.get(1)).isEqualTo((Object)2);
        Assertions.assertThat(list.get(2)).isEqualTo((Object)1);
    }

    @Test(timeout=10000L)
    public void testIndexedNotWatchedProperty() {
        String rule1 = "package com.sample;\nimport " + MyClass.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R1 when\n    $s : String()\n    $m : MyClass( data != null, value == $s ) @watch( !* )\nthen \n    list.add($s);\n    modify( $m ) { setValue(\"2\") };\nend\n\nrule R2 when\n    $i : Integer()\n    $m : MyClass( value == $i.toString(), data == \"x\" ) @watch( !value )\nthen \n    modify( $m ) { setValue(\"3\"), setData(\"y\") };\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        MyClass myClass = new MyClass();
        myClass.setValue("1");
        myClass.setData("x");
        ksession.insert((Object)myClass);
        ksession.insert((Object)"1");
        ksession.insert((Object)2);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("1");
        list.clear();
        ksession.insert((Object)"3");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("3");
    }

    @Test
    public void testModifyWithGetter() {
        String rule1 = "package foo.bar\nimport " + Person.class.getName() + "\ndeclare Person @propertyReactive end\nrule x\n    when\n       $p : Person( address != null ) @watch(!address) \n    then\n       modify($p){getAddress().setStreet(\"foo\");}\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person();
        p.setAddress(new Address());
        ksession.insert((Object)p);
        int fired = ksession.fireAllRules(10);
        Assertions.assertThat((int)fired).isEqualTo(1);
        Assertions.assertThat((String)p.getAddress().getStreet()).isEqualTo("foo");
    }

    @Test(timeout=10000L)
    public void testMoreThan64Fields() {
        StringBuilder fields = new StringBuilder();
        for (int i = 10; i < 100; ++i) {
            fields.append("  a").append(i).append(" : int\n");
        }
        String str = "package org.drools.test\nglobal java.util.List list;\ndeclare BigType @propertyReactive\n" + fields + "end\nrule Init when\nthen\n  insert( new BigType() );end\nrule R when\n  $b : BigType( a11 == 0, a98 == 0 )then\n  modify($b) { setA12(1), setA99(1) };\n  list.add(1);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test(timeout=10000L)
    public void testMoreThan64FieldsMultipleFirings() {
        StringBuilder fields = new StringBuilder();
        for (int i = 10; i < 100; ++i) {
            fields.append("  a").append(i).append(" : int\n");
        }
        String str = "package org.drools.test\nglobal java.util.List list;\ndeclare BigType @propertyReactive\n" + fields + "end\nrule Init when\nthen\n  insert( new BigType() );end\nrule R when\n  $b : BigType( a11 == 0, a12 < 10, a98 == 0 )then\n  modify($b) { setA12($b.getA12()+1), setA99(1) };\n  list.add(1);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(10);
    }

    @Test(timeout=10000L)
    public void testMoreThan64FieldsWithWatch() {
        StringBuilder fields = new StringBuilder();
        for (int i = 10; i < 100; ++i) {
            fields.append("  a").append(i).append(" : int\n");
        }
        String str = "package org.drools.test\nglobal java.util.List list;\ndeclare BigType @propertyReactive\n" + fields + "end\nrule Init when\nthen\n  insert( new BigType() );end\nrule R when\n  $b : BigType( a11 == 0, a99 < 10 ) @watch(!a99)then\n  modify($b) { setA12(1), setA99(1) };\n  list.add(1);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testPropReactiveAnnotationOnDifferentDrl() {
        String str1 = "package org.jboss.ddoyle.drools.propertyreactive;\n\nimport " + Event1.class.getCanonicalName() + ";\n\ndeclare Event1\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 2d )\n    @propertyReactive\nend\n";
        String str2 = "package org.jboss.ddoyle.drools.propertyreactive;\n\nimport " + Event1.class.getCanonicalName() + ";\n\nrule \"rule_1\"\n    when\n       Event1() @watch(*, !code)\n    then\n       System.out.println(\"Rule fired.\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1, str2});
    }

    @Test
    public void testPropReactiveWithParentClassNotImplementingChildInterface() {
        String str1 = "import " + DummyBeanInterface.class.getCanonicalName() + "\nimport " + DummyBean.class.getCanonicalName() + "\nrule \"RG_TEST_1\"\n    when\n       $event: DummyBean (!active)\n    then\n        modify($event){\n            setActive(true)\n        }\n        System.out.println(\"RG_TEST_1 fired\");\nend\n\nrule \"RG_TEST_2\"\n    when\n       $event: DummyBeanInterface (!active)\n    then\n        System.out.println(\"RG_TEST_2 fired, with event \" + $event);\n        throw new IllegalStateException(\"Should not happen since the event is active\");\nend\n\nrule \"RG_TEST_3\"\n    when\n       $event: DummyBean ()\n    then\n        retract($event);\n        System.out.println(\"RG_TEST_3 fired\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new DummyBean("1"));
        ksession.fireAllRules();
        ksession.insert((Object)new DummyBean("2"));
        ksession.fireAllRules();
    }

    @Test
    public void testPropReactiveUpdate() {
        String str1 = "import " + Klass.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R when\n  Klass( b == 2 )\nthen\n  list.add(\"fired\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Klass bean = new Klass(1, 2, 3, 4, 5, 6);
        FactHandle fh = ksession.insert((Object)bean);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        ksession.update(fh, (Object)bean, new String[]{"a", "d"});
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        ksession.update(fh, (Object)bean, new String[]{"c", "b"});
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test
    public void testSetterInConcreteClass() {
        String drl = "import " + BaseFact.class.getCanonicalName() + ";\nimport " + MyFact.class.getCanonicalName() + ";\nrule R when\n    $b : BaseFact( $n : name, name != null )\nthen end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        MyFact f = new MyFact();
        FactHandle fh = ksession.insert((Object)f);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
        f.setName("hello");
        ksession.update(fh, (Object)f, new String[]{"name"});
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testSetterInConcreteClass2() {
        String drl = "package org.test;\nimport " + BusStop.class.getCanonicalName() + ";\nimport " + Shuttle.class.getCanonicalName() + ";\nimport " + StopOrHub.class.getCanonicalName() + ";\nrule shuttleDestinationIsCoachOrHub\n    when\n        $destination : StopOrHub(visitedByCoach == false)\n        Shuttle(destination == $destination)\n    then\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        BusStop busStop = new BusStop();
        Shuttle shuttle = new Shuttle();
        busStop.setVisitedByCoach(true);
        FactHandle fhShuttle = kieSession.insert((Object)shuttle);
        FactHandle fhBusStop = kieSession.insert((Object)busStop);
        kieSession.update(fhShuttle, (Object)shuttle.setDestination(busStop));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(0);
        kieSession.update(fhBusStop, (Object)busStop.setVisitedByCoach(false), new String[]{"visitedByCoach"});
        Assertions.assertThat((Object)shuttle.getDestination()).isEqualTo((Object)busStop);
        Assertions.assertThat((boolean)busStop.isVisitedByCoach()).isFalse();
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
        kieSession.update(fhBusStop, (Object)busStop);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testWatchFieldInExternalPattern() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\" )\n    $p2 : Person( age > $p1.age ) \nthen\n    list.add(\"t0\");\nend\nrule Z when\n    $p1 : Person( name == \"Mario\" ) \nthen\n    modify($p1) { setAge(35); } \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testWatchFieldInExternalPatternWithNoConstraints() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person()\n    $p2 : Person( name == \"Mark\", age > $p1.age ) \nthen\n    list.add(\"t0\");\nend\nrule Z when\n    $p1 : Person( name == \"Mario\" ) \nthen\n    modify($p1) { setAge(35); } \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testWatchFieldInExternalNotPattern() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule R when\n    $p1 : Person( name == \"Mario\" )\n    not( Person( age < $p1.age ) )\nthen\n    list.add(\"t0\");\nend\nrule Z when\n    $p1 : Person( name == \"Mario\" ) \nthen\n    modify($p1) { setAge(35); } \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mario = new Person("Mario", 40);
        Person mark = new Person("Mark", 37);
        FactHandle fh_mario = ksession.insert((Object)mario);
        ksession.insert((Object)mark);
        int x = ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("t0");
    }

    @Test
    public void testPropertyChangeSupportNewAPI() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_PropertyChangeTypeDecl.drl"});
        KieSession session = kbase.newKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        State state = new State("initial");
        session.insert((Object)state);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        state.setFlag(true);
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        session.fireAllRules();
        Assertions.assertThat((int)((List)session.getGlobal("list")).size()).isEqualTo(1);
        state.setState("finished");
        session.dispose();
        Assertions.assertThat((int)state.getPropertyChangeListeners().length).isEqualTo(0);
    }

    @Test
    public void testAccumulateWithPR() {
        String drl = "declare A end\n declare B\n value : String\nend\n rule Foo when\n    $s : A()\n    accumulate( String()\n                and\n                B( $val : value ),\n                $set : collectSet( $val )\n              )\nthen end\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)errors.isEmpty()).as(errors.toString(), new Object[0])).isTrue();
    }

    @Test
    public void testUpdateOnNonExistingProperty() {
        String str1 = "import " + Klass.class.getCanonicalName() + "\nrule R when\n  Klass( b == 2 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        Klass bean = new Klass(1, 2, 3, 4, 5, 6);
        FactHandle fh = ksession.insert((Object)bean);
        ksession.fireAllRules();
        try {
            ksession.update(fh, (Object)bean, new String[]{"z"});
            Assertions.fail((String)"Trying to update not existing property must fail");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)e.getMessage().contains(Klass.class.getName())).isTrue();
        }
    }

    @Test(timeout=5000L)
    public void testPRAfterAccumulate() {
        String str1 = "import " + Order.class.getCanonicalName() + "\nimport " + OrderLine.class.getCanonicalName() + "\nrule R when\n        $o: Order($lines: orderLines)\n        Number(intValue >= 15) from accumulate(\n            OrderLine($q: quantity) from $lines\n            , sum($q)\n        )\n    then\n        modify($o) { setPrice(10) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        Order order = new Order(Arrays.asList(new OrderLine(9), new OrderLine(8)), 12);
        ksession.insert((Object)order);
        ksession.fireAllRules();
        Assertions.assertThat((int)order.getPrice()).isEqualTo(10);
    }

    @Test
    public void testGetterWithoutArgShouldBePropReactve() {
        String str1 = "import " + StrangeGetter.class.getCanonicalName() + "\nrule R when\n        $s: StrangeGetter(getValue() == 1)\n    then\n        modify($s) { setAnother(10) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        StrangeGetter bean = new StrangeGetter();
        bean.setValue(1);
        ksession.insert((Object)bean);
        Assertions.assertThat((int)ksession.fireAllRules(3)).isEqualTo(1);
    }

    @Test
    public void testGetterWithArgShouldNotBePropReactve() {
        String str1 = "import " + StrangeGetter.class.getCanonicalName() + "\nrule R when\n        $s: StrangeGetter(getValue(1) == 1)\n    then\n        modify($s) { setAnother(10) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str1});
        KieSession ksession = kbase.newKieSession();
        StrangeGetter bean = new StrangeGetter();
        bean.setValue(1);
        ksession.insert((Object)bean);
        Assertions.assertThat((int)ksession.fireAllRules(3)).isEqualTo(3);
    }

    @Test
    public void testComment() {
        String str1 = "package com.example\n\ndeclare Counter\n    value: int\nend\n\nrule \"Init\" when\n    not Counter()\nthen\n    drools.insert(new Counter(0));\nend\n\nrule \"Loop\"\nwhen\n    $c: Counter()\nthen\n// removing this comment line removes the loop\n    $c.setValue(1);\n    update($c);\nend\n\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package com.example\n\ndeclare Counter\n    value: int\nend\n\nrule \"Init\" when\n    not Counter()\nthen\n    drools.insert(new Counter(0));\nend\n\nrule \"Loop\"\nwhen\n    $c: Counter()\nthen\n// removing this comment line removes the loop\n    $c.setValue(1);\n    update($c);\nend\n\n"});
        KieSession ksession = kbase.newKieSession();
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }

    @PropertyReactive
    public static class Klass2
    implements Intf2 {
        private String id = "k2";
        private int b;
        private int c;
        private int d;
        private int e;

        public Klass2(int b, int c, int d, int e) {
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }

        @Override
        public int getD() {
            return this.d;
        }

        @Override
        public void setD(int d) {
            this.d = d;
        }

        @Override
        public int getE() {
            return this.e;
        }

        @Override
        public void setE(int e) {
            this.e = e;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    @PropertyReactive
    public static interface Intf1 {
        public int getC();

        public void setC(int var1);

        public int getD();

        public void setD(int var1);

        public int getF();

        public void setF(int var1);

        public String getId();
    }

    @PropertyReactive
    public static interface Intf2 {
        public int getD();

        public void setD(int var1);

        public int getE();

        public void setE(int var1);

        public String getId();
    }

    @PropertyReactive
    public static class Klass
    implements Intf1,
    Intf2 {
        private String id = "k1";
        private int a;
        private int b;
        private int c;
        private int d;
        private int e;
        private int f;

        public Klass(int a, int b, int c, int d, int e, int f) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        @Override
        public int getC() {
            return this.c;
        }

        @Override
        public void setC(int c) {
            this.c = c;
        }

        @Override
        public int getD() {
            return this.d;
        }

        @Override
        public void setD(int d) {
            this.d = d;
        }

        @Override
        public int getE() {
            return this.e;
        }

        @Override
        public void setE(int e) {
            this.e = e;
        }

        @Override
        public int getF() {
            return this.f;
        }

        @Override
        public void setF(int f) {
            this.f = f;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    @PropertyReactive
    public static class Klass3 {
        private String name;
        private String lastName;

        public Klass3(String name, String lastName) {
            this.name = name;
            this.lastName = lastName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.name + " " + this.lastName;
        }
    }

    @PropertyReactive
    public static class Klass4 {
        private String name;
        private String lastName;

        public Klass4(String name, String lastName) {
            this.name = name;
            this.lastName = lastName;
        }

        public String getName() {
            return this.name;
        }

        @Modifies(value={"fullName"})
        public void setName(String name) {
            this.name = name;
        }

        public String getLastName() {
            return this.lastName;
        }

        @Modifies(value={"fullName"})
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.name + " " + this.lastName;
        }
    }

    @PropertyReactive
    public static class MyClass {
        private String value;
        private String data;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    public static class Event1 {
        private int id;
        private String code;
        private long timestamp;

        public Event1(String code, int id) {
            this.code = code;
            this.id = id;
        }

        public String getCode() {
            return this.code;
        }

        public int getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    @PropertyReactive
    public static interface DummyBeanInterface {
        public boolean isActive();

        public void setActive(boolean var1);
    }

    @PropertyReactive
    public static class DummyBean
    extends ParentDummyBean
    implements DummyBeanInterface {
        private boolean active;

        public DummyBean(String id) {
            super(id);
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void setActive(boolean active) {
            this.active = active;
        }

        public String toString() {
            return "DummyEvent{id='" + this.getId() + "', active=" + this.active + "}";
        }
    }

    public abstract class BaseFact {
        public abstract String getName();
    }

    public class MyFact
    extends BaseFact {
        private String name;

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @PropertyReactive
    public static class BusStop
    implements StopOrHub {
        private boolean visitedByCoach;

        @Override
        public boolean isVisitedByCoach() {
            return this.visitedByCoach;
        }

        public BusStop setVisitedByCoach(boolean visitedByCoach) {
            this.visitedByCoach = visitedByCoach;
            return this;
        }
    }

    @PropertyReactive
    public static class Shuttle {
        private StopOrHub destination;

        public StopOrHub getDestination() {
            return this.destination;
        }

        public Shuttle setDestination(StopOrHub destination) {
            this.destination = destination;
            return this;
        }
    }

    @PropertyReactive
    public static interface StopOrHub {
        public boolean isVisitedByCoach();
    }

    public static class Order {
        private final List<OrderLine> orderLines;
        private int price;

        public Order(List<OrderLine> orderLines, int price) {
            this.orderLines = orderLines;
            this.price = price;
        }

        public List<OrderLine> getOrderLines() {
            return this.orderLines;
        }

        public int getPrice() {
            return this.price;
        }

        public void setPrice(int price) {
            this.price = price;
        }
    }

    public static class OrderLine {
        private final int quantity;

        public OrderLine(int quantity) {
            this.quantity = quantity;
        }

        public int getQuantity() {
            return this.quantity;
        }
    }

    public static class StrangeGetter {
        private int value;
        private int another;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getValue(int ignored) {
            return this.value;
        }

        public int getAnother() {
            return this.another;
        }

        public void setAnother(int another) {
            this.another = another;
        }
    }

    public static class ParentDummyBean {
        private String id;

        public ParentDummyBean(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

