/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.ConsequenceMetaData;
import org.drools.core.impl.InternalRuleBase;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class RuleMetadataTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleMetadataTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testModify() {
        String rule1 = "modify( $a ) { setA( 20 ), setB( $bb ) }";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo("org.drools.A");
        Assertions.assertThat((int)statment.getFields().size()).isEqualTo(2);
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assertions.assertThat((String)field1.getName()).isEqualTo("a");
        Assertions.assertThat((String)field1.getValue()).isEqualTo("20");
        Assertions.assertThat((boolean)field1.isLiteral()).isTrue();
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assertions.assertThat((String)field2.getName()).isEqualTo("b");
        Assertions.assertThat((String)field2.getValue()).isEqualTo("$bb");
        Assertions.assertThat((boolean)field2.isLiteral()).isFalse();
    }

    @Test
    public void testModify2() {
        String rule1 = "modify( $a ) { setC( $bc ) };\n modify( $b ) { c = \"Hello\" };";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(2);
        ConsequenceMetaData.Statement statment1 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment1.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment1.getFactClassName()).isEqualTo("org.drools.A");
        Assertions.assertThat((int)statment1.getFields().size()).isEqualTo(1);
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment1.getFields().get(0);
        Assertions.assertThat((String)field1.getName()).isEqualTo("c");
        Assertions.assertThat((String)field1.getValue()).isEqualTo("$bc");
        Assertions.assertThat((boolean)field1.isLiteral()).isFalse();
        ConsequenceMetaData.Statement statment2 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(1);
        Assertions.assertThat((Comparable)statment2.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment2.getFactClassName()).isEqualTo(B.class.getName());
        Assertions.assertThat((int)statment2.getFields().size()).isEqualTo(1);
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment2.getFields().get(0);
        Assertions.assertThat((String)field2.getName()).isEqualTo("c");
        Assertions.assertThat((String)field2.getValue()).isEqualTo("\"Hello\"");
        Assertions.assertThat((boolean)field2.isLiteral()).isTrue();
    }

    @Test
    public void testRetract() {
        String rule1 = "retract( $b );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.RETRACT);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo(B.class.getName());
    }

    @Test
    public void testRetractWithFunction() {
        String rule1 = "retract( getA($a) );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.RETRACT);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo("org.drools.A");
    }

    @Test
    public void testUpdate() {
        String rule1 = "$a.setA( 20 );\n $a.setB( $bb );\n update( $a );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo("org.drools.A");
        Assertions.assertThat((int)statment.getFields().size()).isEqualTo(2);
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assertions.assertThat((String)field1.getName()).isEqualTo("a");
        Assertions.assertThat((String)field1.getValue()).isEqualTo("20");
        Assertions.assertThat((boolean)field1.isLiteral()).isTrue();
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assertions.assertThat((String)field2.getName()).isEqualTo("b");
        Assertions.assertThat((String)field2.getValue()).isEqualTo("$bb");
        Assertions.assertThat((boolean)field2.isLiteral()).isFalse();
    }

    @Test
    public void testUpdate2() {
        String rule1 = "$a.setC( $bc );\n $b.c = \"Hello\";\n update( $a );\n update( $b );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(2);
        ConsequenceMetaData.Statement statment1 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment1.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment1.getFactClassName()).isEqualTo("org.drools.A");
        Assertions.assertThat((int)statment1.getFields().size()).isEqualTo(1);
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment1.getFields().get(0);
        Assertions.assertThat((String)field1.getName()).isEqualTo("c");
        Assertions.assertThat((String)field1.getValue()).isEqualTo("$bc");
        Assertions.assertThat((boolean)field1.isLiteral()).isFalse();
        ConsequenceMetaData.Statement statment2 = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(1);
        Assertions.assertThat((Comparable)statment2.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.MODIFY);
        Assertions.assertThat((String)statment2.getFactClassName()).isEqualTo(B.class.getName());
        Assertions.assertThat((int)statment2.getFields().size()).isEqualTo(1);
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment2.getFields().get(0);
        Assertions.assertThat((String)field2.getName()).isEqualTo("c");
        Assertions.assertThat((String)field2.getValue()).isEqualTo("\"Hello\"");
        Assertions.assertThat((boolean)field2.isLiteral()).isTrue();
    }

    @Test
    public void testInsert() {
        String rule1 = "insert( new A(1, $bb, \"3\") );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.INSERT);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo("org.drools.A");
        Assertions.assertThat((int)statment.getFields().size()).isEqualTo(3);
        ConsequenceMetaData.Field field1 = (ConsequenceMetaData.Field)statment.getFields().get(0);
        Assertions.assertThat((String)field1.getName()).isEqualTo("a");
        Assertions.assertThat((String)field1.getValue()).isEqualTo("1");
        Assertions.assertThat((boolean)field1.isLiteral()).isTrue();
        ConsequenceMetaData.Field field2 = (ConsequenceMetaData.Field)statment.getFields().get(1);
        Assertions.assertThat((String)field2.getName()).isEqualTo("b");
        Assertions.assertThat((String)field2.getValue()).isEqualTo("$bb");
        Assertions.assertThat((boolean)field2.isLiteral()).isFalse();
        ConsequenceMetaData.Field field3 = (ConsequenceMetaData.Field)statment.getFields().get(2);
        Assertions.assertThat((String)field3.getName()).isEqualTo("c");
        Assertions.assertThat((String)field3.getValue()).isEqualTo("\"3\"");
        Assertions.assertThat((boolean)field3.isLiteral()).isTrue();
    }

    @Test
    public void testInsert2() {
        String rule1 = "insert( new B(1, $ab) );";
        KieBase kbase = this.getKnowledgeBase(rule1);
        RuleImpl rule = this.getRule(kbase, "R0");
        ConsequenceMetaData consequenceMetaData = rule.getConsequenceMetaData();
        Assertions.assertThat((int)consequenceMetaData.getStatements().size()).isEqualTo(1);
        ConsequenceMetaData.Statement statment = (ConsequenceMetaData.Statement)consequenceMetaData.getStatements().get(0);
        Assertions.assertThat((Comparable)statment.getType()).isEqualTo((Object)ConsequenceMetaData.Statement.Type.INSERT);
        Assertions.assertThat((String)statment.getFactClassName()).isEqualTo(B.class.getName());
    }

    private KieBase getKnowledgeBase(String ... consequences) {
        String rule = "package org.drools\nimport " + B.class.getCanonicalName() + "\nglobal java.util.List list;\nfunction A getA(A a) {\n    return a;\n}declare A\n    a : int\n    b : int\n    c : String\nend\n";
        int i = 0;
        for (String str : consequences) {
            rule = rule + "rule R" + i++ + "\nwhen\n   $a : A( $aa : a, $ab : b, $ac : c )\n   $b : B( $ba : a, $bb : b, $bc : c )\nthen\n" + str + "\nend\n";
        }
        return KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
    }

    private RuleImpl getRule(KieBase kbase, String ruleName) {
        return ((InternalRuleBase)kbase).getPackage("org.drools").getRule(ruleName);
    }

    public static class B {
        public int a;
        public int b;
        public String c;

        public B() {
        }

        public B(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public String getC() {
            return this.c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }
}

