/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.core.common.EventSupport;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.core.event.DefaultRuleRuntimeEventListener;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.FactC;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.command.Command;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.SequentialOption;
import org.kie.api.conf.SessionsPoolOption;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieContainerSessionsPool;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionsPool;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;

@RunWith(value=Parameterized.class)
public class SessionsPoolTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public SessionsPoolTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testKieSessionsPool() {
        KieContainerSessionsPool pool = this.getKieContainer().newKieSessionsPool(1);
        KieSession ksession = pool.newKieSession();
        try {
            this.checkKieSession(ksession);
        }
        finally {
            ksession.dispose();
        }
        try {
            ksession.insert((Object)"test2");
            Assertions.fail((String)"it shouldn't be possible to operate on a disposed session even if created from a pool");
        }
        catch (Exception exception) {
            // empty catch block
        }
        KieSession ksession2 = pool.newKieSession();
        Assertions.assertThat((Object)ksession2).isSameAs((Object)ksession);
        Assertions.assertThat((Object)ksession2.getGlobal("list")).isNull();
        this.checkKieSession(ksession2);
        pool.shutdown();
        try {
            ksession.insert((Object)"test3");
            Assertions.fail((String)"after pool shutdown all sessions created from it should be disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            pool.newKieSession();
            Assertions.fail((String)"after pool shutdown it shouldn't be possible to get sessions from it");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPooledKieBase() {
        KieBaseConfiguration kbConf = KieServices.get().newKieBaseConfiguration();
        kbConf.setOption((Option)SessionsPoolOption.get((int)1));
        KieBase kBase = this.getKieContainer().newKieBase(kbConf);
        KieSession ksession = kBase.newKieSession();
        try {
            this.checkKieSession(ksession);
        }
        finally {
            ksession.dispose();
        }
        try {
            ksession.insert((Object)"test2");
            Assertions.fail((String)"it shouldn't be possible to operate on a disposed session even if created from a pool");
        }
        catch (Exception exception) {
            // empty catch block
        }
        KieSession ksession2 = kBase.newKieSession();
        Assertions.assertThat((Object)ksession2).isSameAs((Object)ksession);
        Assertions.assertThat((Object)ksession2.getGlobal("list")).isNull();
        this.checkKieSession(ksession2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKieSessionsPoolInMultithreadEnv() throws InterruptedException, ExecutionException {
        KieContainerSessionsPool pool = this.getKieContainer().newKieSessionsPool(4);
        int THREAD_NR = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        try {
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
            for (int i = 0; i < 10; ++i) {
                ecs.submit(() -> {
                    try {
                        KieSession ksession = pool.newKieSession();
                        try {
                            this.checkKieSession(ksession);
                        }
                        finally {
                            ksession.dispose();
                        }
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
            }
            boolean success = true;
            for (int i = 0; i < 10; ++i) {
                success = (Boolean)ecs.take().get() != false && success;
            }
            Assertions.assertThat((boolean)success).isTrue();
        }
        finally {
            executor.shutdown();
        }
        pool.shutdown();
        try {
            pool.newKieSession();
            Assertions.fail((String)"after pool shutdown it shouldn't be possible to get sessions from it");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testStatelessKieSessionsPool() {
        KieContainerSessionsPool pool = this.getKieContainer().newKieSessionsPool(1);
        StatelessKieSession session = pool.newStatelessKieSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)"test");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        session.execute((Object)"test");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    private KieContainer getKieContainer() {
        String drl = "global java.util.List list\nrule R1 when\n  $s: String()\nthen\n  list.add($s);\nend\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        return KieServices.get().newKieContainer(kieModule.getReleaseId());
    }

    private void checkKieSession(KieSession ksession) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testSegmentMemoriesReset() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nglobal java.util.List list\nrule R1 when\n  String()\n  $i : AtomicInteger()\n  not Boolean()\nthen\n  insert(true);\n  insert($i.incrementAndGet());\nend\n\nrule R2 when \n  String()\n  $i : AtomicInteger()\nthen\nend\n\nrule R3 when\n  Integer( this > 2 )\nthen\n  list.add(\"OK\");\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kcontainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieContainerSessionsPool pool = kcontainer.newKieSessionsPool(1);
        AtomicInteger i = new AtomicInteger(1);
        KieSession ksession = pool.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)i);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        ksession = pool.newKieSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)i);
        ksession.insert((Object)"test");
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        pool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSegmentMemoriesResetWithNotNodeInTheMiddle() {
        String drl = "import " + FactA.class.getCanonicalName() + ";\nimport " + FactB.class.getCanonicalName() + ";\nimport " + FactC.class.getCanonicalName() + ";\nrule R1\nwhen\n  $factA : FactA( field1 == \"code1\")\n  not FactC( f2 == 1 && f1 == \"code1\")\n  $factB : FactB( f2 == 1 )\nthen\nend\nrule R2\nwhen\n  $factA : FactA( field1 == \"code1\")\n  not FactC( f2 == 1 && f1 == \"code1\")\n  $factB : FactB( f2 == 3 )\nthen\nend\nrule R3\nwhen\n  $factA: FactA( field1 == \"code1\")\n  $factC: FactC( f1 == \"code1\")\nthen\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kcontainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieContainerSessionsPool pool = kcontainer.newKieSessionsPool(1);
        KieSession ksession = pool.newKieSession();
        try {
            this.createFactAndInsert(ksession);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
        ksession = pool.newKieSession();
        try {
            this.createFactAndInsert(ksession);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
        pool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSegmentMemoriesResetWithNotNodeInTheMiddle2() {
        String drl = "import " + FactA.class.getCanonicalName() + ";\nimport " + FactB.class.getCanonicalName() + ";\nimport " + FactC.class.getCanonicalName() + ";\nrule R1\nwhen\n  $factA : FactA( field1 == \"code1\")\n  not FactC( f2 == 1 && f1 == \"code1\")\n  $factB : FactB( f2 == 3 )\nthen\nend\nrule R2\nwhen\n  $factA : FactA( field1 == \"code1\")\n  not FactC( f2 == 1 && f1 == \"code1\")\n  $factB : FactB( f2 == 1 )\nthen\nend\nrule R3\nwhen\n  $factA: FactA( field1 == \"code1\")\n  $factC: FactC( f1 == \"code1\")\nthen\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kcontainer = KieServices.get().newKieContainer(kieModule.getReleaseId());
        KieContainerSessionsPool pool = kcontainer.newKieSessionsPool(1);
        KieSession ksession = pool.newKieSession();
        try {
            this.createFactAndInsert(ksession);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
        ksession = pool.newKieSession();
        try {
            this.createFactAndInsert(ksession);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
        pool.shutdown();
    }

    private void createFactAndInsert(KieSession ksession) {
        FactA factA = new FactA();
        factA.setField1("code1");
        ksession.insert((Object)factA);
        FactB factB = new FactB();
        factB.setF2(1);
        ksession.insert((Object)factB);
        FactC factC = new FactC();
        factC.setF1("code3");
        factC.setF2(2);
        ksession.insert((Object)factC);
    }

    @Test
    public void testStatelessSequential() {
        String drl = "import " + AtomicInteger.class.getCanonicalName() + ";\nglobal java.util.List list\nrule R1 when\n  String()\n  Integer()\nthen\n  list.add(\"OK\");\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{SequentialOption.YES});
        KieSessionsPool pool = kbase.newKieSessionsPool(1);
        StatelessKieSession ksession = pool.newStatelessKieSession();
        ArrayList list = new ArrayList();
        ArrayList<Command> commands = new ArrayList<Command>(5);
        commands.add(CommandFactory.newSetGlobal((String)"list", list));
        commands.add(CommandFactory.newInsert((Object)"test"));
        commands.add(CommandFactory.newInsert((Object)1));
        commands.add(CommandFactory.newFireAllRules());
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        list.clear();
        ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        pool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenersReset() {
        KieContainerSessionsPool pool = this.getKieContainer().newKieSessionsPool(1);
        KieSession ksession = pool.newKieSession();
        try {
            ksession.addEventListener((AgendaEventListener)new DefaultAgendaEventListener());
            ksession.addEventListener((RuleRuntimeEventListener)new DefaultRuleRuntimeEventListener());
            ((RuleEventManager)ksession).addEventListener(new RuleEventListener(){});
        }
        finally {
            ksession.dispose();
        }
        ksession = pool.newKieSession();
        try {
            Assertions.assertThat((Collection)ksession.getAgendaEventListeners()).hasSize(0);
            Assertions.assertThat((Collection)ksession.getRuleRuntimeEventListeners()).hasSize(0);
            Assertions.assertThat((List)((EventSupport)ksession).getRuleEventSupport().getEventListeners()).hasSize(0);
        }
        finally {
            ksession.dispose();
        }
    }
}

