/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PolymorphicFact;
import org.drools.mvel.compiler.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class TypeCoercionTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public TypeCoercionTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testRuntimeTypeCoercion() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuntimeTypeCoercion.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PolymorphicFact fact = new PolymorphicFact(10);
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo(fact.getData());
        fact.setData("10");
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat(list.get(1)).isEqualTo(fact.getData());
        fact.setData(Boolean.TRUE);
        ksession.update(handle, (Object)fact);
        Assertions.assertThat((int)list.size()).isEqualTo(2);
    }

    @Test
    public void testRuntimeTypeCoercion2() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_RuntimeTypeCoercion2.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Primitives fact = new Primitives();
        fact.setBooleanPrimitive(true);
        fact.setBooleanWrapper(Boolean.TRUE);
        fact.setObject(Boolean.TRUE);
        fact.setCharPrimitive('X');
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        int index = 0;
        ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as(((Object)list).toString(), new Object[0])).isEqualTo(4);
        Assertions.assertThat(list.get(index++)).isEqualTo((Object)"boolean");
        Assertions.assertThat(list.get(index++)).isEqualTo((Object)"boolean wrapper");
        Assertions.assertThat(list.get(index++)).isEqualTo((Object)"boolean object");
        Assertions.assertThat(list.get(index++)).isEqualTo((Object)"char");
        fact.setBooleanPrimitive(false);
        fact.setBooleanWrapper(null);
        fact.setCharPrimitive('\u0000');
        fact.setObject(Character.valueOf('X'));
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        Assertions.assertThat(list.get(index++)).isEqualTo((Object)"char object");
        fact.setObject(null);
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(6);
        Assertions.assertThat(list.get(index)).isEqualTo((Object)"null object");
    }

    @Test
    public void testUnwantedCoersion() throws Exception {
        String rule = "package org.drools.compiler\nimport " + InnerBean.class.getCanonicalName() + ";\nimport " + OuterBean.class.getCanonicalName() + ";\nrule \"Test.Code One\"\nwhen\n   OuterBean($code : inner.code in (\"1.50\", \"2.50\"))\nthen\n   System.out.println(\"Code compared values: 1.50, 2.50 - actual code value: \" + $code);\nend\nrule \"Test.Code Two\"\nwhen\n   OuterBean($code : inner.code in (\"1.5\", \"2.5\"))\nthen\n   System.out.println(\"Code compared values: 1.5, 2.5 - actual code value: \" + $code);\nend\nrule \"Big Test ID One\"\nwhen\n   OuterBean($id : id in (\"3.5\", \"4.5\"))\nthen\n   System.out.println(\"ID compared values: 3.5, 4.5 - actual ID value: \" + $id);\nend\nrule \"Big Test ID Two\"\nwhen\n   OuterBean($id : id in ( \"3.0\", \"4.0\"))\nthen\n   System.out.println(\"ID compared values: 3.0, 4.0 - actual ID value: \" + $id);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        InnerBean innerTest = new InnerBean();
        innerTest.setCode("1.500");
        ksession.insert((Object)innerTest);
        OuterBean outerTest = new OuterBean();
        outerTest.setId("3");
        outerTest.setInner(innerTest);
        ksession.insert((Object)outerTest);
        OuterBean outerTest2 = new OuterBean();
        outerTest2.setId("3.0");
        outerTest2.setInner(innerTest);
        ksession.insert((Object)outerTest2);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testCoercionOfStringValueWithoutQuotes() throws Exception {
        String str = "package org.drools.mvel.compiler.test; \ndeclare A\n   field : String\nend\nrule R when\n   A( field == 12 )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.mvel.compiler.test; \ndeclare A\n   field : String\nend\nrule R when\n   A( field == 12 )\nthen\nend\n"});
        KieSession ksession = kbase.newKieSession();
        FactType typeA = kbase.getFactType("org.drools.mvel.compiler.test", "A");
        Object a = typeA.newInstance();
        typeA.set(a, "field", (Object)"12");
        ksession.insert(a);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testPrimitiveToBoxedCoercionInMethodArgument() throws Exception {
        String str = "package org.drools.mvel.compiler.test;\nimport " + TypeCoercionTest.class.getName() + "\nimport org.drools.mvel.compiler.*\nrule R1 when\n   Person( $ag1 : age )   $p2 : Person( name == TypeCoercionTest.integer2String($ag1) )then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("42", 42);
        ksession.insert((Object)p);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
    }

    public static String integer2String(Integer value) {
        return "" + value;
    }

    @Test
    public void testStringCoercion() {
        String drl = "package org.drools.mvel.compiler.test;\nimport " + Person.class.getCanonicalName() + "\n rule R1 when\n     Person(name == \"12\")\n then end\n rule R2 when\n     Person(name == 11)\n  then\n end\n rule R3 when\n    Person(name == \"11\")\n then end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)new Person("11"));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testIntCoercion() {
        String drl = "package org.drools.mvel.compiler.test;\nimport " + Person.class.getCanonicalName() + "\n rule R1 when\n     Person(age == 12)\n then end\n rule R2 when\n     Person(age == \"11\")\n  then\n end\n rule R3 when\n    Person(age == 11)\n then end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)new Person("Mario", 11));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(2);
    }

    @Test
    public void testCoercionInJoin() {
        String drl = " rule R1 when\n     Integer($i : intValue)\n     String(this == $i)\n then end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{" rule R1 when\n     Integer($i : intValue)\n     String(this == $i)\n then end\n"});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)2);
        kieSession.insert((Object)"2");
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testCoercionInJoinOnField() {
        String drl = "import " + Person.class.getCanonicalName() + "\n rule R1 when\n     Integer($i : intValue)\n     Person(name == $i)\n then end\n";
        KieBase kieBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)2);
        kieSession.insert((Object)new Person("2", 11));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    public static class InnerBean {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class OuterBean {
        private InnerBean inner;
        private String id;

        public InnerBean getInner() {
            return this.inner;
        }

        public void setInner(InnerBean inner) {
            this.inner = inner;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

