/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.facttemplates.Fact;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.base.facttemplates.FactTemplateImpl;
import org.drools.base.facttemplates.FactTemplateObjectType;
import org.drools.base.facttemplates.FieldTemplate;
import org.drools.base.facttemplates.FieldTemplateImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.test.model.Cheese;
import org.junit.Test;

public class PatternTest {
    @Test
    public void testDeclarationsObjectType() throws Exception {
        ClassObjectType type = new ClassObjectType(Cheese.class);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        ReadAccessor ext = dec.getExtractor();
        Assertions.assertThat((Class)ext.getExtractToClass()).isEqualTo(Cheese.class);
        Cheese stilton = new Cheese("stilton", 42);
        Assertions.assertThat((Object)dec.getValue(null, (Object)stilton)).isEqualTo((Object)stilton);
    }

    @Test
    public void testDeclarationsFactTemplate() throws Exception {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateObjectType type = new FactTemplateObjectType((FactTemplate)cheese);
        Pattern col = new Pattern(0, (ObjectType)type, "foo");
        Declaration dec = col.getDeclaration();
        ReadAccessor ext = dec.getExtractor();
        Assertions.assertThat((Class)ext.getExtractToClass()).isEqualTo(Fact.class);
        Fact stilton = cheese.createFact();
        stilton.set("name", (Object)"stilton");
        stilton.set("price", (Object)200);
        Assertions.assertThat((Object)dec.getValue(null, (Object)stilton)).isEqualTo((Object)stilton);
    }
}

