/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.base.base.EnabledBoolean;
import org.drools.base.base.SalienceInteger;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.accessor.Salience;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.expr.MVELSalienceExpression;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieSessionConfiguration;

public class RuleTest {
    @Test
    public void testDateEffective() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", (KieBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration()).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateEffective(earlier);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        Assertions.assertThat((boolean)later.after(Calendar.getInstance())).isTrue();
        rule.setDateEffective(later);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
    }

    @Test
    public void testDateExpires() throws Exception {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", (KieBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration()).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateExpires(earlier);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        rule.setDateExpires(later);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
    }

    @Test
    public void testDateEffectiveExpires() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", (KieBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration()).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(past);
        rule.setDateExpires(future);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
        rule.setDateExpires(past);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
        rule.setDateExpires(future);
        rule.setDateEffective(future);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
    }

    @Test
    public void testRuleEnabled() {
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", (KieBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration()).newKieSession();
        RuleImpl rule = new RuleImpl("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        rule.setDateEffective(past);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
    }

    @Test
    public void testTimeMachine() {
        SessionConfiguration conf = (SessionConfiguration)KieServices.get().newKieSessionConfiguration().as(SessionConfiguration.KEY);
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        WorkingMemory wm = (WorkingMemory)KnowledgeBaseFactory.newKnowledgeBase((String)"x", (KieBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration()).newKieSession((KieSessionConfiguration)conf, null);
        Calendar future = Calendar.getInstance();
        ((PseudoClockScheduler)wm.getSessionClock()).setStartupTime(future.getTimeInMillis());
        RuleImpl rule = new RuleImpl("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(future);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isFalse();
        ((PseudoClockScheduler)wm.getSessionClock()).advanceTime(1000000000000L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)rule.isEffective(null, new RuleTerminalNode().getRequiredDeclarations(), (ValueResolver)wm)).isTrue();
    }

    @Test
    public void testGetSalienceValue() {
        RuleImpl rule = new RuleImpl("myrule");
        int salienceValue = 100;
        SalienceInteger salience = new SalienceInteger(100);
        rule.setSalience((Salience)salience);
        Assertions.assertThat((int)rule.getSalienceValue()).isEqualTo(100);
        Assertions.assertThat((boolean)rule.isSalienceDynamic()).isFalse();
    }

    @Test
    public void testIsSalienceDynamic() {
        RuleImpl rule = new RuleImpl("myrule");
        MVELSalienceExpression salience = new MVELSalienceExpression();
        rule.setSalience((Salience)salience);
        Assertions.assertThat((boolean)rule.isSalienceDynamic()).isTrue();
    }
}

