/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Message;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.model.StockTick;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class ConstraintsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ConstraintsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testExpressionConstraints1() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Mailbox.FolderType.class.getCanonicalName() + ";\nimport " + Mailbox.class.getCanonicalName() + ";\nrule R1\n        dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $folderType : getDefaultFolderType(),\n                FolderType.INBOX == $folderType,\n                $folderType == FolderType.INBOX,\n                $mailForFolder2 : getMailTypeForFolderType(getDefaultFolderType()),\n                FolderType.SENT != getDefaultFolderType(), \n                getDefaultFolderType() != FolderType.SENT, \n                getMailTypeForFolderType($folderType) == MailType.WORK,\n                1 > 0\n        )\n    then\nend\n";
        this.testExpressionConstraints(drl);
    }

    @Test
    public void testExpressionConstraints2() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Mailbox.FolderType.class.getCanonicalName() + ";\nimport " + Mailbox.class.getCanonicalName() + ";\nrule R1\n    dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $me : owneremail,\n                recentContacts[Mailbox.TEST_EMAIL] != null,\n                recentContacts[\"me@test.com\"] != null,\n                $d1 : recentContacts[Mailbox.TEST_EMAIL],\n                $d2 : recentContacts[\"me@test.com\"],\n                recentContacts.get(owneremail) != null,\n                recentContacts.get($me) != null,\n                recentContacts[$me] != null,\n                $d3: recentContacts.get(owneremail),\n                // Waiting for MVEL fixes for the following 2 scenarios                // recentContacts[owneremail] != null,\n                // recentContacts[getOwneremail()] != null,\n                0 < 1\n        )\n    then\nend\n";
        this.testExpressionConstraints(drl);
    }

    @Test
    public void testExpressionConstraints3() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Mailbox.FolderType.class.getCanonicalName() + ";\nimport " + Mailbox.class.getCanonicalName() + ";\nrule R1\n    dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $type1 : FolderType.INBOX,\n                $type2 : " + Mailbox.class.getCanonicalName() + ".FolderType.INBOX,\n                $work1 : getFolder(null),\n                $work2 : getFolder(" + Mailbox.class.getCanonicalName() + ".FolderType.INBOX),\n                $work3 : getFolder(FolderType.INBOX),\n                getFolder($type1) != null,\n                getFolder($type1).size() > 0,\n                ! getFolder($type1).isEmpty(),\n                $work6 : folders,\n                $work7 : folders.size,\n                //folders.containsKey(FolderType.INBOX),\n                folders.containsKey(" + Mailbox.class.getCanonicalName() + ".FolderType.INBOX),\n                folders.containsKey($type2),\n                !folders.isEmpty,\n                getFolder(FolderType.INBOX) != null,\n                //$v1 : folders[FolderType.INBOX], \n                //$v2 : folders[com.sample.Mailbox.FolderType.INBOX],\n                //$v3 : folders[com.sample.Mailbox$FolderType.INBOX],\n                //folders[$type1]!=null,\n                //folders.get(FolderType.INBOX)!=null, // sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl cannot be cast to java.lang.Class\n                //folders.isEmpty(),  // SAME ERROR\n                0 < 1\n        )\n    then\nend";
        this.testExpressionConstraints(drl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExpressionConstraints(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Mailbox mbox = new Mailbox("me@test.com");
            Message message = new Message();
            message.setMessage("Welcome");
            message.setStatus(0);
            mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
            ksession.insert((Object)mbox);
            ksession.insert((Object)message);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpressionConstraints4() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Mailbox.FolderType.class.getCanonicalName() + ";\nimport " + Mailbox.class.getCanonicalName() + ";\nrule R1\n        dialect \"mvel\"\n    when\n        Mailbox( owneremail == 'bob@mail' || owneremail == 'john@mail' )\n    then\nend\nrule R2\n        dialect \"mvel\"\n    when\n        Mailbox( ( owneremail == 'bob@mail' ) || ( owneremail == 'john@mail' ) )\n    then\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Mailbox("foo@mail"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(0);
            ksession.insert((Object)new Mailbox("john@mail"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testDeeplyNestedCompactExpressions() {
        String drl = "package org.drools\nrule R1\n when\n Person( age > 10 && ( < 20 || > 30 ) )\n then\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools\nrule R1\n when\n Person( age > 10 && ( < 20 || > 30 ) )\n then\nend\n"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintConnectors() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_ConstraintConnectors.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Person youngChili1 = new Person("young chili1");
            youngChili1.setAge(12);
            youngChili1.setHair("blue");
            Person youngChili2 = new Person("young chili2");
            youngChili2.setAge(25);
            youngChili2.setHair("purple");
            Person chili1 = new Person("chili1");
            chili1.setAge(35);
            chili1.setHair("red");
            Person chili2 = new Person("chili2");
            chili2.setAge(38);
            chili2.setHair("indigigo");
            Person oldChili1 = new Person("old chili1");
            oldChili1.setAge(45);
            oldChili1.setHair("green");
            Person oldChili2 = new Person("old chili2");
            oldChili2.setAge(48);
            oldChili2.setHair("blue");
            Person veryold = new Person("very old");
            veryold.setAge(99);
            veryold.setHair("gray");
            ksession.insert((Object)youngChili1);
            ksession.insert((Object)youngChili2);
            ksession.insert((Object)chili1);
            ksession.insert((Object)chili2);
            ksession.insert((Object)oldChili1);
            ksession.insert((Object)oldChili2);
            ksession.insert((Object)veryold);
            ksession.fireAllRules();
            Assertions.assertThat((int)results.size()).isEqualTo(4);
            Assertions.assertThat(results.get(0)).isEqualTo((Object)chili1);
            Assertions.assertThat(results.get(1)).isEqualTo((Object)oldChili1);
            Assertions.assertThat(results.get(2)).isEqualTo((Object)youngChili1);
            Assertions.assertThat(results.get(3)).isEqualTo((Object)veryold);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectorsAndOperators() {
        String drl = "package org.drools.compiler\n\nimport " + StockTick.class.getCanonicalName() + ";\n\ndeclare StockTick\n    @role( event )\n    @timestamp( dateTimestamp )\nend\n\nrule \"operator\"\n    when\n        $t1 : StockTick( company == \"RHT\" )\n        $t2 : StockTick( company == \"IBM\", this after $t1 || before $t1 )\n    then\n        // do something\nend  ";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
            ksession.insert((Object)new StockTick(2L, "IBM", 10.0, 1100L));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintExpression() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule \"test\"\nwhen\n    Person( 5*2 > 3 );\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Bob"));
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMethodConstraint() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule \"test\"\nwhen\n    Person( isAlive() );\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person person = new Person("Bob");
            person.setAlive(true);
            ksession.insert((Object)person);
            Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(1);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeepNestedConstraints() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"deep nested constraints\"\nwhen\n    Person( $likes : likes )\n    Cheese( ( ( type == \"stilton\" || type == $likes ) && ( price < 10 || price > 50 ) ) || eval( type.equals(\"brie\") ) )\nthen\n    results.add( \"OK\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            ksession.insert((Object)new Person("bob", "muzzarela"));
            ksession.insert((Object)new Cheese("brie", 10));
            ksession.insert((Object)new Cheese("muzzarela", 80));
            ksession.fireAllRules();
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("should have fired twice", new Object[0])).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRestrictionFieldConstraint() {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"org/drools/compiler/integrationtests/test_MultiRestrictionFieldConstraint.drl"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list1 = new ArrayList();
            ksession.setGlobal("list1", list1);
            ArrayList list2 = new ArrayList();
            ksession.setGlobal("list2", list2);
            ArrayList list3 = new ArrayList();
            ksession.setGlobal("list3", list3);
            ArrayList list4 = new ArrayList();
            ksession.setGlobal("list4", list4);
            Person youngChili1 = new Person("young chili1");
            youngChili1.setAge(12);
            youngChili1.setHair("blue");
            Person youngChili2 = new Person("young chili2");
            youngChili2.setAge(25);
            youngChili2.setHair("purple");
            Person chili1 = new Person("chili1");
            chili1.setAge(35);
            chili1.setHair("red");
            Person chili2 = new Person("chili2");
            chili2.setAge(38);
            chili2.setHair("indigigo");
            Person oldChili1 = new Person("old chili1");
            oldChili1.setAge(45);
            oldChili1.setHair("green");
            Person oldChili2 = new Person("old chili2");
            oldChili2.setAge(48);
            oldChili2.setHair("blue");
            ksession.insert((Object)youngChili1);
            ksession.insert((Object)youngChili2);
            ksession.insert((Object)chili1);
            ksession.insert((Object)chili2);
            ksession.insert((Object)oldChili1);
            ksession.insert((Object)oldChili2);
            ksession.fireAllRules();
            Assertions.assertThat((int)list1.size()).isEqualTo(1);
            Assertions.assertThat((boolean)list1.contains(chili1)).isTrue();
            Assertions.assertThat((int)list2.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list2.contains(chili1)).isTrue();
            Assertions.assertThat((boolean)list2.contains(chili2)).isTrue();
            Assertions.assertThat((int)list3.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list3.contains(youngChili1)).isTrue();
            Assertions.assertThat((boolean)list3.contains(youngChili2)).isTrue();
            Assertions.assertThat((int)list4.size()).isEqualTo(2);
            Assertions.assertThat((boolean)list4.contains(youngChili1)).isTrue();
            Assertions.assertThat((boolean)list4.contains(chili1)).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNonBooleanConstraint() {
        String drl = "package org.drools.compiler\nimport java.util.List\nimport " + Person.class.getCanonicalName() + ";\nrule \"test\"\nwhen\n    $p1: Person( name + name )\nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List messages = kieBuilder.getResults().getMessages();
        Assertions.assertThat((List)messages).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((org.kie.api.builder.Message)messages.iterator().next()).getText()).contains(new CharSequence[]{"Predicate 'name + name' must be a Boolean expression"})).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarargConstraint() {
        String drl = "package org.drools.compiler.test;\nimport " + VarargBean.class.getCanonicalName() + ";\n global java.util.List list;\n\nrule R1 when\n   VarargBean( isOddArgsNr(1, 2, 3) )\nthen\n   list.add(\"odd\");\nend\nrule R2 when\n   VarargBean( isOddArgsNr(1, 2, 3, 4) )\nthen\n   list.add(\"even\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"constraints-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new VarargBean());
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            Assertions.assertThat((boolean)list.contains("odd")).isTrue();
        }
        finally {
            ksession.dispose();
        }
    }

    public static class Mailbox {
        public static final String TEST_EMAIL = "me@test.com";
        private final Map<FolderType, List<Message>> folders = new HashMap<FolderType, List<Message>>();
        private final Map<String, Date> recentContacts = new HashMap<String, Date>();
        private final String owneremail;

        public Mailbox(String username) {
            this.owneremail = username;
            this.recentContacts.put(this.owneremail, new Date());
            this.folders.put(FolderType.SENT, new ArrayList());
            this.folders.put(FolderType.TRASH, new ArrayList());
            this.folders.put(FolderType.INBOX, new ArrayList());
        }

        public List<Message> getFolder(FolderType t) {
            return this.folders.get((Object)t);
        }

        public FolderType getDefaultFolderType() {
            return FolderType.INBOX;
        }

        public MailType getMailType() {
            return MailType.WORK;
        }

        public MailType getMailTypeForFolderType(FolderType pType) {
            return MailType.WORK;
        }

        public Map<FolderType, List<Message>> getFolders() {
            return this.folders;
        }

        public Map<String, Date> getRecentContacts() {
            return this.recentContacts;
        }

        public String getOwneremail() {
            return this.owneremail;
        }

        public static enum FolderType {
            INBOX,
            SENT,
            TRASH;

        }

        public static enum MailType {
            WORK,
            HOME,
            OTHER;

        }
    }

    public static class VarargBean {
        public boolean isOddArgsNr(int ... args) {
            return args.length % 2 == 1;
        }
    }
}

