/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.AbstractTupleIndexHashTableIteratorTest;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.mockito.Mockito;

public class RightTupleIndexHashTableIteratorTest
extends AbstractTupleIndexHashTableIteratorTest {
    public RightTupleIndexHashTableIteratorTest(boolean useLambdaConstraint) {
        this.useLambdaConstraint = useLambdaConstraint;
    }

    @Test
    public void test1() {
        BetaNodeFieldConstraint constraint0 = RightTupleIndexHashTableIteratorTest.createFooThisEqualsDBetaConstraint(this.useLambdaConstraint);
        BetaNodeFieldConstraint[] constraints = new BetaNodeFieldConstraint[]{constraint0};
        RuleBaseConfiguration config = (RuleBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration().as(RuleBaseConfiguration.KEY);
        SingleBetaConstraints betaConstraints = null;
        betaConstraints = new SingleBetaConstraints(constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KieSession ss = kBase.newKieSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new AbstractTupleIndexHashTableIteratorTest.Foo("snicker", 0));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh1, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh2, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh3, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh4, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh5, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh6, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh7, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh8, null));
        betaMemory.getRightTupleMemory().add((Tuple)new RightTupleImpl(fh9, null));
        TupleIndexHashTable hashTable = (TupleIndexHashTable)betaMemory.getRightTupleMemory();
        TupleList rightTupleList = new TupleList();
        rightTupleList.add((Tuple)new RightTupleImpl(fh10, null));
        hashTable.getTable()[0] = rightTupleList;
        rightTupleList = new TupleList();
        rightTupleList.add((Tuple)new RightTupleImpl(fh11, null));
        rightTupleList.add((Tuple)new RightTupleImpl(fh12, null));
        rightTupleList.add((Tuple)new RightTupleImpl(fh13, null));
        hashTable.getTable()[0].setNext(rightTupleList);
        List tableIndexList = this.createTableIndexListForAssertion(hashTable);
        Assertions.assertThat((int)tableIndexList.size()).isEqualTo(5);
        ArrayList<RightTuple> resultList = new ArrayList<RightTuple>();
        Iterator it = betaMemory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            resultList.add(rightTuple);
            rightTuple = (RightTuple)it.next();
        }
        Assertions.assertThat((int)resultList.size()).isEqualTo(13);
    }

    @Test
    public void testLastBucketInTheTable() {
        TupleList[] entries = new TupleList[10];
        entries[0] = (TupleList)Mockito.mock(TupleList.class);
        entries[5] = (TupleList)Mockito.mock(TupleList.class);
        entries[9] = (TupleList)Mockito.mock(TupleList.class);
        RightTuple[] tuples = new RightTuple[]{(RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)entries[0].getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)entries[5].getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)entries[9].getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        TupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new TupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[0]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[1]);
        Assertions.assertThat((Object)iterator.next()).isSameAs((Object)tuples[2]);
        Assertions.assertThat((Object)iterator.next()).isNull();
    }
}

