/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.lang.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.dsl.AbstractClassTypeDeclarationBuilder;
import org.drools.drl.ast.dsl.AccumulateDescrBuilder;
import org.drools.drl.ast.dsl.CEDescrBuilder;
import org.drools.drl.ast.dsl.ConditionalBranchDescrBuilder;
import org.drools.drl.ast.dsl.DescrFactory;
import org.drools.drl.ast.dsl.EnumDeclarationDescrBuilder;
import org.drools.drl.ast.dsl.FunctionDescrBuilder;
import org.drools.drl.ast.dsl.PackageDescrBuilder;
import org.drools.drl.ast.dsl.PatternDescrBuilder;
import org.drools.drl.ast.dsl.QueryDescrBuilder;
import org.drools.drl.ast.dsl.RuleDescrBuilder;
import org.drools.drl.ast.dsl.TypeDeclarationDescrBuilder;
import org.drools.io.ByteArrayResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.StockTick;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgeDescr;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class DescrBuilderTest {
    @Test
    public void testPackage() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).getDescr();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools");
        Assertions.assertThat((String)pkg.getAttribute("dialect").getValue()).isEqualTo("mvel");
        Assertions.assertThat((Object)pkg.getAttribute("salience")).isNull();
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools");
    }

    @Test
    public void testPackageAttributes() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).attribute("salience", "10")).attribute("lock-on-active", "true", AttributeDescr.Type.BOOLEAN)).getDescr();
        Assertions.assertThat((String)pkg.getName()).isEqualTo("org.drools");
        Assertions.assertThat((int)pkg.getAttributes().size()).isEqualTo(3);
        Assertions.assertThat((String)pkg.getAttribute("dialect").getValue()).isEqualTo("mvel");
        Assertions.assertThat((String)pkg.getAttribute("salience").getValue()).isEqualTo("10");
        Assertions.assertThat((String)pkg.getAttribute("lock-on-active").getValue()).isEqualTo("true");
        Assertions.assertThat((Comparable)pkg.getAttribute("lock-on-active").getType()).isEqualTo((Object)AttributeDescr.Type.BOOLEAN);
        Assertions.assertThat((Object)pkg.getAttribute("no-loop")).isNull();
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools");
    }

    @Test
    public void testPackageImports() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newImport().target("java.util.List").end()).newImport().target("org.drools.examples.*").end()).getDescr();
        Assertions.assertThat((int)pkg.getImports().size()).isEqualTo(2);
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(0)).getTarget()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((ImportDescr)pkg.getImports().get(1)).getTarget()).isEqualTo("org.drools.examples.*");
    }

    @Test
    public void testGlobals() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newGlobal().type("java.util.List").identifier("list").end()).newGlobal().type("Person").identifier("bob").end()).getDescr();
        Assertions.assertThat((int)pkg.getGlobals().size()).isEqualTo(2);
        Assertions.assertThat((String)((GlobalDescr)pkg.getGlobals().get(0)).getType()).isEqualTo("java.util.List");
        Assertions.assertThat((String)((GlobalDescr)pkg.getGlobals().get(0)).getIdentifier()).isEqualTo("list");
        Assertions.assertThat((String)((GlobalDescr)pkg.getGlobals().get(1)).getType()).isEqualTo("Person");
        Assertions.assertThat((String)((GlobalDescr)pkg.getGlobals().get(1)).getIdentifier()).isEqualTo("bob");
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
    }

    @Test
    public void testFunctions() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((PackageDescrBuilder)((FunctionDescrBuilder)((FunctionDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newFunctionImport().target("java.lang.Math.max").end()).newFunction().returnType("long").name("myMax").parameter("long", "v1")).parameter("long", "v2")).body("return max(v1, v2);").end()).newRule().name("test").lhs().eval().constraint("myMax(5, 10) == 10").end()).end()).rhs("// do something").end()).getDescr();
        Assertions.assertThat((int)pkg.getFunctionImports().size()).isEqualTo(1);
        Assertions.assertThat((int)pkg.getFunctions().size()).isEqualTo(1);
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testNamedConsequence() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("test").lhs().pattern("Cheese").constraint("type == \"stilton\"").end()).namedConsequence().name("c1").end()).pattern("Cheese").constraint("type == \"cheddar\"").end()).end()).rhs("// do something").namedRhs("c1", "// do something else").end()).getDescr();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
    }

    @Test
    public void testConditionalBranch() {
        String expected = "packageorg.drools.mvel.compiler\nrule \"test\"\nwhen\n    Cheese( type == \"stilton\" )  \n    if ( price < 10 ) do[c1] \n    Cheese( type == \"cheddar\" )  \nthen\n// do something\nthen[c1]\n// do something else\nend";
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((ConditionalBranchDescrBuilder)((ConditionalBranchDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("test").lhs().pattern("Cheese").constraint("type == \"stilton\"").end()).conditionalBranch().condition().constraint("price < 10").end()).consequence().name("c1").end()).end()).pattern("Cheese").constraint("type == \"cheddar\"").end()).end()).rhs("// do something").namedRhs("c1", "// do something else").end()).getDescr();
        Assertions.assertThat((int)pkg.getRules().size()).isEqualTo(1);
        String drl = new DrlDumper().dump(pkg);
        Assertions.assertThat((String)expected).isEqualToIgnoringWhitespace((CharSequence)drl);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
    }

    @Test
    public void testDeclare() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((AbstractClassTypeDeclarationBuilder)((AbstractClassTypeDeclarationBuilder)((EnumDeclarationDescrBuilder)((EnumDeclarationDescrBuilder)((EnumDeclarationDescrBuilder)((PackageDescrBuilder)((AbstractClassTypeDeclarationBuilder)((AbstractClassTypeDeclarationBuilder)((TypeDeclarationDescrBuilder)((TypeDeclarationDescrBuilder)DescrFactory.newPackage().name("org.beans").newDeclare().type().name("StockTick").newAnnotation("role").value((Object)"event").end()).newAnnotation("author").value((Object)"bob").end()).newField("symbol").type("String").end()).newField("price").type("double").end()).end()).newDeclare().enumerative().name("Planets").newAnnotation("kind").value((Object)"enum").end()).newEnumLiteral("earth").constructorArg("6.0").constructorArg("10.0").end()).newEnumLiteral("jupiter").constructorArg("44.0").constructorArg("50.0").end()).newField("mass").type("double").end()).newField("radius").type("double").end()).end()).getDescr();
        Assertions.assertThat((int)pkg.getTypeDeclarations().size()).isEqualTo(1);
        Assertions.assertThat((int)pkg.getEnumDeclarations().size()).isEqualTo(1);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.beans");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        FactType stType = kbase.getFactType("org.beans", "StockTick");
        Assertions.assertThat((Object)stType).isNotNull();
        Object st = stType.newInstance();
        stType.set(st, "symbol", (Object)"RHT");
        stType.set(st, "price", (Object)10);
        Assertions.assertThat((Object)stType.get(st, "symbol")).isEqualTo((Object)"RHT");
    }

    @Test
    public void testDeclareEntryPoint() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newDeclare().entryPoint().entryPointId("ep1").end()).newDeclare().entryPoint().entryPointId("ep3").end()).getDescr();
        Assertions.assertThat((int)pkg.getEntryPointDeclarations().size()).isEqualTo(2);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        Assertions.assertThat((int)kbase.getEntryPointIds().size()).isEqualTo(2);
    }

    @Test
    public void testRuleRHSOptional() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("r1").lhs().pattern("StockTick").constraint("company == \"RHT\"").end()).end()).end()).getDescr();
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testRuleRHSComment() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("r1").lhs().pattern("StockTick").constraint("company == \"RHT\"").end()).end()).rhs("// some comment").end()).getDescr();
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testTopLevelAccumulate() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((AccumulateDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("r1").lhs().accumulate().source().pattern("StockTick").constraint("company == \"RHT\"").bind("$p", "price", false).end()).end()).function("sum", "$sum", false, new String[]{"$p"}).function("count", "$cnt", false, new String[]{"$p"}).end()).end()).rhs("// some comment").end()).getDescr();
        KiePackage kpkg = this.compilePkgDescr(pkg, "org.drools.mvel.compiler");
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        ksession.insert((Object)new StockTick(2L, "RHT", 100.0, 10L));
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        Assertions.assertThat((int)((Number)((AfterMatchFiredEvent)cap.getValue()).getMatch().getDeclarationValue("$sum")).intValue()).isEqualTo(180);
        Assertions.assertThat((int)((Number)((AfterMatchFiredEvent)cap.getValue()).getMatch().getDeclarationValue("$cnt")).intValue()).isEqualTo(2);
    }

    @Test
    public void testRule() throws InstantiationException, IllegalAccessException {
        PackageDescrBuilder packBuilder = (PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools.mvel.compiler").newRule().name("r1").lhs().and().or().pattern("StockTick").constraint("price > 100").end()).pattern("StockTick").constraint("price < 10").end()).end()).pattern("StockTick").constraint("company == \"RHT\"").end()).end()).end()).rhs("    System.out.println(\"foo\");\n").end();
        PackageDescr pkg = (PackageDescr)packBuilder.getDescr();
        String drl = new DrlDumper().dump((PackageDescr)packBuilder.getDescr());
        System.out.println(drl);
        KiePackage kpkg = this.compilePkgDescr(pkg);
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools.mvel.compiler");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new StockTick(1L, "RHT", 80.0, 1L));
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(0);
        ksession = kbase.newKieSession();
        ksession.insert((Object)new StockTick(2L, "RHT", 150.0, 1L));
        rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testFromEntryPoint() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("from rule").lhs().pattern("String").id("s", false).from().entryPoint("EventStream").end()).end()).rhs("//System.out.println(s);").end()).getDescr();
        KiePackage kpkg = this.compilePkgDescr(pkg, "org.drools");
        Assertions.assertThat((String)kpkg.getName()).isEqualTo("org.drools");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(Collections.singletonList(kpkg));
        KieSession ksession = kbase.newKieSession();
        EntryPoint ep = ksession.getEntryPoint("EventStream");
        ep.insert((Object)"Hello World!");
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testDumperFromPkg() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.test").newRule().name("org.test").lhs().and().or().pattern().id("$x", false).type("Integer").constraint("this > 10").end()).pattern().id("$x", false).type("Integer").constraint("this < 20").end()).end()).pattern().type("Integer").constraint("this == $x").constraint("this == 42").end()).end()).end()).rhs("").end()).end().getDescr();
        String drl = new DrlDumper().dump(pkg);
        System.out.println(drl);
        KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        System.err.println(knowledgeBuilder.getErrors());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)knowledgeBuilder.hasErrors()).as(knowledgeBuilder.getErrors().toString(), new Object[0])).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(knowledgeBuilder.getKnowledgePackages());
        KieSession knowledgeSession = kbase.newKieSession();
        InternalKnowledgePackage rebuiltPkg = knowledgeBuilder.getPackage("org.test");
        Rule rule = (Rule)rebuiltPkg.getRules().iterator().next();
        RuleImpl r = (RuleImpl)rule;
        Assertions.assertThat((int)r.getLhs().getChildren().size()).isEqualTo(2);
        Iterator iter = r.getLhs().getChildren().iterator();
        RuleConditionElement arg1 = (RuleConditionElement)iter.next();
        Assertions.assertThat((arg1 instanceof GroupElement && ((GroupElement)arg1).getType() == GroupElement.Type.OR ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)((GroupElement)arg1).getChildren().size()).isEqualTo(2);
        RuleConditionElement arg2 = (RuleConditionElement)iter.next();
        Assertions.assertThat((boolean)(arg2 instanceof Pattern)).isTrue();
    }

    @Test
    public void testAccumulate() throws InstantiationException, IllegalAccessException {
        PackageDescrBuilder packBuilder = (PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((AccumulateDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((RuleDescrBuilder)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((AccumulateDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().newGlobal().identifier("list").type(List.class.getName()).end()).name("org.drools.mvel.compiler").newRule().name("r1").lhs().pattern().id("$tot", true).type(Double.class.getName()).end()).accumulate().source().pattern().id("$i", false).type(Integer.class.getName()).end()).end()).function("sum", "$tot", true, new String[]{"$i"}).constraint("$tot > 15").end()).end()).rhs("list.add( $tot );").end()).newRule().name("r2").attribute("dialect", "mvel")).lhs().pattern().id("$tot", true).type(Double.class.getName()).end()).accumulate().source().pattern().id("$i", false).type(Integer.class.getName()).end()).end()).function("sum", "$tot", true, new String[]{"$i"}).constraint("$tot > 15").end()).end()).rhs("list.add( $tot * 2 );").end();
        String drl = new DrlDumper().dump((PackageDescr)packBuilder.getDescr());
        System.out.println(drl);
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        System.err.println(knowledgeBuilder.getErrors());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)knowledgeBuilder.hasErrors()).as(knowledgeBuilder.getErrors().toString(), new Object[0])).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(knowledgeBuilder.getKnowledgePackages());
        KieSession knowledgeSession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.insert((Object)3);
        knowledgeSession.insert((Object)39);
        knowledgeSession.insert((Object)24.0);
        knowledgeSession.insert((Object)42.0);
        knowledgeSession.fireAllRules();
        Assertions.assertThat(list).isEqualTo(Arrays.asList(42.0, 84.0));
    }

    @Test
    public void testDumperPositional() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)DescrFactory.newPackage().name("org.test").newRule().name("org.test").lhs().pattern().type("Integer").constraint("this > 10", true).constraint("this > 11", true).constraint("this > 12", false).constraint("this > 13", false).end()).end()).rhs("").end()).end().getDescr();
        String drl = new DrlDumper().dump(pkg);
        Assertions.assertThat((boolean)drl.contains("Integer( this > 10, this > 11; this > 12, this > 13 )")).isTrue();
    }

    @Test
    public void testDumperDuration() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((RuleDescrBuilder)DescrFactory.newPackage().name("org.test").newRule().name("org.test").attribute("duration").value("int: 0 3600000; repeat-limit = 6").end()).lhs().end()).rhs("").end()).end().getDescr();
        String drl = new DrlDumper().dump(pkg);
        Assertions.assertThat((boolean)drl.contains("duration (int: 0 3600000; repeat-limit = 6)")).isTrue();
    }

    @Test
    public void testDumperTimer() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((RuleDescrBuilder)DescrFactory.newPackage().name("org.test").newRule().name("org.test").attribute("timer").value("cron:0/5 * * * * ?").end()).lhs().end()).rhs("").end()).end().getDescr();
        String drl = new DrlDumper().dump(pkg);
        Assertions.assertThat((boolean)drl.contains("timer (cron:0/5 * * * * ?)")).isTrue();
    }

    private KiePackage compilePkgDescr(PackageDescr pkg) {
        return this.compilePkgDescr(pkg, null);
    }

    private KiePackage compilePkgDescr(PackageDescr pkg, String pkgName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newDescrResource((KnowledgeDescr)pkg), ResourceType.DESCR);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)kbuilder.hasErrors()).as(kbuilder.getErrors().toString(), new Object[0])).isFalse();
        if (pkgName == null) {
            Collection kpkgs = kbuilder.getKnowledgePackages();
            Assertions.assertThat((int)kpkgs.size()).isEqualTo(1);
            return (KiePackage)kpkgs.iterator().next();
        }
        return ((KnowledgeBuilderImpl)kbuilder).getPackage(pkgName);
    }

    @Test
    public void testBehaviorForSlidingWindow() throws InstantiationException, IllegalAccessException {
        LinkedList<String> myParams = new LinkedList<String>();
        myParams.add("5s");
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((CEDescrBuilder)((PatternDescrBuilder)DescrFactory.newPackage().name("org.drools").newRule().name("from rule").lhs().not().pattern().type("StockTick").constraint("price > 10").behavior().type("window", "time").parameters(myParams).end()).end()).end()).end()).rhs("//System.out.println(s);").end()).getDescr();
        String drl = new DrlDumper().dump(pkg);
        Assertions.assertThat((boolean)drl.contains("window:time(5s)")).isTrue();
    }

    @Test
    public void testQueryParameters() {
        PackageDescrBuilder packBuilder = ((PackageDescrBuilder)((QueryDescrBuilder)((CEDescrBuilder)((QueryDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.test.rules").newImport().target("org.test.event.TemporalEvent").end()).newQuery().name("getTemporalEventById").parameter("String", "eventId")).lhs().pattern("TemporalEvent").constraint("id == eventId").from().entryPoint("EventStream").end()).end()).end()).end();
        String drl = new DrlDumper().dump((PackageDescr)packBuilder.getDescr());
        Assertions.assertThat((boolean)drl.contains("query \"getTemporalEventById\" ( String eventId ) ")).isTrue();
    }
}

