/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect;

import java.util.Collection;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;

@RunWith(value=Parameterized.class)
public class JavaAndMVELCombinedTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String FN1 = "mveljavarules.drl";
    private static final String FN2 = "mvelonly.drl";
    private static final String FN3 = "javaonly.drl";

    public JavaAndMVELCombinedTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testMixed() {
        this.timing(FN1, "mveljava: ");
    }

    @Test
    public void testMVEL() {
        this.timing(FN2, "    mvel: ");
    }

    @Test
    public void testJAVA() {
        this.timing(FN3, "    java: ");
    }

    private void timing(String name, String msg) {
        long start = System.currentTimeMillis();
        this.readDRL(name);
        long time = System.currentTimeMillis() - start;
        System.out.println(msg + (double)time / 1000.0);
    }

    private void readDRL(String fn) {
        try {
            KieBase kieBase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{fn});
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

