/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AsmGeneratorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AsmGeneratorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testPatterDeclarations() {
        String s = "package org.kie.test\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    s2 : String( this == 's2' )\n    s3 : String( this == 's3' )\n    s4 : String( this == 's4' )\n    s5 : String( this == 's5' )\nthen\n    // s5 is missed out on purpose to make sure we only resolved required declarations\n   list.add( s1 + s2 + s3 + s5 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)"s2");
        ksession.insert((Object)"s3");
        ksession.insert((Object)"s4");
        ksession.insert((Object)"s5");
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"s1s2s3s5");
    }

    @Test
    public void testAllGeneratedConstructs() {
        String s = "package org.kie.test\nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    p1 : Person( $name1 : name, name == s1 )\n    eval( p1.getName().equals( s1 ) ) \n    s2 : String( this == 's2' )\n    p2 : Person( $name2 : name, name == s2, eval( p2.getName().equals( s2 ) &&                                                   ! $name2.equals( $name1 )  ) )\n    s3 : String( this == 's3' )\n    not String( this == 's5')\n     p3 : Person( $name3 : name, name == s3, name == ( new String( $name1.charAt(0) + \"3\" ) ) )\nthen\n    // *2 are missed out on purpose to make sure we only resolved required declarations\n    list.add( s1 + p1 + $name1 + s3 + p3 + $name3 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)new Person("s1"));
        ksession.insert((Object)"s2");
        ksession.insert((Object)new Person("s2"));
        ksession.insert((Object)"s3");
        ksession.insert((Object)new Person("s3"));
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"s1[Person name='s1 age='0' likes='']s1s3[Person name='s3 age='0' likes='']s3");
    }

    @Test
    public void testOr() {
        String s = "package org.kie.test\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nglobal java.util.List list\nrule r1 when\n    s1 : String( this == 's1' )\n    Cheese( $type : type == \"stilton\", $price : price ) or\n    ( Cheese( $type : type == \"brie\", $price : price ) and Person( name == \"bob\", likes == $type ) )\nthen\n    // *2 are missed out on purpose to make sure we only resolved required declarations\n    list.add( \"test3\"+$type +\":\"+ new Integer( $price ) ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{s});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"s1");
        ksession.insert((Object)new Person("bob", "brie"));
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)new Cheese("brie"));
        ksession.insert((Object)new Person("s2"));
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("test3brie:0")).isTrue();
        Assertions.assertThat((boolean)list.contains("test3stilton:0")).isTrue();
    }
}

