/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.builder.KieBuilder;
import org.kie.api.command.Command;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;

@RunWith(value=Parameterized.class)
public class DynamicRulesChangesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static KieBaseTestConfiguration staticKieBaseTestConfiguration;
    private static final int PARALLEL_THREADS = 1;
    private static InternalKnowledgeBase kbase;
    private ExecutorService executor;
    private static Map<String, String> rules;

    public DynamicRulesChangesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Before
    public void setUp() throws Exception {
        staticKieBaseTestConfiguration = this.kieBaseTestConfiguration;
        this.executor = Executors.newFixedThreadPool(1);
        kbase = KnowledgeBaseFactory.newKnowledgeBase();
        DynamicRulesChangesTest.addRule("raiseAlarm");
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    @Test(timeout=10000L)
    public void testConcurrentRuleAdditions() throws Exception {
        this.parallelExecute(RulesExecutor.getSolvers());
    }

    @Test(timeout=10000L)
    public void testBatchRuleAdditions() throws Exception {
        this.parallelExecute(BatchRulesExecutor.getSolvers());
    }

    private void parallelExecute(Collection<Callable<List<String>>> solvers) throws Exception {
        ExecutorCompletionService<List<String>> ecs = new ExecutorCompletionService<List<String>>(this.executor);
        for (Callable<List<String>> s : solvers) {
            ecs.submit(s);
        }
        for (int i = 0; i < 1; ++i) {
            List events = (List)ecs.take().get();
            Assertions.assertThat((int)events.size()).isEqualTo(5);
        }
    }

    public static void addRule(String ruleName) throws Exception {
        DynamicRulesChangesTest.addRule(ruleName, null);
    }

    public static void addRule(String ruleName, Rule firingRule) throws Exception {
        String rule = rules.get(ruleName);
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)staticKieBaseTestConfiguration, (boolean)true, (String[])new String[]{rule});
        Collection pkgs = KieBaseUtil.getDefaultKieBaseFromKieBuilder((KieBuilder)kieBuilder).getKiePackages();
        kbase.addPackages(pkgs);
        if (firingRule != null) {
            kbase.removeRule("defaultpkg", firingRule.getName());
        }
    }

    static {
        rules = new HashMap<String, String>(){
            {
                this.put("raiseAlarm", "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"Raise the alarm when we have one or more fires\"\nwhen\n    exists DynamicRulesChangesTest.Fire()\nthen\n    insert( new DynamicRulesChangesTest.Alarm() );\n    events.add( \"Raise the alarm\" );\n    DynamicRulesChangesTest.addRule(\"onFire\", drools.getRule());\nend");
                this.put("onFire", "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"When there is a fire turn on the sprinkler\"\nwhen\n    $fire: DynamicRulesChangesTest.Fire($room : room)\n    $sprinkler : DynamicRulesChangesTest.Sprinkler( room == $room, on == false )\nthen\n    modify( $sprinkler ) { setOn( true ) };\n    events.add( \"Turn on the sprinkler for room \" + $room.getName() );\n    DynamicRulesChangesTest.addRule(\"fireGone\", drools.getRule());\nend");
                this.put("fireGone", "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"When the fire is gone turn off the sprinkler\"\nwhen\n    $room : DynamicRulesChangesTest.Room( )\n    $sprinkler : DynamicRulesChangesTest.Sprinkler( room == $room, on == true )\n    not DynamicRulesChangesTest.Fire( room == $room )\nthen\n    modify( $sprinkler ) { setOn( false ) };\n    events.add( \"Turn off the sprinkler for room \" + $room.getName() );\n    DynamicRulesChangesTest.addRule(\"cancelAlarm\", drools.getRule());\nend");
                this.put("cancelAlarm", "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"Cancel the alarm when all the fires have gone\"\nwhen\n    not DynamicRulesChangesTest.Fire()\n    $alarm : DynamicRulesChangesTest.ParentAlarm()\nthen\n    retract( $alarm );\n    events.add( \"Cancel the alarm\" );\n    DynamicRulesChangesTest.addRule(\"status\", drools.getRule());\nend");
                this.put("status", "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"Status output when things are ok\"\nwhen\n    not DynamicRulesChangesTest.Alarm()\n    not DynamicRulesChangesTest.Sprinkler( on == true )\nthen\n    events.add( \"Everything is ok\" );\nend");
            }
        };
    }

    public static class RulesExecutor
    implements Callable<List<String>> {
        @Override
        public List<String> call() throws Exception {
            ArrayList<String> events = new ArrayList<String>();
            try {
                KieSession ksession = kbase.newKieSession();
                ksession.setGlobal("events", events);
                Room room1 = new Room("Room 1");
                ksession.insert((Object)room1);
                FactHandle fireFact1 = ksession.insert((Object)new Fire(room1));
                ksession.fireAllRules();
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                Sprinkler sprinkler1 = new Sprinkler(room1);
                ksession.insert((Object)sprinkler1);
                ksession.fireAllRules();
                Assertions.assertThat((int)events.size()).isEqualTo(2);
                ksession.retract(fireFact1);
                ksession.fireAllRules();
            }
            catch (Exception e) {
                System.err.println("Exception in thread " + Thread.currentThread().getName() + ": " + e.getLocalizedMessage());
                throw e;
            }
            return events;
        }

        public static Collection<Callable<List<String>>> getSolvers() {
            ArrayList<Callable<List<String>>> solvers = new ArrayList<Callable<List<String>>>();
            for (int i = 0; i < 1; ++i) {
                solvers.add(new RulesExecutor());
            }
            return solvers;
        }
    }

    public static class BatchRulesExecutor
    implements Callable<List<String>> {
        @Override
        public List<String> call() throws Exception {
            ArrayList<String> events = new ArrayList<String>();
            try {
                KieSession ksession = kbase.newKieSession();
                ksession.setGlobal("events", events);
                Room room1 = new Room("Room 1");
                Fire fire1 = new Fire(room1);
                ArrayList<Command> cmds = new ArrayList<Command>();
                cmds.add(CommandFactory.newInsert((Object)room1, (String)"room1"));
                cmds.add(CommandFactory.newInsert((Object)fire1, (String)"fire1"));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
                Assertions.assertThat((int)events.size()).isEqualTo(1);
                cmds = new ArrayList();
                cmds.add(CommandFactory.newInsert((Object)new Sprinkler(room1), (String)"sprinkler1"));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
                Assertions.assertThat((int)events.size()).isEqualTo(2);
                cmds = new ArrayList();
                cmds.add(CommandFactory.newDelete((FactHandle)ksession.getFactHandle((Object)fire1)));
                cmds.add(CommandFactory.newFireAllRules());
                ksession.execute((Command)CommandFactory.newBatchExecution(cmds));
            }
            catch (Exception e) {
                System.err.println("Exception in thread " + Thread.currentThread().getName() + ": " + e.getLocalizedMessage());
                throw e;
            }
            return events;
        }

        public static Collection<Callable<List<String>>> getSolvers() {
            ArrayList<Callable<List<String>>> solvers = new ArrayList<Callable<List<String>>>();
            for (int i = 0; i < 1; ++i) {
                solvers.add(new BatchRulesExecutor());
            }
            return solvers;
        }
    }

    public static class Sprinkler {
        private Room room;
        private boolean on = false;

        public Sprinkler() {
        }

        public Sprinkler(Room room) {
            this.room = room;
        }

        public Room getRoom() {
            return this.room;
        }

        public void setRoom(Room room) {
            this.room = room;
        }

        public boolean isOn() {
            return this.on;
        }

        public void setOn(boolean on) {
            this.on = on;
        }

        public int hashCode() {
            return this.room.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Sprinkler)) {
                return false;
            }
            return this.room.equals(((Sprinkler)obj).getRoom());
        }

        public String toString() {
            return "Sprinkler for " + this.room;
        }
    }

    public static class Room {
        private String name;

        public Room() {
        }

        public Room(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Room)) {
                return false;
            }
            return this.name.equals(((Room)obj).getName());
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Fire {
        private Room room;

        public Fire() {
        }

        public Fire(Room room) {
            this.room = room;
        }

        public Room getRoom() {
            return this.room;
        }

        public void setRoom(Room room) {
            this.room = room;
        }
    }

    public static class Alarm
    extends ParentAlarm {
    }

    public static class ParentAlarm {
    }
}

