/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class NullCheckOnExistentialNodeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NullCheckOnExistentialNodeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private void check(String drl, int fire1, int fire2) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        A a1 = new A();
        A a2 = new A();
        FactHandle fhA1 = kieSession.insert((Object)a1);
        FactHandle fhA2 = kieSession.insert((Object)a2);
        kieSession.insert((Object)"xxx");
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(fire1);
        a1.setB(null);
        kieSession.update(fhA1, (Object)a1);
        a2.setB(new B(null));
        kieSession.update(fhA2, (Object)a2);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(fire2);
    }

    @Test
    public void testNot() {
        String drl = "import " + A.class.getCanonicalName() + ";\nimport " + B.class.getCanonicalName() + ";\nrule R when\n    $s : String()\n    not A(b != null,\n          b.value != null,\n          $s == b.value)\n  then\nend";
        this.check(drl, 0, 1);
    }

    @Test
    public void testExists() {
        String drl = "import " + A.class.getCanonicalName() + ";\nimport " + B.class.getCanonicalName() + ";\nrule R when\n    $s : String()\n    exists A(b != null,\n             b.value != null,\n             $s == b.value)\n  then\nend";
        this.check(drl, 1, 0);
    }

    @Test
    public void testNotIndexable() {
        String drl = "import " + NullCheckOnExistentialNodeTest.class.getCanonicalName() + ";\nimport " + A.class.getCanonicalName() + ";\nimport " + B.class.getCanonicalName() + ";\nrule R when\n    $s : String()\n    not A(b != null,\n          b.value != null,\n          NullCheckOnExistentialNodeTest.myPredicate(b.value, $s))\n  then\nend";
        this.check(drl, 0, 1);
    }

    public static boolean myPredicate(String s1, String s2) {
        return s1 != null && s1.equals(s2);
    }

    public static class A {
        private B b = new B("xxx");

        public B getB() {
            return this.b;
        }

        public void setB(B b) {
            this.b = b;
        }
    }

    public static class B {
        private final String value;

        public B(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

