/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.util.debug.DebugList;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.ParallelExecutionOption;

@RunWith(value=Parameterized.class)
public class ParallelEvaluationTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ParallelEvaluationTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    private String getRule(int i, String rhs) {
        return this.getRule(i, rhs, "");
    }

    private String getRule(int i, String rhs, String attributes) {
        return "rule R" + i + " " + attributes + " when\n    $i : Integer( intValue == " + i + " )    String( toString == $i.toString )\nthen\n    list.add($i);\n" + rhs + "end\n";
    }

    private String getNotRule(int i) {
        return "rule Rnot" + i + " when\n    String( toString == \"" + i + "\" )\n    not Integer( intValue == " + i + " )then\n    list.add(" + -i + ");\nend\n";
    }

    @Test
    public void testSalience() {
        int ruleNr = 20;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i2 = 0; i2 < ruleNr; ++i2) {
            sb.append(this.getRule(i2, "", "salience " + i2));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ParallelExecutionOption.PARALLEL_EVALUATION});
        KieSession ksession = kbase.newKieSession();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i3 = 0; i3 < ruleNr; ++i3) {
            ksession.insert((Object)i3);
            ksession.insert((Object)("" + i3));
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(ruleNr);
        List expected = Stream.iterate(ruleNr - 1, i -> i - 1).limit(ruleNr).collect(Collectors.toList());
        Assertions.assertThat(list).isEqualTo(expected);
    }

    @Test
    public void testSalienceWithInserts() {
        int ruleNr = 20;
        StringBuilder sb = new StringBuilder(400);
        sb.append("global java.util.List list;\n");
        for (int i2 = 0; i2 < ruleNr; ++i2) {
            String rhs = i2 % 2 == 0 ? "insert(" + (i2 + 1) + ");\n" : "";
            sb.append(this.getRule(i2, rhs, "salience " + i2));
        }
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{sb.toString()});
        KieBase kbase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ParallelExecutionOption.PARALLEL_EVALUATION});
        KieSession ksession = kbase.newKieSession();
        DebugList list = new DebugList();
        ksession.setGlobal("list", list);
        for (int i3 = 0; i3 < ruleNr; ++i3) {
            ksession.insert((Object)("" + i3));
            if (i3 % 2 != 0) continue;
            ksession.insert((Object)i3);
        }
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(ruleNr);
        List expected = Stream.iterate(ruleNr - 1, i -> i - 1).limit(ruleNr).filter(i -> i % 2 == 0).flatMap(i -> Arrays.asList(i, i + 1).stream()).collect(Collectors.toList());
        Assertions.assertThat(list).isEqualTo(expected);
    }
}

