/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.RuleBase;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.reteoo.PropertySpecificUtil;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.drools.util.bitmask.AllSetBitMask;
import org.drools.util.bitmask.EmptyBitMask;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class PropertySpecificTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public PropertySpecificTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    public static List<String> getSettableProperties(InternalWorkingMemory workingMemory, ObjectTypeNode objectTypeNode) {
        return PropertySpecificTest.getSettableProperties(workingMemory.getKnowledgeBase(), objectTypeNode);
    }

    public static List<String> getSettableProperties(InternalRuleBase kBase, ObjectTypeNode objectTypeNode) {
        return PropertySpecificUtil.getAccessibleProperties((RuleBase)kBase, PropertySpecificTest.getNodeClass(objectTypeNode));
    }

    public static Class<?> getNodeClass(ObjectTypeNode objectTypeNode) {
        ObjectType objectType = objectTypeNode.getObjectType();
        return objectType instanceof ClassObjectType ? ((ClassObjectType)objectType).getClassType() : null;
    }

    @Test
    public void testRTNodeEmptyLHS() {
        String rule = "package org.drools.mvel.integrationtests\nrule r1\nwhen\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "InitialFactImpl");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testRTNodeNoConstraintsNoPropertySpecific() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nrule r1\nwhen\n   Person()\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Person");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testRTNodeWithConstraintsNoPropertySpecific() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nrule r1\nwhen\n   Person( name == 'bobba')\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Person");
        Assertions.assertThat((Object)otn).isNotNull();
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testBetaNodeNoConstraintsNoPropertySpecific() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule r1\nwhen\n   Person()\n   Cheese()\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Cheese");
        Assertions.assertThat((Object)otn).isNotNull();
        BetaNode betaNode = (BetaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testBetaNodeWithConstraintsNoPropertySpecific() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule r1\nwhen\n   Person()\n   Cheese( type == 'brie' )\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Cheese");
        Assertions.assertThat((Object)otn).isNotNull();
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        BetaNode betaNode = (BetaNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testInitialFactBetaNodeWithRightInputAdapter() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule r1\nwhen\n   exists(eval(1==1))\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "InitialFactImpl");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNode = (BetaNode)liaNode.getSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testPersonFactBetaNodeWithRightInputAdapter() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule r1\nwhen\n   Person()\n   exists(eval(1==1))\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Person");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNode = (BetaNode)liaNode.getSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void testSharedAlphanodeWithBetaNodeConstraintsNoPropertySpecific() {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Person.class.getCanonicalName() + "\nimport " + Cheese.class.getCanonicalName() + "\nrule r1\nwhen\n   Person()\n   Cheese( type == 'brie', price == 1.5 )\nthen\nend\nrule r2\nwhen\n   Person()\n   Cheese( type == 'brie', price == 2.5 )\nthen\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "Cheese");
        Assertions.assertThat((Object)otn).isNotNull();
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        BetaNode betaNode2 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    private KieBase getKnowledgeBase(String ... rules) {
        Object rule = "package org.drools.mvel.integrationtests\nglobal java.util.List list;\ndeclare A\n    @propertyReactive\n    a : int\n    b : int\n    c : int\n    s : String\n    i : int\n    j : int\n    k : int\nend\ndeclare B\n    @propertyReactive\n    a : int\n    b : int\n    c : int\n    s : String\n    i : int\n    j : int\n    k : int\nend\ndeclare C\n    @propertyReactive\nend\ndeclare D\n    @propertyReactive\nend\n";
        int i = 0;
        for (String str : rules) {
            rule = (String)rule + "rule r" + i++ + "\nwhen\n" + str + "then\nend\n";
        }
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        return kbase;
    }

    @Test
    public void testRtnNoConstraintsNoWatches() {
        String rule1 = "A()";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)EmptyBitMask.get());
    }

    @Test
    public void testRtnNoConstraintsWithWatches() {
        String rule1 = "A() @watch(a)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otn.getObjectSinkPropagator().getSinks()[0];
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
    }

    @Test
    public void testRtnWithConstraintsNoWatches() {
        String rule1 = "A( a == 10 )";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
    }

    @Test
    public void testRtnWithConstraintsWithWatches() {
        String rule1 = "A( a == 10 ) @watch(b)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode = (RuleTerminalNode)liaNode.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)rtNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
    }

    @Test
    public void testRtnSharedAlphaNoWatches() {
        String rule1 = "A( a == 10, b == 15 )";
        String rule2 = "A( a == 10, i == 20 )";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "i"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        LeftInputAdapterNode liaNode1 = (LeftInputAdapterNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode1 = (RuleTerminalNode)liaNode1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode1.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i"), sp));
        LeftInputAdapterNode liaNode2 = (LeftInputAdapterNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode2 = (RuleTerminalNode)liaNode2.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode2.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i"), sp));
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i"), sp));
        Assertions.assertThat((Object)rtNode2.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i"), sp));
        kbase = this.getKnowledgeBase(rule1, rule2);
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        otn = this.getObjectTypeNode(kbase, "A");
        alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        liaNode1 = (LeftInputAdapterNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        rtNode1 = (RuleTerminalNode)liaNode1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode1.getDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)rtNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
    }

    @Test
    public void testRtnSharedAlphaWithWatches() {
        String rule1 = "A( a == 10, b == 15 ) @watch(c, !a)";
        String rule2 = "A( a == 10, i == 20 ) @watch(s, !i)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c", "s", "i"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        LeftInputAdapterNode liaNode1 = (LeftInputAdapterNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode1 = (RuleTerminalNode)liaNode1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)rtNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)rtNode1.getNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        LeftInputAdapterNode liaNode2 = (LeftInputAdapterNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        RuleTerminalNode rtNode2 = (RuleTerminalNode)liaNode2.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)rtNode2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s"), sp));
        Assertions.assertThat((Object)rtNode2.getNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!i"), sp));
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        Assertions.assertThat((Object)rtNode2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)rtNode2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s"), sp));
        Assertions.assertThat((Object)rtNode2.getNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!i"), sp));
        kbase = this.getKnowledgeBase(rule1, rule2);
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        otn = this.getObjectTypeNode(kbase, "A");
        alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        liaNode1 = (LeftInputAdapterNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        rtNode1 = (RuleTerminalNode)liaNode1.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)rtNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)rtNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)rtNode1.getNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
    }

    @Test
    public void testBetaNoConstraintsNoWatches() {
        String rule1 = "B() A()";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        BetaNode betaNode = (BetaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)EmptyBitMask.get());
    }

    @Test
    public void testBetaNoConstraintsWithWatches() {
        String rule1 = "B() @watch(a) A() @watch(a)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        BetaNode betaNode = (BetaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
    }

    @Test
    public void testBetaWithConstraintsNoWatches() {
        String rule1 = "$b : B(a == 15) A( a == 10, b == $b.b )";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        BetaNode betaNode = (BetaNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        otn = this.getObjectTypeNode(kbase, "B");
        alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
    }

    @Test
    public void testBetaWithConstraintsWithWatches() {
        String rule1 = "$b : B( a == 15) @watch(c) A( a == 10, b == $b.b ) @watch(s)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "s"), sp));
        BetaNode betaNode = (BetaNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "s"), sp));
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "s"), sp));
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        otn = this.getObjectTypeNode(kbase, "B");
        alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
    }

    @Test
    public void testBetaWithConstraintsWithNegativeWatches() {
        String rule1 = "$b : B( a == 15) @watch(c, !a) A( a == 10, b == $b.b ) @watch(s, !a, !b)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "s"), sp));
        BetaNode betaNode = (BetaNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "s"), sp));
        Assertions.assertThat((Object)betaNode.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)betaNode.getRightNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a", "!b"), sp));
        otn = this.getObjectTypeNode(kbase, "B");
        alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
    }

    @Test
    public void testBetaSharedAlphaNoWatches() {
        String rule1 = "$b : B( a == 15) @watch(c, !a) A( a == 10, s == 15, b == $b.b  )";
        String rule2 = "$b : B( a == 15) @watch(j, !i) A( a == 10, i == 20, b == $b.b  )";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "s", "i"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s", "b"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s", "b"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b"), sp));
        BetaNode betaNode2 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!i"), sp));
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b"), sp));
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        kbase = this.getKnowledgeBase(rule1, rule2);
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        otn = this.getObjectTypeNode(kbase, "A");
        alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s", "b"), sp));
        alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s", "b"), sp));
        betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "s", "b"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!i"), sp));
    }

    @Test
    public void testBetaSharedAlphaWithWatches() {
        String rule1 = "$b : B( a == 15) @watch(c, !a) A( a == 10, b == 15, b == $b.b  ) @watch(c, !b)";
        String rule2 = "$b : B( a == 15) @watch(j) A( a == 10, i == 20, b == $b.b ) @watch(s, !a)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c", "s", "i"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!b"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "s"), sp));
        BetaNode betaNode2 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i", "b", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftNegativeMask()).isEqualTo((Object)EmptyBitMask.get());
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "s"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i", "b", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftNegativeMask()).isEqualTo((Object)EmptyBitMask.get());
        kbase = this.getKnowledgeBase(rule1, rule2);
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        otn = this.getObjectTypeNode(kbase, "A");
        alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!b"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftNegativeMask()).isEqualTo((Object)PropertySpecificUtil.calculateNegativeMask((ObjectType)otn.getObjectType(), this.list("!a"), sp));
    }

    @Test
    public void testComplexBetaSharedAlphaWithWatches() {
        String rule1 = "$b : B( b == 15) @watch(i) A( a == 10, b == 15 ) @watch(c)";
        String rule2 = "$b : B( b == 15) @watch(j) A( a == 10, i == 20 ) @watch(s)";
        String rule3 = "$b : B( c == 15) @watch(k) A( a == 10, i == 20, b == 10 ) @watch(j)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2, rule3);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c", "s", "i", "j"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "i"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "i", "s", "j"), sp));
        BetaNode betaNode2 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        AlphaNode alphaNode1_4 = (AlphaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_4.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_4.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "i", "j"), sp));
        BetaNode betaNode3 = (BetaNode)alphaNode1_4.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode3.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode3.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode3.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("k"), sp));
        Assertions.assertThat((Object)betaNode3.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c", "k"), sp));
    }

    @Test
    public void testComplexBetaSharedAlphaWithWatchesRemoveR1() {
        String rule1 = "$b : B( b == 15) @watch(i) A( a == 10, b == 15 ) @watch(c)";
        String rule2 = "$b : B( b == 15) @watch(j) A( a == 10, i == 20 ) @watch(s)";
        String rule3 = "$b : B( c == 15) @watch(k) A( a == 10, i == 20, b == 10 ) @watch(j)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2, rule3);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "s", "j"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "s", "j"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "i", "j"), sp));
        BetaNode betaNode3 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode3.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode3.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode3.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("k"), sp));
        Assertions.assertThat((Object)betaNode3.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c", "k"), sp));
    }

    @Test
    public void testComplexBetaSharedAlphaWithWatchesRemoveR2() {
        String rule1 = "$b : B( b == 15) @watch(i) A( a == 10, b == 15 ) @watch(c)";
        String rule2 = "$b : B( b == 15) @watch(j) A( a == 10, i == 20 ) @watch(s)";
        String rule3 = "$b : B( c == 15) @watch(k) A( a == 10, i == 20, b == 10 ) @watch(j)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2, rule3);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c", "i", "j"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "i"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "j"), sp));
        AlphaNode alphaNode1_3 = (AlphaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_3.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_3.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "j"), sp));
        BetaNode betaNode2 = (BetaNode)alphaNode1_3.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "b", "j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("k"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c", "k"), sp));
    }

    @Test
    public void testComplexBetaSharedAlphaWithWatchesRemoveR3() {
        String rule1 = "$b : B( b == 15) @watch(i) A( a == 10, b == 15 ) @watch(c)";
        String rule2 = "$b : B( b == 15) @watch(j) A( a == 10, i == 20 ) @watch(s)";
        String rule3 = "$b : B( c == 15) @watch(k) A( a == 10, i == 20, b == 10 ) @watch(j)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2, rule3);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        kbase.removeRule("org.drools.mvel.integrationtests", "r2");
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "A");
        Assertions.assertThat((Object)otn).isNotNull();
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c", "i", "s"), sp));
        AlphaNode alphaNode1_1 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode1_1.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)alphaNode1_1.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        BetaNode betaNode1 = (BetaNode)alphaNode1_1.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNode1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)betaNode1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "i"), sp));
        AlphaNode alphaNode1_2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)alphaNode1_2.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)alphaNode1_2.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        BetaNode betaNode2 = (BetaNode)alphaNode1_2.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNode2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("s"), sp));
        Assertions.assertThat((Object)betaNode2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "i", "s"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNode2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b", "j"), sp));
    }

    @Test
    public void testPropertySpecificSimplified() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertyReactive\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( ! s, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "on", (Object)false);
        factTypeB.set(factB, "s", (Object)"x");
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
        Assertions.assertThat((Object)factTypeB.get(factB, "on")).isEqualTo((Object)true);
        Assertions.assertThat((Object)factTypeB.get(factB, "s")).isEqualTo((Object)"y");
        ksession.dispose();
    }

    @Test
    public void testWatchNothing() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertyReactive\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !* )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "on", (Object)false);
        factTypeB.set(factB, "s", (Object)"x");
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
        Assertions.assertThat((Object)factTypeB.get(factB, "on")).isEqualTo((Object)true);
        Assertions.assertThat((Object)factTypeB.get(factB, "s")).isEqualTo((Object)"y");
        ksession.dispose();
    }

    @Test
    public void testWrongPropertyNameInWatchAnnotation() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertyReactive\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !s1, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{rule});
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    @Test
    public void testDuplicatePropertyNamesInWatchAnnotation() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    @propertyReactive\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( s, !s )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{rule});
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    @Test
    public void testWrongUasgeOfWatchAnnotationOnNonPropertySpecificClass() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndialect \"mvel\"\ndeclare A\n    s : String\nend\ndeclare B\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $b : B(s != $s) @watch( !s, on )\nthen\n    modify($b) { setS($s) }\nend\nrule R2\nwhen\n    $b : B(on == false)\nthen\n    modify($b) { setOn(true) }\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (boolean)false, (String[])new String[]{rule});
        Assertions.assertThat((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})).isTrue();
    }

    @Test
    public void testPropertySpecificJavaBean() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + C.class.getCanonicalName() + "\ndeclare A\n    s : String\nend\nrule R1\nwhen\n    A($s : s)\n    $c : C(s != $s)\nthen\n    modify($c) { setS($s) }\nend\nrule R2\nwhen\n    $c : C(on == false)\nthen\n    modify($c) { turnOn() }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "s", (Object)"y");
        ksession.insert(factA);
        C c = new C();
        c.setOn(false);
        c.setS("x");
        ksession.insert((Object)c);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
        Assertions.assertThat((boolean)c.isOn()).isEqualTo(true);
        Assertions.assertThat((String)c.getS()).isEqualTo("y");
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testPropertySpecificOnAlphaNode() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + C.class.getCanonicalName() + "\nrule R1\nwhen\n    $c : C(s == \"test\")\nthen\n    modify($c) { setOn(true) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        C c = new C();
        c.setOn(false);
        c.setS("test");
        ksession.insert((Object)c);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat((boolean)c.isOn()).isEqualTo(true);
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testPropertySpecificWithUpdate() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + C.class.getCanonicalName() + "\nrule R1\nwhen\n    $c : C(s == \"test\")\nthen\n   $c.setOn(true);\n   update($c);\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        C c = new C();
        c.setOn(false);
        c.setS("test");
        ksession.insert((Object)c);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat((boolean)c.isOn()).isEqualTo(true);
        ksession.dispose();
    }

    @Test
    public void testInfiniteLoop() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + C.class.getCanonicalName() + "\nglobal java.util.concurrent.atomic.AtomicInteger counter\nrule R1\nwhen\n    $c : C(s == \"test\") @watch( on )\nthen\n    modify($c) { turnOn() }\n    if (counter.incrementAndGet() > 10) throw new RuntimeException();\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        C c = new C();
        c.setOn(false);
        c.setS("test");
        ksession.insert((Object)c);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ksession.fireAllRules()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    @Test
    public void testClassReactive() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nglobal java.util.concurrent.atomic.AtomicInteger counter\ndeclare B\n    @classReactive\n    on : boolean\n    s : String\nend\nrule R1\nwhen\n    $b : B(s == \"test\")\nthen\n    modify($b) { setOn(true) }\n    if (counter.incrementAndGet() > 10) throw new RuntimeException();\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALWAYS");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "s", (Object)"test");
        factTypeB.set(factB, "on", (Object)false);
        ksession.insert(factB);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ksession.fireAllRules()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    @Test(timeout=5000L)
    public void testSharedWatchAnnotation() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndeclare A\n    @propertyReactive\n    a : int\n    b : int\n    s : String\n    i : int\nend\ndeclare B\n    @propertyReactive\n    s : String\n    i : int\nend\nrule R1\nwhen\n    $a : A(a == 0) @watch( i )\n    $b : B(i == $a.i) @watch( s )\nthen\n    modify($a) { setS(\"end\") }\nend\nrule R2\nwhen\n    $a : A(a == 0) @watch( b )\nthen\n    modify($a) { setI(1) }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "a", (Object)0);
        factTypeA.set(factA, "b", (Object)0);
        factTypeA.set(factA, "i", (Object)0);
        factTypeA.set(factA, "s", (Object)"start");
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "i", (Object)1);
        factTypeB.set(factB, "s", (Object)"start");
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
        Assertions.assertThat((Object)factTypeA.get(factA, "s")).isEqualTo((Object)"end");
    }

    @Test
    public void testBetaNodePropagation() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Hero.class.getCanonicalName() + "\nimport " + MoveCommand.class.getCanonicalName() + "\nrule \"Move\" when\n   $mc : MoveCommand( move == 1 )   $h  : Hero( canMove == true )then\n   modify( $h ) { setPosition($h.getPosition() + 1) };\n   retract ( $mc );\n   System.out.println( \"Move: \" + $h + \" : \" + $mc );end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        Hero hero = new Hero();
        hero.setPosition(0);
        hero.setCanMove(true);
        ksession.insert((Object)hero);
        ksession.fireAllRules();
        MoveCommand moveCommand = new MoveCommand();
        moveCommand.setMove(1);
        ksession.insert((Object)moveCommand);
        ksession.fireAllRules();
        moveCommand = new MoveCommand();
        moveCommand.setMove(1);
        ksession.insert((Object)moveCommand);
        ksession.fireAllRules();
        Assertions.assertThat((int)hero.getPosition()).isEqualTo(2);
    }

    @Test(timeout=5000L)
    public void testPropSpecOnPatternWithThis() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndeclare A\n    @propertyReactive\n    i : int\nend\ndeclare B\n    @propertyReactive\n    a : A\nend\nrule R1\nwhen\n    $b : B();\n    $a : A(this == $b.a);\nthen\n    modify($b) { setA(null) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "i", (Object)1);
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        factTypeB.set(factB, "a", factA);
        ksession.insert(factB);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testPropSpecOnBetaNode() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndeclare A\n    @propertyReactive\n    i : int\nend\ndeclare B\n    @propertyReactive\n    i : int\n    j : int\nend\nrule R1\nwhen\n    $a : A()\n    $b : B($i : i < 4, j < 2, j == $a.i)\nthen\n    modify($b) { setI($i+1) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType typeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        FactType typeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object a1 = typeA.newInstance();
        typeA.set(a1, "i", (Object)1);
        ksession.insert(a1);
        Object a2 = typeA.newInstance();
        typeA.set(a2, "i", (Object)2);
        ksession.insert(a2);
        Object b1 = typeB.newInstance();
        typeB.set(b1, "i", (Object)1);
        typeB.set(b1, "j", (Object)1);
        ksession.insert(b1);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(3);
    }

    @Test(timeout=5000L)
    public void testConfig() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\ndeclare A\n    i : int\n    j : int\nend\nrule R1\nwhen\n    $a : A(i == 1)\nthen\n    modify($a) { setJ(2) };\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALWAYS");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        FactType typeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object a = typeA.newInstance();
        typeA.set(a, "i", (Object)1);
        ksession.insert(a);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test
    public void testEmptyBetaConstraint() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Hero.class.getCanonicalName() + "\nimport " + Cell.class.getCanonicalName() + "\nimport " + Init.class.getCanonicalName() + "\nimport " + CompositeImageName.class.getCanonicalName() + "\ndeclare CompositeImageName\n   @propertyReactive\nend\nrule \"Show First Cell\" when\n   Init()\n   $c : Cell( row == 0, col == 0 )\nthen\n   modify( $c ) { hidden = false };\nend\n\nrule \"Paint Empty Hero\" when\n   $c : Cell()\n   $cin : CompositeImageName( cell == $c )\n   not Hero( row == $c.row, col == $c.col  )\nthen\n   modify( $cin ) { hero = \"\" };\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Init());
        Cell cell = new Cell();
        cell.setRow(0);
        cell.setCol(0);
        cell.hidden = true;
        ksession.insert((Object)cell);
        Hero hero = new Hero();
        hero.setRow(1);
        hero.setCol(1);
        ksession.insert((Object)hero);
        CompositeImageName cin = new CompositeImageName();
        cin.setHero("hero");
        cin.setCell(cell);
        ksession.insert((Object)cin);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
    }

    @Test(timeout=5000L)
    public void testNoConstraint() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Cell.class.getCanonicalName() + "\nrule R1 when\n   $c : Cell()\nthen\n   modify( $c ) { hidden = true };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cell());
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
    }

    @Test(timeout=5000L)
    public void testNodeSharing() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Cell.class.getCanonicalName() + "\nrule R1 when\n   $c : Cell()\nthen\n   modify( $c ) { hidden = true };\n   System.out.println( \"R1\");\nend\nrule R2 when\n   $c : Cell(hidden == true)\nthen\n   System.out.println( \"R2\");\nend\nrule R3 when\n   $c : Cell(hidden == true, row == 0)\nthen\n   modify( $c ) { setCol(1) };\n   System.out.println( \"R3\");\nend\nrule R4 when\n   $c : Cell(hidden == true, col == 1)\nthen\n   modify( $c ) { setRow(1) };\n   System.out.println( \"R4\");\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Cell());
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(4);
    }

    <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    public ObjectTypeNode getObjectTypeNode(KieBase kbase, String nodeName) {
        List nodes = ((InternalRuleBase)kbase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (!((ClassObjectType)n.getObjectType()).getClassType().getSimpleName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    @Test(timeout=5000L)
    public void testNoConstraint2() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Order.class.getCanonicalName() + "\nimport " + OrderItem.class.getCanonicalName() + "\nrule R1 when\n   $o : Order()\n   $i : OrderItem( orderId == $o.id, quantity > 2 )\nthen\n   modify( $o ) { setDiscounted( true ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        Order order1 = new Order("1");
        OrderItem orderItem11 = new OrderItem("1", 1, 1.1);
        OrderItem orderItem12 = new OrderItem("1", 2, 1.2);
        OrderItem orderItem13 = new OrderItem("1", 3, 1.3);
        order1.setItems(this.list(orderItem11, orderItem12, orderItem13));
        ksession.insert((Object)order1);
        ksession.insert((Object)orderItem11);
        ksession.insert((Object)orderItem12);
        ksession.insert((Object)orderItem13);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat((boolean)order1.isDiscounted()).isTrue();
    }

    @Test(timeout=5000L)
    public void testFrom() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Order.class.getCanonicalName() + "\nimport " + OrderItem.class.getCanonicalName() + "\nrule R1 when\n   $o : Order()\n   $i : OrderItem( $price : price, quantity > 1 ) from $o.items\nthen\n   modify( $o ) { setDiscounted( true ) };\n   modify( $i ) { setPrice( $price - 0.1 ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        Order order1 = new Order("1");
        OrderItem orderItem11 = new OrderItem("1", 1, 1.1);
        OrderItem orderItem12 = new OrderItem("1", 2, 1.2);
        OrderItem orderItem13 = new OrderItem("1", 3, 1.3);
        order1.setItems(this.list(orderItem11, orderItem12, orderItem13));
        ksession.insert((Object)order1);
        ksession.insert((Object)orderItem11);
        ksession.insert((Object)orderItem12);
        ksession.insert((Object)orderItem13);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(2);
        Assertions.assertThat((double)orderItem11.getPrice()).isCloseTo(1.1, Assertions.within((Double)0.005));
        Assertions.assertThat((double)orderItem12.getPrice()).isCloseTo(1.1, Assertions.within((Double)0.005));
        Assertions.assertThat((double)orderItem13.getPrice()).isCloseTo(1.2, Assertions.within((Double)0.005));
        Assertions.assertThat((boolean)order1.isDiscounted()).isTrue();
    }

    @Test(timeout=5000L)
    public void testAccumulate() throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nimport " + Order.class.getCanonicalName() + "\nimport " + OrderItem.class.getCanonicalName() + "\nrule R1 when\n   $o : Order()\n   $i : Number( doubleValue > 5 ) from accumulate( OrderItem( orderId == $o.id, $value : value ),\n                                                   sum( $value ) )\nthen\n   modify( $o ) { setDiscounted( true ) };\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        Order order1 = new Order("1");
        OrderItem orderItem11 = new OrderItem("1", 1, 1.1);
        OrderItem orderItem12 = new OrderItem("1", 2, 1.2);
        OrderItem orderItem13 = new OrderItem("1", 3, 1.3);
        order1.setItems(this.list(orderItem11, orderItem12, orderItem13));
        ksession.insert((Object)order1);
        ksession.insert((Object)orderItem11);
        ksession.insert((Object)orderItem12);
        ksession.insert((Object)orderItem13);
        int rules = ksession.fireAllRules();
        Assertions.assertThat((int)rules).isEqualTo(1);
        Assertions.assertThat((boolean)order1.isDiscounted()).isTrue();
    }

    @Test
    public void testBetaWithWatchAfterBeta() {
        String rule1 = "$b : B(a == 15) @watch(k) C() A(i == $b.j) @watch(b, c)";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otnA = this.getObjectTypeNode(kbase, "A");
        ObjectTypeNode otnC = this.getObjectTypeNode(kbase, "C");
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otnA);
        BetaNode betaNodeA = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeA.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("i", "b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("i", "b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeA.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        BetaNode betaNodeC = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeC.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnC.getObjectType(), this.list("j", "k"), sp));
        Assertions.assertThat((Object)betaNodeC.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnC.getObjectType(), this.list("a", "j", "k"), sp));
    }

    @Test
    public void testBetaAfterBetaWithWatch() {
        String rule1 = "$b : B(a == 15) @watch(k) A(i == $b.j) @watch(b, c) C()";
        KieBase kbase = this.getKnowledgeBase(rule1);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otnA = this.getObjectTypeNode(kbase, "A");
        ObjectTypeNode otnC = this.getObjectTypeNode(kbase, "C");
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otnA);
        BetaNode betaNodeA = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeA.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("i", "b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("i", "b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("j", "k"), sp));
        Assertions.assertThat((Object)betaNodeA.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("a", "j", "k"), sp));
        BetaNode betaNodeC = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeC.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
    }

    @Test
    public void test2DifferentAlphaWatchBeforeSameBeta() {
        String rule1 = "B(a == 15) @watch(b) C()";
        String rule2 = "B(a == 15) @watch(c) C()";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otn = this.getObjectTypeNode(kbase, "B");
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otn);
        AlphaNode alphaNode = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b", "c"), sp));
        ObjectTypeNode otnC = this.getObjectTypeNode(kbase, "C");
        BetaNode betaNodeC1 = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNodeC2 = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[1];
        LeftInputAdapterNode lia1 = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)lia1.getSinkPropagator().getSinks()[0]).isSameAs((Object)betaNodeC1);
        LeftInputAdapterNode lia2 = (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)lia2.getSinkPropagator().getSinks()[0]).isSameAs((Object)betaNodeC2);
        Assertions.assertThat((Object)betaNodeC1.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC1.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNodeC1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "b"), sp));
        Assertions.assertThat((Object)betaNodeC2.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC2.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNodeC2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "c"), sp));
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "c"), sp));
        Assertions.assertThat((int)lia2.getSinkPropagator().getSinks().length).isEqualTo(1);
        BetaNode betaNodeC = (BetaNode)lia2.getSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeC2.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC2.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNodeC2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otn.getObjectType(), this.list("a", "c"), sp));
    }

    @Test
    public void testSameBetasWith2RTNSinks() {
        String rule1 = "B(a == 15) C() A()";
        String rule2 = "B(a == 15) C() A() @watch(b, c)";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otnA = this.getObjectTypeNode(kbase, "A");
        ObjectTypeNode otnC = this.getObjectTypeNode(kbase, "C");
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otnA);
        BetaNode betaNodeC = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNodeA1 = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNodeA2 = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNodeA1).isSameAs((Object)betaNodeC.getSinkPropagator().getSinks()[0]);
        Assertions.assertThat((Object)betaNodeA2).isSameAs((Object)betaNodeC.getSinkPropagator().getSinks()[1]);
        Assertions.assertThat((Object)betaNodeC).isSameAs((Object)betaNodeA1.getLeftTupleSource());
        Assertions.assertThat((Object)betaNodeC).isSameAs((Object)betaNodeA2.getLeftTupleSource());
        Assertions.assertThat((Object)betaNodeC.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnA.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)betaNodeA1.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeA1.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeA1.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeA1.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeA2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnC.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnC.getObjectType(), this.list("b", "c"), sp));
        Assertions.assertThat((Object)betaNodeA2.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeA2.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        kbase.removeRule("org.drools.mvel.integrationtests", "r0");
        Assertions.assertThat((int)betaNodeC.getSinkPropagator().getSinks().length).isEqualTo(1);
    }

    @Test
    public void testBetaWith2BetaSinks() {
        String rule1 = "B(a == 15) @watch(b) A() @watch(i) C()";
        String rule2 = "B(a == 15) @watch(c) A() @watch(j) D()";
        KieBase kbase = this.getKnowledgeBase(rule1, rule2);
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        ObjectTypeNode otnB = this.getObjectTypeNode(kbase, "B");
        List<String> sp = PropertySpecificTest.getSettableProperties(wm, otnB);
        AlphaNode alphaNode = (AlphaNode)otnB.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a", "b", "c"), sp));
        ObjectTypeNode otnA = this.getObjectTypeNode(kbase, "A");
        BetaNode betaNodeA1 = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[0];
        BetaNode betaNodeA2 = (BetaNode)otnA.getObjectSinkPropagator().getSinks()[1];
        Assertions.assertThat((Object)betaNodeA1.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)betaNodeA1.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("i"), sp));
        Assertions.assertThat((Object)betaNodeA1.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("b"), sp));
        Assertions.assertThat((Object)betaNodeA1.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a", "b"), sp));
        Assertions.assertThat((Object)betaNodeA2.getRightDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNodeA2.getRightInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("j"), sp));
        Assertions.assertThat((Object)betaNodeA2.getLeftDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("c"), sp));
        Assertions.assertThat((Object)betaNodeA2.getLeftInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a", "c"), sp));
        ObjectTypeNode otnC = this.getObjectTypeNode(kbase, "C");
        BetaNode betaNodeC = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeC.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeC.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        ObjectTypeNode otnD = this.getObjectTypeNode(kbase, "D");
        BetaNode betaNodeD = (BetaNode)otnC.getObjectSinkPropagator().getSinks()[0];
        Assertions.assertThat((Object)betaNodeD.getRightDeclaredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeD.getRightInferredMask()).isEqualTo((Object)EmptyBitMask.get());
        Assertions.assertThat((Object)betaNodeD.getLeftDeclaredMask()).isEqualTo((Object)AllSetBitMask.get());
        Assertions.assertThat((Object)betaNodeD.getLeftInferredMask()).isEqualTo((Object)AllSetBitMask.get());
        kbase.removeRule("org.drools.mvel.integrationtests", "r1");
        Assertions.assertThat((Object)alphaNode.getDeclaredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a"), sp));
        Assertions.assertThat((Object)alphaNode.getInferredMask()).isEqualTo((Object)PropertySpecificUtil.calculatePositiveMask((ObjectType)otnB.getObjectType(), this.list("a", "b"), sp));
    }

    @Test(timeout=5000L)
    public void testBetaWith2RTNSinksExecNoLoop() throws Exception {
        this.testBetaWith2RTNSinksExec(false);
    }

    @Test
    public void testBetaWith2RTNSinksExecInfiniteLoop() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testBetaWith2RTNSinksExec(true)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBetaWith2RTNSinksExec(boolean addInfiniteLoopWatch) throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nglobal java.util.concurrent.atomic.AtomicInteger counter\ndeclare A\n   @propertyReactive\n   x : int\nend\ndeclare B\n   @propertyReactive\nend\ndeclare C\n   @propertyReactive\n   y : int\nend\nrule R1 when\n   A ( x == 1 )\n   B ( )\n" + (addInfiniteLoopWatch ? "   $c : C ( ) @watch(y)\n" : "   $c : C ( )\n") + "then    modify( $c ) { setY( 2 ) };\n   if (counter.incrementAndGet() > 10) throw new RuntimeException();\nend;\nrule R2 when\n   A ( x == 1 )\n   B ( )\n   C ( ) @watch(y)\nthen end;\nrule InitA when\n   $a : A ( x == 0 )\nthen\n   modify( $a ) { setX( 1 ) };\nend;\t\nrule InitC salience 1 when\n   $c : C ( y == 0 )\nthen\n   modify( $c ) { setY( 1 ) };\nend;\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "x", (Object)0);
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        ksession.insert(factB);
        FactType factTypeC = kbase.getFactType("org.drools.mvel.integrationtests", "C");
        Object factC = factTypeC.newInstance();
        factTypeC.set(factC, "y", (Object)0);
        ksession.insert(factC);
        try {
            ksession.fireAllRules();
        }
        finally {
            Assertions.assertThat((Object)factTypeC.get(factC, "y")).isEqualTo((Object)2);
            ksession.dispose();
        }
    }

    @Test(timeout=5000L)
    public void testBetaWith2BetaSinksExecNoLoop() throws Exception {
        this.testBetaWith2BetaSinksExec(false);
    }

    @Test
    public void testBetaWith2BetaSinksExecInfiniteLoop() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testBetaWith2BetaSinksExec(true)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Exception executing consequence for rule \"R1\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBetaWith2BetaSinksExec(boolean addInfiniteLoopWatch) throws Exception {
        String rule = "package org.drools.mvel.integrationtests\nglobal java.util.concurrent.atomic.AtomicInteger counter\ndeclare A\n   @propertyReactive\n   x : int\nend\ndeclare B\n   @propertyReactive\nend\ndeclare C\n   @propertyReactive\n   y : int\nend\ndeclare D\n   @propertyReactive\nend\nrule R1 when\n   A ( x == 1 )\n" + (addInfiniteLoopWatch ? "   $c : C ( ) @watch(y)\n" : "   $c : C ( )\n") + "   B ( )\nthen    modify( $c ) { setY( 2 ) };\n   if (counter.incrementAndGet() > 10) throw new RuntimeException();\nend;\nrule R2 when\n   A ( x == 1 )\n   C ( ) @watch(y)\n   D ( )\nthen end;\nrule InitA when\n   $a : A ( x == 0 )\nthen\n   modify( $a ) { setX( 1 ) };\nend;\t\nrule InitC salience 1 when\n   $c : C ( y == 0 )\nthen\n   modify( $c ) { setY( 1 ) };\nend;\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        AtomicInteger counter = new AtomicInteger(0);
        ksession.setGlobal("counter", (Object)counter);
        FactType factTypeA = kbase.getFactType("org.drools.mvel.integrationtests", "A");
        Object factA = factTypeA.newInstance();
        factTypeA.set(factA, "x", (Object)0);
        ksession.insert(factA);
        FactType factTypeB = kbase.getFactType("org.drools.mvel.integrationtests", "B");
        Object factB = factTypeB.newInstance();
        ksession.insert(factB);
        FactType factTypeC = kbase.getFactType("org.drools.mvel.integrationtests", "C");
        Object factC = factTypeC.newInstance();
        factTypeC.set(factC, "y", (Object)0);
        ksession.insert(factC);
        FactType factTypeD = kbase.getFactType("org.drools.mvel.integrationtests", "D");
        Object factD = factTypeD.newInstance();
        ksession.insert(factD);
        try {
            ksession.fireAllRules();
        }
        finally {
            Assertions.assertThat((Object)factTypeC.get(factC, "y")).isEqualTo((Object)2);
            ksession.dispose();
        }
    }

    @Test(timeout=5000L)
    public void testTypeDeclarationInitializationForPropertyReactive() {
        String rule = "package org.drools.mvel.integrationtests\nimport java.util.Map;\nimport java.util.EnumMap;\nimport " + DataSample.class.getCanonicalName() + ";\nimport " + Model.class.getCanonicalName() + ";\nimport " + Parameter.class.getCanonicalName() + ";\n\nrule 'Init'\nwhen\n    $m: Model()\nthen\n    insert(new DataSample($m));\nend\n\nrule \"Rule 1\"\nwhen\n    $m: Model()\n    $d: DataSample(model == $m)\nthen\n    modify($d){\n        addValue(Parameter.PARAM_A, 10.0)\n    }\nend\n\nrule \"Rule 2\"\nwhen\n    $m: Model()\n    $d: DataSample(model == $m, $v: values[Parameter.PARAM_A] > 9.0)\nthen\n    modify($d){\n        addMessage(\"Hello\")\n    }\nend\n\nrule \"Data without messages\"\nsalience -100\nwhen\n    $m: Model()\n    $d: DataSample(model == $m, messaged == false)\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Model());
        int fired = ksession.fireAllRules(10);
        Assertions.assertThat((int)fired).isEqualTo(3);
    }

    @Test
    public void testRemovedPendingActivation() {
        String rule = "declare Person\n@propertyReactive\n   name   : String\n   age    : int\n   weight : int\nend\n\nrule kickoff\nsalience 100\nwhen\nthen\n    Person p = new Person( \"Joe\", 20, 20 );\n    insert( p );\nend\n\nrule y\nwhen\n    $p : Person(name == \"Joe\" )\nthen\n    modify($p){\n       setAge( 100 )\n    }\nend\n\nrule x\nwhen\n    $p : Person(name == \"Joe\" )\nthen\n    modify($p){\n        setWeight( 100 )\n    }\nend\n\nrule z\nsalience -100\nwhen\n    $p : Person()\nthen\n    System.out.println( $p );\n    if ($p.getAge() != 100 || $p.getWeight() != 100) throw new RuntimeException();\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule});
        KieSession ksession = kbase.newKieSession();
        int fired = ksession.fireAllRules();
        Assertions.assertThat((int)fired).isEqualTo(4);
    }

    @Test
    public void testAccLong() {
        String rule = "package com.sample.rules\nimport " + LongFact.class.getCanonicalName() + "\nrule R when\n        accumulate( LongFact( $longVal: longVal), $minVal : min($longVal))\n        accumulate( LongFact( $longVal2: longVal, $longVal2 > $minVal), $minVal2 : min($longVal2))\n\n        $minFact: LongFact( longVal == $minVal)\n        $minFact2: LongFact( longVal == $minVal2)\n\nthen\n    Long $difference = (Long)$minVal2 - (Long)$minVal;\n    $minFact2.setLongDiff($difference);\n    update($minFact2);\n    retract($minFact);\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        KieSession kSession = kbase.newKieSession();
        int NUM = 5;
        for (int i = 0; i < 5; ++i) {
            LongFact fact = new LongFact(100 + i * i * 10);
            kSession.insert((Object)fact);
        }
        int cnt = kSession.fireAllRules();
        Assertions.assertThat((int)cnt).isEqualTo(4);
    }

    @Test
    public void testAccBigDecimal() {
        String rule = "package com.sample.rules\nimport java.math.BigDecimal;\nimport " + BigDecimalFact.class.getCanonicalName() + "\nrule R when\n        accumulate( BigDecimalFact( $bdVal: bdVal), $minVal : min($bdVal))\n        accumulate( BigDecimalFact( $bdVal2: bdVal, $bdVal2 > $minVal), $minVal2 : min($bdVal2); $minVal2 != null)\n\n        \n        $minFact: BigDecimalFact( bdVal == new BigDecimal($minVal.intValue()))\n        $minFact2: BigDecimalFact( bdVal == new BigDecimal($minVal2.intValue()))\n\nthen\n    BigDecimal $difference = new BigDecimal($minVal2.intValue() - $minVal.intValue());\n    $minFact2.setBdDiff($difference);\n    update($minFact2);\n    retract($minFact);\nend\n";
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.propertySpecific", "ALLOWED");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (String[])new String[]{rule});
        KieSession kSession = kbase.newKieSession();
        int NUM = 5;
        for (int i = 0; i < 5; ++i) {
            BigDecimalFact fact = new BigDecimalFact(100 + i * i * 10);
            kSession.insert((Object)fact);
        }
        int cnt = kSession.fireAllRules();
        Assertions.assertThat((int)cnt).isEqualTo(4);
    }

    @PropertyReactive
    public static class C {
        private boolean on;
        private String s;

        public boolean isOn() {
            return this.on;
        }

        public void setOn(boolean on) {
            this.on = on;
        }

        @Modifies(value={"on"})
        public void turnOn() {
            this.setOn(true);
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }

    @PropertyReactive
    public static class Hero {
        private boolean canMove;
        private int position;
        private int col;
        private int row;

        public boolean isCanMove() {
            return this.canMove;
        }

        public void setCanMove(boolean canMove) {
            this.canMove = canMove;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public String toString() {
            return "Hero{position=" + this.position + "}";
        }
    }

    @PropertyReactive
    public static class MoveCommand {
        private int move;

        public int getMove() {
            return this.move;
        }

        public void setMove(int move) {
            this.move = move;
        }

        public String toString() {
            return "MoveCommand{move=" + this.move + "}";
        }
    }

    @PropertyReactive
    public static class Cell {
        private int col;
        private int row;
        public boolean hidden;

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }

    @PropertyReactive
    public static class Init {
    }

    public static class CompositeImageName {
        private Cell cell;
        public String hero;

        public Cell getCell() {
            return this.cell;
        }

        public void setCell(Cell cell) {
            this.cell = cell;
        }

        public String getHero() {
            return this.hero;
        }

        public void setHero(String hero) {
            this.hero = hero;
        }
    }

    @PropertyReactive
    public static class Order {
        private String id;
        private List<OrderItem> items;
        private boolean discounted;

        public Order(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public List<OrderItem> getItems() {
            return this.items;
        }

        public void setItems(List<OrderItem> items) {
            this.items = items;
        }

        public boolean isDiscounted() {
            return this.discounted;
        }

        public void setDiscounted(boolean discounted) {
            this.discounted = discounted;
        }
    }

    @PropertyReactive
    public static class OrderItem {
        private String orderId;
        private int quantity;
        private double price;

        public OrderItem(String orderId, int quantity, double price) {
            this.orderId = orderId;
            this.quantity = quantity;
            this.price = price;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public double getPrice() {
            return this.price;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public double getValue() {
            return this.price * (double)this.quantity;
        }
    }

    @PropertyReactive
    public static class DataSample {
        private Model model;
        private Map<Parameter, Double> values = new EnumMap<Parameter, Double>(Parameter.class);
        private List<String> messages = new ArrayList<String>();

        public DataSample() {
        }

        public DataSample(Model model) {
            this.model = model;
        }

        public Model getModel() {
            return this.model;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public Map<Parameter, Double> getValues() {
            return this.values;
        }

        public void setValues(Map<Parameter, Double> values) {
            this.values = values;
        }

        @Modifies(value={"values"})
        public void addValue(Parameter p, double value) {
            this.values.put(p, value);
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        @Modifies(value={"messages", "messaged"})
        public void addMessage(String message) {
            this.messages.add(message);
        }

        public boolean isMessaged() {
            return !this.messages.isEmpty();
        }

        public void setMessaged(boolean b) {
        }
    }

    public static class Model {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum Parameter {
        PARAM_A,
        PARAM_B;

    }

    public static class LongFact {
        private Long longVal;
        private Long longDiff;

        public LongFact(int i) {
            this.longVal = new Long(i);
        }

        public Long getLongDiff() {
            return this.longDiff;
        }

        public Long getLongVal() {
            return this.longVal;
        }

        public void setLongDiff(Long longDiff) {
            this.longDiff = longDiff;
        }

        public void setLongVal(Long longVal) {
            this.longVal = longVal;
        }
    }

    public static class BigDecimalFact {
        private BigDecimal bdVal;
        private BigDecimal bdDiff;

        public BigDecimalFact(int i) {
            this.bdVal = new BigDecimal(i);
        }

        public BigDecimal getBdDiff() {
            return this.bdDiff;
        }

        public BigDecimal getBdVal() {
            return this.bdVal;
        }

        public void setBdDiff(BigDecimal bdDiff) {
            this.bdDiff = bdDiff;
        }

        public void setBdVal(BigDecimal bdVal) {
            this.bdVal = bdVal;
        }
    }
}

