/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.rule;

import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.GroupElementFactory;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.core.test.model.Person;
import org.junit.Test;

public class GroupElementTest {
    @Test
    public void testPackNestedAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern1 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern2);
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isSameAs((Object)pattern2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)and1);
        and2.pack();
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isSameAs((Object)pattern2);
    }

    @Test
    public void testDeclarationOrdering() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern1 = new Pattern(0, (ObjectType)new ClassObjectType(Person.class), "x");
        and1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(2, (ObjectType)new ClassObjectType(Person.class), "y");
        and1.addChild((RuleConditionElement)pattern2);
        Declaration x1 = (Declaration)and1.getInnerDeclarations().get("x");
        Declaration y1 = (Declaration)and1.getInnerDeclarations().get("y");
        Declaration z1 = (Declaration)and1.getInnerDeclarations().get("z");
        Assertions.assertThat((Object)x1).isNotNull();
        Assertions.assertThat((Object)y1).isNotNull();
        Assertions.assertThat((Object)z1).isNull();
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(1))).isSameAs((Object)pattern2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)and1);
        Pattern pattern3 = new Pattern(3, (ObjectType)new ClassObjectType(Person.class), "x");
        and2.addChild((RuleConditionElement)pattern3);
        and2.pack();
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(3);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isSameAs((Object)pattern2);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(2))).isSameAs((Object)pattern3);
        Declaration x2 = (Declaration)and2.getInnerDeclarations().get("x");
        Declaration y2 = (Declaration)and2.getInnerDeclarations().get("y");
        Declaration z2 = (Declaration)and2.getInnerDeclarations().get("z");
        Assertions.assertThat((Object)x2).isNotNull();
        Assertions.assertThat((Object)y2).isNotNull();
        Assertions.assertThat((Object)z2).isNull();
        Assertions.assertThat((Object)x2).isNotSameAs((Object)x1);
        Assertions.assertThat((Object)pattern3.getDeclaration()).isSameAs((Object)x2);
        Assertions.assertThat((Object)y2).isSameAs((Object)y1);
        Assertions.assertThat((Object)z2).isSameAs((Object)z1);
    }

    @Test
    public void testPackNestedOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        Assertions.assertThat((int)or1.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(1))).isSameAs((Object)pattern2);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)or1);
        or2.pack();
        Assertions.assertThat((int)or2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)or2.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)or2.getChildren().get(1))).isSameAs((Object)pattern2);
    }

    @Test
    public void testPackNestedExists() {
        GroupElement exists1 = GroupElementFactory.newExistsInstance();
        Pattern pattern1 = new Pattern(0, null);
        exists1.addChild((RuleConditionElement)pattern1);
        Assertions.assertThat((int)exists1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)exists1.getChildren().get(0))).isSameAs((Object)pattern1);
        GroupElement exists2 = GroupElementFactory.newExistsInstance();
        exists2.addChild((RuleConditionElement)exists1);
        exists2.pack();
        Assertions.assertThat((int)exists2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)exists2.getChildren().get(0))).isSameAs((Object)pattern1);
    }

    @Test
    public void testAddMultipleChildsIntoNot() {
        GroupElement not = GroupElementFactory.newNotInstance();
        Pattern pattern1 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern1);
        }
        catch (RuntimeException rde) {
            Assertions.fail((String)("Adding a single child is not supposed to throw Exception for NOT GE: " + rde.getMessage()));
        }
        Pattern pattern2 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern2);
            Assertions.fail((String)"Adding a second child into a NOT GE should throw Exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSingleBranchAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern);
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)pattern);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)and1);
        or1.pack();
        Assertions.assertThat((int)or1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern);
    }

    @Test
    public void testAddSingleBranchOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern);
        Assertions.assertThat((int)or1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        and1.pack();
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)pattern);
    }

    @Test
    public void testDeepNestedStructure() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)or1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(1))).isSameAs((Object)pattern2);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        Assertions.assertThat((int)or2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or2.getChildren().get(0))).isSameAs((Object)and1);
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        Assertions.assertThat((int)or2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or3.getChildren().get(0))).isSameAs((Object)or2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)or3);
        and2.pack();
        Assertions.assertThat((Comparable)and2.getType()).isEqualTo((Object)GroupElement.Type.OR);
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isSameAs((Object)pattern2);
    }

    @Test
    public void testDeepNestedStructureWithMultipleElementsInRoot() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        Assertions.assertThat((int)and1.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)and1.getChildren().get(0))).isSameAs((Object)or1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(1))).isSameAs((Object)pattern2);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        Assertions.assertThat((int)or2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or2.getChildren().get(0))).isSameAs((Object)and1);
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        Assertions.assertThat((int)or2.getChildren().size()).isEqualTo(1);
        Assertions.assertThat((Object)((RuleConditionElement)or3.getChildren().get(0))).isSameAs((Object)or2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        Pattern pattern3 = new Pattern(0, null);
        and2.addChild((RuleConditionElement)pattern3);
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)or3);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isSameAs((Object)pattern3);
        and2.pack();
        Assertions.assertThat((boolean)and2.isAnd()).isTrue();
        Assertions.assertThat((int)and2.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(0))).isSameAs((Object)or1);
        Assertions.assertThat((Object)((RuleConditionElement)and2.getChildren().get(1))).isSameAs((Object)pattern3);
        Assertions.assertThat((int)or1.getChildren().size()).isEqualTo(2);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(0))).isSameAs((Object)pattern1);
        Assertions.assertThat((Object)((RuleConditionElement)or1.getChildren().get(1))).isSameAs((Object)pattern2);
    }
}

