/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.nomvel;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.nomvel.TestUtil;
import org.drools.core.ClockType;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.Calendar;

public class TimerTest {
    @Test
    public void testIntervalTimer() throws Exception {
        String drl = "global java.util.List list \nrule xxx \n  timer (int:30s 10s) when \nthen \n  list.add(\"fired\"); \nend  \n";
        KieSession ksession = TestUtil.getKieSession(TimerTest.getCepKieModuleModel(), drl);
        ArrayList list = new ArrayList();
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        timeService.advanceTime(2L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimerWithDeclaration() {
        String drl = "import " + MyEvent.class.getCanonicalName() + "\nimport " + AtomicInteger.class.getCanonicalName() + "\ndeclare MyEvent\n    @role( event )\n    @timestamp( timestamp )\n    @expires( 10ms )\nend\n\nrule R\n    timer (int: 0 1; start=$startTime, repeat-limit=0 )\n    when\n       $event: MyEvent ($startTime : timestamp)\n       $counter : AtomicInteger(get() > 0)\n    then\n        System.out.println(\"RG_TEST_TIMER WITH \" + $event + \" AND \" + $counter);\n        modify($counter){\n            decrementAndGet()\n        }\nend";
        KieSession ksession = TestUtil.getKieSession(TimerTest.getCepKieModuleModel(), drl);
        try {
            long now = 1000L;
            PseudoClockScheduler sessionClock = (PseudoClockScheduler)ksession.getSessionClock();
            sessionClock.setStartupTime(990L);
            AtomicInteger counter = new AtomicInteger(1);
            MyEvent event1 = new MyEvent(992L);
            MyEvent event2 = new MyEvent(993L);
            MyEvent event3 = new MyEvent(994L);
            ksession.insert((Object)counter);
            ksession.insert((Object)event1);
            ksession.insert((Object)event2);
            ksession.insert((Object)event3);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(1);
            sessionClock.advanceTime(10L, TimeUnit.MILLISECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)counter.get()).isEqualTo(0);
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testExpressionTimer() {
        this.testExpressionTimer("timer (expr: $i, $i)");
    }

    @Test
    public void testExpressionTimerWithConstant() {
        this.testExpressionTimer("timer (expr: $i, $i; start=3-JAN-2010)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExpressionTimer(String timerExpr) {
        String drl = "package org.simple \nglobal java.util.List list \nrule xxx \n  " + timerExpr + " \nwhen \n   $i : Long() \nthen \n  list.add(\"fired\"); \nend  \n";
        KieSession ksession = TestUtil.getKieSession(TimerTest.getCepKieModuleModel(), drl);
        try {
            ArrayList list = new ArrayList();
            PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
            timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
            ksession.setGlobal("list", list);
            FactHandle fh = ksession.insert((Object)10000L);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(0);
            timeService.advanceTime(10L, TimeUnit.SECONDS);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(1);
            timeService.advanceTime(17L, TimeUnit.SECONDS);
            ksession.update(fh, (Object)5000L);
            ksession.fireAllRules();
            Assertions.assertThat((int)list.size()).isEqualTo(2);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCromTimer() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(Locale.UK);
            String str = "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"02-Jan-2010\"\n  date-expires \"06-Jan-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n";
            KieSession ksession = TestUtil.getKieSession(TimerTest.getCepKieModuleModel(), "package org.simple \nglobal java.util.List list \nrule xxx \n  date-effective \"02-Jan-2010\"\n  date-expires \"06-Jan-2010\"\n  calendars \"cal1\"\n  timer (cron: 0 0 0 * * ?) when \nthen \n  list.add(\"fired\"); \nend  \n");
            try {
                ArrayList list = new ArrayList();
                PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
                Date date = EvaluationUtil.convertDate((String)"01-Jan-2010");
                Calendar cal1 = timestamp -> true;
                long oneDay = 86400L;
                ksession.getCalendars().set("cal1", cal1);
                ksession.setGlobal("list", list);
                timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(0);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(1);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(2);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(3);
                timeService.advanceTime(86400L, TimeUnit.SECONDS);
                ksession.fireAllRules();
                Assertions.assertThat((int)list.size()).isEqualTo(3);
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    public static KieModuleModel getCepKieModuleModel() {
        KieModuleModel kproj = KieServices.get().newKieModuleModel();
        kproj.newKieBaseModel("kb").setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM).newKieSessionModel("ks").setDefault(true).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        return kproj;
    }

    public static class MyEvent {
        private long timestamp;

        public MyEvent(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return "MyEvent{timestamp=" + this.timestamp + '}';
        }
    }
}

