/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.notms;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.Message;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class NoTmsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NoTmsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testUnsupportedTms() {
        String drl = "package org.drools.test; \nrule A when\n $x : Integer() \nthen\n insertLogical( \"\" + $x ); \nend\nrule B when\n $x : String() \nthen\nend";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
        List errors = kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR});
        Assertions.assertThat((int)errors.size()).isEqualTo(1);
        Assertions.assertThat((boolean)((Message)errors.get(0)).getText().contains("drools-tms")).isTrue();
    }

    @Test
    public void testPlainInsert() {
        String drl = "package org.drools.test; \nrule A when\n $x : Integer() \nthen\n insert( \"\" + $x ); \nend\nrule B when\n $x : String() \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)1);
        Assertions.assertThat((int)ksession.fireAllRules()).isEqualTo(2);
    }
}

