/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.noxml;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.model.codegen.ExecutableModelProject;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.utils.KieHelper;

public class CommandTest {
    @Test
    public void kieCommands_notNull() {
        String drl = "rule R\nwhen\n  String()\nthen\nend\n";
        KieModuleModel kModuleModel = KieServices.get().newKieModuleModel();
        KieHelper kHelper = new KieHelper();
        KieBase kieBase = kHelper.setKieModuleModel(kModuleModel).addContent("rule R\nwhen\n  String()\nthen\nend\n", ResourceType.DRL).build(ExecutableModelProject.class, new KieBaseOption[0]);
        KieSession kieSession = kieBase.newKieSession();
        KieCommands kieCommands = KieServices.Factory.get().getCommands();
        Assertions.assertThat((Comparable)kieCommands).isNotNull();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(kieCommands.newInsert((Object)"test"));
        commands.add(kieCommands.newFireAllRules("fired"));
        BatchExecutionCommand batchExecutionCommand = CommandFactory.newBatchExecution(commands);
        ExecutionResults batchResult = (ExecutionResults)kieSession.execute((Command)batchExecutionCommand);
        Assertions.assertThat((Object)batchResult.getValue("fired")).isEqualTo((Object)1);
    }
}

