/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.ruleunits;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.junit.jupiter.api.Test;

public class RuleUnitInJarTest {
    private static final String TEST_JAR = "test-integration-ruleunits-jar.jar";
    private static final String TEST_UNIT_CLASS = "org.drools.compiler.integrationtests.ruleunits.HelloJarUnit";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void helloJar() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getClassLoader().getResource(TEST_JAR)}, tccl);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            Class<?> unitClass = urlClassLoader.loadClass(TEST_UNIT_CLASS);
            RuleUnitData unit = (RuleUnitData)unitClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method getStringsMethod = unitClass.getMethod("getStrings", new Class[0]);
            ((DataStore)getStringsMethod.invoke((Object)unit, new Object[0])).add((Object)"Hello Jar");
            try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance(unit);){
                Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
                Method getResultsMethod = unitClass.getMethod("getResults", new Class[0]);
                Assertions.assertThat((List)((List)getResultsMethod.invoke((Object)unit, new Object[0]))).containsExactlyInAnyOrder((Object[])new String[]{"it worked!", "it worked in decision table!"});
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Assertions.fail((String)"Fail with reflection", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

