/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.ruleunits.decisiontables;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.integrationtests.ruleunits.decisiontables.Applicant;
import org.drools.compiler.integrationtests.ruleunits.decisiontables.LoanApplication;
import org.drools.compiler.integrationtests.ruleunits.decisiontables.LoanUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.junit.jupiter.api.Test;

public class DecisionTablesTest {
    @Test
    public void decisionTable_basic() throws Exception {
        LoanUnit loanUnit = new LoanUnit();
        loanUnit.setMaxAmount(5000);
        try (RuleUnitInstance instance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)loanUnit);){
            Applicant applicant = new Applicant("John", 30);
            LoanApplication loanApplication = new LoanApplication("A001", applicant, 2000, 100);
            loanUnit.getLoanApplications().add((Object)loanApplication);
            List queryResult = instance.executeQuery("FindApproved", new Object[0]).toList("$l");
            Assertions.assertThat((List)queryResult).containsExactlyInAnyOrder((Object[])new LoanApplication[]{loanApplication});
            Assertions.assertThat((boolean)loanApplication.isApproved()).isTrue();
        }
    }

    @Test
    public void decisionTable_allRulesCoverage() throws Exception {
        LoanUnit loanUnit = new LoanUnit();
        loanUnit.setMaxAmount(5000);
        try (RuleUnitInstance instance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)loanUnit);){
            Applicant applicant1 = new Applicant("John", 30);
            LoanApplication loanApplication1 = new LoanApplication("A001", applicant1, 2000, 100);
            loanUnit.getLoanApplications().add((Object)loanApplication1);
            Applicant applicant2 = new Applicant("Paul", 28);
            LoanApplication loanApplication2 = new LoanApplication("A002", applicant2, 5000, 100);
            loanUnit.getLoanApplications().add((Object)loanApplication2);
            Applicant applicant3 = new Applicant("George", 27);
            LoanApplication loanApplication3 = new LoanApplication("A003", applicant3, 5000, 1000);
            loanUnit.getLoanApplications().add((Object)loanApplication3);
            Applicant applicant4 = new Applicant("Ringo", 30);
            LoanApplication loanApplication4 = new LoanApplication("A004", applicant4, 8000, 1000);
            loanUnit.getLoanApplications().add((Object)loanApplication4);
            Applicant applicant5 = new Applicant("Zak", 5);
            LoanApplication loanApplication5 = new LoanApplication("A005", applicant5, 2000, 100);
            loanUnit.getLoanApplications().add((Object)loanApplication5);
            List queryResult = instance.executeQuery("FindApproved", new Object[0]).toList("$l");
            Assertions.assertThat((List)queryResult).containsExactlyInAnyOrder((Object[])new LoanApplication[]{loanApplication1, loanApplication3});
            Assertions.assertThat((boolean)loanApplication1.isApproved()).isTrue();
            Assertions.assertThat((boolean)loanApplication2.isApproved()).isFalse();
            Assertions.assertThat((boolean)loanApplication3.isApproved()).isTrue();
            Assertions.assertThat((boolean)loanApplication4.isApproved()).isFalse();
            Assertions.assertThat((boolean)loanApplication5.isApproved()).isFalse();
        }
    }
}

