/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LoggingCacheListener
implements CacheListener {
    Log log = ExoLogger.getLogger((String)"exo.kernel.component.cache.LoggingCacheListener");

    public void onClearCache(CacheListenerContext context) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cleared region " + context.getCacheInfo().getName()));
        }
    }

    public void onExpire(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Expired entry " + key + " on region " + context.getCacheInfo().getName()));
        }
    }

    public void onGet(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Get entry " + key + " on region " + context.getCacheInfo().getName()));
        }
    }

    public void onPut(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Put entry " + key + " region " + context.getCacheInfo().getName()));
        }
        if (this.log.isWarnEnabled()) {
            double treshold;
            int maxSize = context.getCacheInfo().getMaxSize();
            int size = context.getCacheInfo().getSize();
            if ((double)size >= (treshold = (double)maxSize * 0.95)) {
                this.log.warn((Object)("region " + context.getCacheInfo().getName() + " is 95% full, consider extending maxSize"));
            }
        }
    }

    public void onRemove(CacheListenerContext context, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removed entry " + key + " region " + context.getCacheInfo().getName()));
        }
    }
}

