/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerContext<K, V>
implements CacheListenerContext,
CacheInfo {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.ListenerContext");
    private final ConcurrentFIFOExoCache cache;
    final CacheListener<? super K, ? super V> listener;

    public ListenerContext(CacheListener<? super K, ? super V> listener, ConcurrentFIFOExoCache cache) {
        this.listener = listener;
        this.cache = cache;
    }

    @Override
    public CacheInfo getCacheInfo() {
        return this;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public int getMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public long getLiveTime() {
        return this.cache.getLiveTime();
    }

    @Override
    public int getSize() {
        return this.cache.getCacheSize();
    }

    void onExpire(K key, V obj) {
        block2: {
            try {
                this.listener.onExpire(this, (Serializable)key, obj);
            }
            catch (Exception ignore) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
            }
        }
    }

    void onRemove(K key, V obj) {
        block2: {
            try {
                this.listener.onRemove(this, (Serializable)key, obj);
            }
            catch (Exception ignore) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
            }
        }
    }

    void onPut(K key, V obj) {
        block2: {
            try {
                this.listener.onPut(this, (Serializable)key, obj);
            }
            catch (Exception ignore) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
            }
        }
    }

    void onGet(K key, V obj) {
        block2: {
            try {
                this.listener.onGet(this, (Serializable)key, obj);
            }
            catch (Exception ignore) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
            }
        }
    }

    void onClearCache() {
        block2: {
            try {
                this.listener.onClearCache(this);
            }
            catch (Exception ignore) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ignore.getMessage()));
            }
        }
    }
}

