/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheConfigPlugin;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.impl.CacheServiceManaged;
import org.exoplatform.services.cache.impl.LoggingCacheListener;
import org.exoplatform.services.cache.invalidation.InvalidationExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBy(value=CacheServiceManaged.class)
public class CacheServiceImpl
implements CacheService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.CacheServiceImpl");
    private final ExoCacheFactory DEFAULT_FACTORY = new SimpleExoCacheFactory();
    private final HashMap<String, ExoCacheConfig> configs_ = new HashMap();
    private final ConcurrentHashMap<String, FutureExoCacheCreationTask> cacheMap_ = new ConcurrentHashMap();
    private final ExoCacheConfig defaultConfig_;
    private final LoggingCacheListener loggingListener_;
    private final ExoCacheFactory factory_;
    CacheServiceManaged managed;

    public CacheServiceImpl(InitParams params) throws Exception {
        this(params, null);
    }

    public CacheServiceImpl(InitParams params, ExoCacheFactory factory) throws Exception {
        List configs = params.getObjectParamValues(ExoCacheConfig.class);
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
        this.defaultConfig_ = this.configs_.get("default");
        this.loggingListener_ = new LoggingCacheListener();
        this.factory_ = factory == null ? this.DEFAULT_FACTORY : factory;
    }

    public void addExoCacheConfig(ComponentPlugin plugin) {
        this.addExoCacheConfig((ExoCacheConfigPlugin)plugin);
    }

    @Override
    public void addExoCacheConfig(ExoCacheConfigPlugin plugin) {
        List<ExoCacheConfig> configs = plugin.getConfigs();
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
    }

    @Override
    public <K extends Serializable, V> ExoCache<K, V> getCacheInstance(final String region) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null");
        }
        if (region.length() == 0) {
            throw new IllegalArgumentException("region cannot be empty");
        }
        FutureExoCacheCreationTask creationTask = this.cacheMap_.get(region);
        if (creationTask == null) {
            Callable task = new Callable<ExoCache<? extends Serializable, ?>>(){

                @Override
                public ExoCache<? extends Serializable, ?> call() throws Exception {
                    return CacheServiceImpl.this.createCacheInstance(region);
                }
            };
            creationTask = new FutureExoCacheCreationTask(task);
            FutureExoCacheCreationTask existingTask = this.cacheMap_.putIfAbsent(region, creationTask);
            if (existingTask != null) {
                creationTask = existingTask;
            } else {
                creationTask.run();
            }
        }
        try {
            return creationTask.get();
        }
        catch (CancellationException e) {
            this.cacheMap_.remove(region, creationTask);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error((Object)("Could not create the cache for the region '" + region + "'"), e.getCause());
        }
        return null;
    }

    protected void unregisterCacheInstance(String region) {
        LOG.info("Unregisters the cache {}", new Object[]{region});
        FutureExoCacheCreationTask task = this.cacheMap_.remove(region);
        if (task != null && this.managed != null) {
            try {
                LOG.info("Tries to unregister the cache {}", new Object[]{region});
                this.managed.unregisterCache((ExoCache<? extends Serializable, ?>)task.get());
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not unregister the cache " + region + ": " + e.getMessage()));
            }
        }
    }

    protected String getConfigId(String region) {
        return region;
    }

    private ExoCache<? extends Serializable, ?> createCacheInstance(String region) throws Exception {
        ExoCache simple;
        ExoCacheConfig safeConfig;
        block7: {
            ExoCacheConfig config = this.configs_.get(this.getConfigId(region));
            if (config == null) {
                config = this.defaultConfig_;
            }
            safeConfig = config.clone();
            safeConfig.setName(region);
            simple = null;
            if (this.factory_ != this.DEFAULT_FACTORY && safeConfig.getClass().isAssignableFrom(ExoCacheConfig.class) && safeConfig.getImplementation() != null) {
                try {
                    Class implClass = ClassLoading.loadClass((String)safeConfig.getImplementation(), (Object)this);
                    if (ExoCache.class.isAssignableFrom(implClass)) {
                        simple = this.DEFAULT_FACTORY.createCache(safeConfig);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
        if (simple == null) {
            simple = this.factory_.createCache(safeConfig);
        }
        if (this.managed != null) {
            this.managed.registerCache(simple);
        }
        return safeConfig.avoidValueReplication() && (safeConfig.isRepicated() || safeConfig.isDistributed()) ? new InvalidationExoCache(simple) : simple;
    }

    @Override
    public Collection<ExoCache<? extends Serializable, ?>> getAllCacheInstances() {
        ArrayList caches = new ArrayList(this.cacheMap_.size());
        for (FutureExoCacheCreationTask task : this.cacheMap_.values()) {
            ExoCache cache;
            block7: {
                cache = null;
                try {
                    cache = (ExoCache)((FutureTask)task).get();
                }
                catch (CancellationException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                catch (ExecutionException e) {
                    if (!LOG.isTraceEnabled()) break block7;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            if (cache == null) continue;
            caches.add(cache);
        }
        return caches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FutureExoCacheCreationTask
    extends FutureTask<ExoCache<? extends Serializable, ?>> {
        private volatile ExoCache<? extends Serializable, ?> cache;

        public FutureExoCacheCreationTask(Callable<ExoCache<? extends Serializable, ?>> callable) {
            super(callable);
        }

        @Override
        public ExoCache<? extends Serializable, ?> get() throws InterruptedException, ExecutionException {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = (ExoCache)super.get();
            return this.cache;
        }
    }

    private class SimpleExoCacheFactory
    implements ExoCacheFactory {
        private SimpleExoCacheFactory() {
        }

        public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
            ExoCache simple = this.createCacheInstance(config);
            simple.setName(config.getName());
            simple.setLabel(config.getLabel());
            simple.setMaxSize(config.getMaxSize());
            simple.setLiveTime(config.getLiveTime());
            simple.setLogEnabled(config.isLogEnabled());
            if (simple.isLogEnabled()) {
                simple.addCacheListener(CacheServiceImpl.this.loggingListener_);
            }
            return simple;
        }

        private ExoCache createCacheInstance(ExoCacheConfig config) throws ExoCacheInitException {
            if (config.getImplementation() == null) {
                return new SimpleExoCache();
            }
            try {
                Class clazz = ClassLoading.loadClass((String)config.getImplementation(), (Object)this);
                return (ExoCache)clazz.newInstance();
            }
            catch (ExceptionInInitializerError e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
            catch (SecurityException e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
            catch (InstantiationException e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
            catch (IllegalAccessException e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
        }
    }
}

