/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.spring;

import java.net.URL;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.spring.ApplicationContextProvider;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class FileSystemXmlApplicationContextProvider
implements ApplicationContextProvider {
    private static final String CONFIG_PATHS_PARAM_NAME = "config.paths";
    private final ValuesParam params;
    private final ConfigurationManager cm;

    public FileSystemXmlApplicationContextProvider(InitParams p, ConfigurationManager cm) {
        if (p == null || p.getValuesParam(CONFIG_PATHS_PARAM_NAME) == null) {
            throw new IllegalArgumentException("The values parameter config.paths is mandatory, please set at least one value.");
        }
        this.params = p.getValuesParam(CONFIG_PATHS_PARAM_NAME);
        this.cm = cm;
    }

    public ApplicationContext getApplicationContext(ApplicationContext parent) {
        try {
            String[] paths = new String[this.params.getValues().size()];
            int i = 0;
            for (String value : this.params.getValues()) {
                URL url = this.cm.getResource(value);
                paths[i++] = url.toURI().toString();
            }
            return new FileSystemXmlApplicationContext(paths, true, parent);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the ApplicationContext", e);
        }
    }
}

