/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.PrivilegedAction;
import javax.management.MBeanServer;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class J2EEServerInfo {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.J2EEServerInfo");
    public static final String EXO_CONF_PARAM = "exo.conf.dir";
    public static final String EXO_CONF_DIR_NAME_PARAM = "exo.conf.dir.name";
    private String serverName_;
    private String serverHome_;
    private String exoConfDir_;
    protected String sharedLibDirecotry_;
    protected String appDeployDirecotry_;
    protected MBeanServer mbeanServer;

    public J2EEServerInfo() {
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String exoConfHome;
                String jonasHome = System.getProperty("jonas.base");
                String jbossHome = System.getProperty("jboss.home.dir");
                String jettyHome = System.getProperty("jetty.home");
                String websphereHome = System.getProperty("was.install.root");
                String weblogicHome = System.getProperty("wls.home");
                String glassfishHome = System.getProperty("com.sun.aas.instanceRoot");
                String catalinaHome = System.getProperty("catalina.home");
                String testHome = System.getProperty("maven.exoplatform.dir");
                String confDirName = System.getProperty(J2EEServerInfo.EXO_CONF_DIR_NAME_PARAM, "exo-conf");
                if (jonasHome != null) {
                    J2EEServerInfo.this.serverName_ = "jonas";
                    J2EEServerInfo.this.serverHome_ = jonasHome;
                } else if (jbossHome != null) {
                    J2EEServerInfo.this.serverName_ = "jboss";
                    J2EEServerInfo.this.serverHome_ = jbossHome;
                    String jbossConfigUrl = System.getProperty("jboss.server.config.url");
                    if (jbossConfigUrl != null) {
                        try {
                            J2EEServerInfo.this.exoConfDir_ = new File(new File(new URI(jbossConfigUrl)), confDirName).getAbsolutePath();
                        }
                        catch (Throwable e) {}
                    } else {
                        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
                        if (jbossConfigDir != null) {
                            try {
                                J2EEServerInfo.this.exoConfDir_ = new File(jbossConfigDir, confDirName).getAbsolutePath();
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.mx.util.MBeanServerLocator");
                        Method m = clazz.getMethod("locateJBoss", new Class[0]);
                        J2EEServerInfo.this.mbeanServer = (MBeanServer)m.invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException ignore) {
                        LOG.debug((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                    }
                    catch (Exception ignore) {
                        LOG.error((Object)ignore.getLocalizedMessage(), (Throwable)ignore);
                    }
                } else if (jettyHome != null) {
                    J2EEServerInfo.this.serverName_ = "jetty";
                    J2EEServerInfo.this.serverHome_ = jettyHome;
                } else if (websphereHome != null) {
                    J2EEServerInfo.this.serverName_ = "websphere";
                    J2EEServerInfo.this.serverHome_ = websphereHome;
                } else if (weblogicHome != null) {
                    J2EEServerInfo.this.serverName_ = "weblogic";
                    J2EEServerInfo.this.serverHome_ = weblogicHome;
                } else if (glassfishHome != null) {
                    J2EEServerInfo.this.serverName_ = "glassfish";
                    J2EEServerInfo.this.serverHome_ = glassfishHome;
                } else if (catalinaHome != null) {
                    J2EEServerInfo.this.serverName_ = "tomcat";
                    J2EEServerInfo.this.serverHome_ = catalinaHome;
                } else if (testHome != null) {
                    J2EEServerInfo.this.serverName_ = "test";
                    J2EEServerInfo.this.serverHome_ = testHome;
                } else {
                    J2EEServerInfo.this.serverName_ = "standalone";
                    J2EEServerInfo.this.serverHome_ = System.getProperty("user.dir");
                }
                if (J2EEServerInfo.this.exoConfDir_ == null) {
                    J2EEServerInfo.this.exoConfDir_ = J2EEServerInfo.this.serverHome_ + "/" + confDirName;
                }
                if (J2EEServerInfo.this.mbeanServer == null) {
                    J2EEServerInfo.this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
                }
                if ((exoConfHome = System.getProperty(J2EEServerInfo.EXO_CONF_PARAM)) != null && exoConfHome.length() > 0) {
                    LOG.info((Object)("Override exo-conf directory '" + J2EEServerInfo.this.exoConfDir_ + "' with location '" + exoConfHome + "'"));
                    J2EEServerInfo.this.exoConfDir_ = exoConfHome;
                }
                J2EEServerInfo.this.serverHome_ = J2EEServerInfo.this.serverHome_.replace('\\', '/');
                J2EEServerInfo.this.exoConfDir_ = J2EEServerInfo.this.exoConfDir_.replace('\\', '/');
                return null;
            }
        });
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getServerHome() {
        return this.serverHome_;
    }

    public String getExoConfigurationDirectory() {
        return this.exoConfDir_;
    }

    public String getSharedLibDirectory() {
        return this.sharedLibDirecotry_;
    }

    public String getApplicationDeployDirectory() {
        return this.appDeployDirecotry_;
    }

    public boolean isJBoss() {
        return "jboss".equals(this.serverName_);
    }
}

